/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Represents a match condition that incoming network traffic is evaluated against.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SecurityPolicyRuleNetworkMatcher extends com.google.api.client.json.GenericJson {

  /**
   * Destination IPv4/IPv6 addresses or CIDR prefixes, in standard text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> destIpRanges;

  /**
   * Destination port numbers for TCP/UDP/SCTP. Each element can be a 16-bit unsigned decimal number
   * (e.g. "80") or range (e.g. "0-1023").
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> destPorts;

  /**
   * IPv4 protocol / IPv6 next header (after extension headers). Each element can be an 8-bit
   * unsigned decimal number (e.g. "6"), range (e.g. "253-254"), or one of the following protocol
   * names: "tcp", "udp", "icmp", "esp", "ah", "ipip", or "sctp".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> ipProtocols;

  /**
   * BGP Autonomous System Number associated with the source IP address.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.Long> srcAsns;

  /**
   * Source IPv4/IPv6 addresses or CIDR prefixes, in standard text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> srcIpRanges;

  /**
   * Source port numbers for TCP/UDP/SCTP. Each element can be a 16-bit unsigned decimal number
   * (e.g. "80") or range (e.g. "0-1023").
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> srcPorts;

  /**
   * Two-letter ISO 3166-1 alpha-2 country code associated with the source IP address.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> srcRegionCodes;

  /**
   * User-defined fields. Each element names a defined field and lists the matching values for that
   * field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch> userDefinedFields;

  /**
   * Destination IPv4/IPv6 addresses or CIDR prefixes, in standard text format.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getDestIpRanges() {
    return destIpRanges;
  }

  /**
   * Destination IPv4/IPv6 addresses or CIDR prefixes, in standard text format.
   * @param destIpRanges destIpRanges or {@code null} for none
   */
  public SecurityPolicyRuleNetworkMatcher setDestIpRanges(java.util.List<java.lang.String> destIpRanges) {
    this.destIpRanges = destIpRanges;
    return this;
  }

  /**
   * Destination port numbers for TCP/UDP/SCTP. Each element can be a 16-bit unsigned decimal number
   * (e.g. "80") or range (e.g. "0-1023").
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getDestPorts() {
    return destPorts;
  }

  /**
   * Destination port numbers for TCP/UDP/SCTP. Each element can be a 16-bit unsigned decimal number
   * (e.g. "80") or range (e.g. "0-1023").
   * @param destPorts destPorts or {@code null} for none
   */
  public SecurityPolicyRuleNetworkMatcher setDestPorts(java.util.List<java.lang.String> destPorts) {
    this.destPorts = destPorts;
    return this;
  }

  /**
   * IPv4 protocol / IPv6 next header (after extension headers). Each element can be an 8-bit
   * unsigned decimal number (e.g. "6"), range (e.g. "253-254"), or one of the following protocol
   * names: "tcp", "udp", "icmp", "esp", "ah", "ipip", or "sctp".
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getIpProtocols() {
    return ipProtocols;
  }

  /**
   * IPv4 protocol / IPv6 next header (after extension headers). Each element can be an 8-bit
   * unsigned decimal number (e.g. "6"), range (e.g. "253-254"), or one of the following protocol
   * names: "tcp", "udp", "icmp", "esp", "ah", "ipip", or "sctp".
   * @param ipProtocols ipProtocols or {@code null} for none
   */
  public SecurityPolicyRuleNetworkMatcher setIpProtocols(java.util.List<java.lang.String> ipProtocols) {
    this.ipProtocols = ipProtocols;
    return this;
  }

  /**
   * BGP Autonomous System Number associated with the source IP address.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Long> getSrcAsns() {
    return srcAsns;
  }

  /**
   * BGP Autonomous System Number associated with the source IP address.
   * @param srcAsns srcAsns or {@code null} for none
   */
  public SecurityPolicyRuleNetworkMatcher setSrcAsns(java.util.List<java.lang.Long> srcAsns) {
    this.srcAsns = srcAsns;
    return this;
  }

  /**
   * Source IPv4/IPv6 addresses or CIDR prefixes, in standard text format.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSrcIpRanges() {
    return srcIpRanges;
  }

  /**
   * Source IPv4/IPv6 addresses or CIDR prefixes, in standard text format.
   * @param srcIpRanges srcIpRanges or {@code null} for none
   */
  public SecurityPolicyRuleNetworkMatcher setSrcIpRanges(java.util.List<java.lang.String> srcIpRanges) {
    this.srcIpRanges = srcIpRanges;
    return this;
  }

  /**
   * Source port numbers for TCP/UDP/SCTP. Each element can be a 16-bit unsigned decimal number
   * (e.g. "80") or range (e.g. "0-1023").
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSrcPorts() {
    return srcPorts;
  }

  /**
   * Source port numbers for TCP/UDP/SCTP. Each element can be a 16-bit unsigned decimal number
   * (e.g. "80") or range (e.g. "0-1023").
   * @param srcPorts srcPorts or {@code null} for none
   */
  public SecurityPolicyRuleNetworkMatcher setSrcPorts(java.util.List<java.lang.String> srcPorts) {
    this.srcPorts = srcPorts;
    return this;
  }

  /**
   * Two-letter ISO 3166-1 alpha-2 country code associated with the source IP address.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSrcRegionCodes() {
    return srcRegionCodes;
  }

  /**
   * Two-letter ISO 3166-1 alpha-2 country code associated with the source IP address.
   * @param srcRegionCodes srcRegionCodes or {@code null} for none
   */
  public SecurityPolicyRuleNetworkMatcher setSrcRegionCodes(java.util.List<java.lang.String> srcRegionCodes) {
    this.srcRegionCodes = srcRegionCodes;
    return this;
  }

  /**
   * User-defined fields. Each element names a defined field and lists the matching values for that
   * field.
   * @return value or {@code null} for none
   */
  public java.util.List<SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch> getUserDefinedFields() {
    return userDefinedFields;
  }

  /**
   * User-defined fields. Each element names a defined field and lists the matching values for that
   * field.
   * @param userDefinedFields userDefinedFields or {@code null} for none
   */
  public SecurityPolicyRuleNetworkMatcher setUserDefinedFields(java.util.List<SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch> userDefinedFields) {
    this.userDefinedFields = userDefinedFields;
    return this;
  }

  @Override
  public SecurityPolicyRuleNetworkMatcher set(String fieldName, Object value) {
    return (SecurityPolicyRuleNetworkMatcher) super.set(fieldName, value);
  }

  @Override
  public SecurityPolicyRuleNetworkMatcher clone() {
    return (SecurityPolicyRuleNetworkMatcher) super.clone();
  }

}
