/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for SecurityPolicyRuleMatcherExprOptionsRecaptchaOptions.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SecurityPolicyRuleMatcherExprOptionsRecaptchaOptions extends com.google.api.client.json.GenericJson {

  /**
   * A list of site keys to be used during the validation of reCAPTCHA action-tokens. The provided
   * site keys need to be created from reCAPTCHA API under the same project where the security
   * policy is created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> actionTokenSiteKeys;

  /**
   * A list of site keys to be used during the validation of reCAPTCHA session-tokens. The provided
   * site keys need to be created from reCAPTCHA API under the same project where the security
   * policy is created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> sessionTokenSiteKeys;

  /**
   * A list of site keys to be used during the validation of reCAPTCHA action-tokens. The provided
   * site keys need to be created from reCAPTCHA API under the same project where the security
   * policy is created.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getActionTokenSiteKeys() {
    return actionTokenSiteKeys;
  }

  /**
   * A list of site keys to be used during the validation of reCAPTCHA action-tokens. The provided
   * site keys need to be created from reCAPTCHA API under the same project where the security
   * policy is created.
   * @param actionTokenSiteKeys actionTokenSiteKeys or {@code null} for none
   */
  public SecurityPolicyRuleMatcherExprOptionsRecaptchaOptions setActionTokenSiteKeys(java.util.List<java.lang.String> actionTokenSiteKeys) {
    this.actionTokenSiteKeys = actionTokenSiteKeys;
    return this;
  }

  /**
   * A list of site keys to be used during the validation of reCAPTCHA session-tokens. The provided
   * site keys need to be created from reCAPTCHA API under the same project where the security
   * policy is created.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSessionTokenSiteKeys() {
    return sessionTokenSiteKeys;
  }

  /**
   * A list of site keys to be used during the validation of reCAPTCHA session-tokens. The provided
   * site keys need to be created from reCAPTCHA API under the same project where the security
   * policy is created.
   * @param sessionTokenSiteKeys sessionTokenSiteKeys or {@code null} for none
   */
  public SecurityPolicyRuleMatcherExprOptionsRecaptchaOptions setSessionTokenSiteKeys(java.util.List<java.lang.String> sessionTokenSiteKeys) {
    this.sessionTokenSiteKeys = sessionTokenSiteKeys;
    return this;
  }

  @Override
  public SecurityPolicyRuleMatcherExprOptionsRecaptchaOptions set(String fieldName, Object value) {
    return (SecurityPolicyRuleMatcherExprOptionsRecaptchaOptions) super.set(fieldName, value);
  }

  @Override
  public SecurityPolicyRuleMatcherExprOptionsRecaptchaOptions clone() {
    return (SecurityPolicyRuleMatcherExprOptionsRecaptchaOptions) super.clone();
  }

}
