/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for RoutePolicyPolicyTerm.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RoutePolicyPolicyTerm extends com.google.api.client.json.GenericJson {

  /**
   * CEL expressions to evaluate to modify a route when this term matches.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Expr> actions;

  static {
    // hack to force ProGuard to consider Expr used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Expr.class);
  }

  /**
   * CEL expression evaluated against a route to determine if this term applies. When not set, the
   * term applies to all routes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Expr match;

  /**
   * The evaluation priority for this term, which must be between 0 (inclusive) and 2^31
   * (exclusive), and unique within the list.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer priority;

  /**
   * CEL expressions to evaluate to modify a route when this term matches.
   * @return value or {@code null} for none
   */
  public java.util.List<Expr> getActions() {
    return actions;
  }

  /**
   * CEL expressions to evaluate to modify a route when this term matches.
   * @param actions actions or {@code null} for none
   */
  public RoutePolicyPolicyTerm setActions(java.util.List<Expr> actions) {
    this.actions = actions;
    return this;
  }

  /**
   * CEL expression evaluated against a route to determine if this term applies. When not set, the
   * term applies to all routes.
   * @return value or {@code null} for none
   */
  public Expr getMatch() {
    return match;
  }

  /**
   * CEL expression evaluated against a route to determine if this term applies. When not set, the
   * term applies to all routes.
   * @param match match or {@code null} for none
   */
  public RoutePolicyPolicyTerm setMatch(Expr match) {
    this.match = match;
    return this;
  }

  /**
   * The evaluation priority for this term, which must be between 0 (inclusive) and 2^31
   * (exclusive), and unique within the list.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getPriority() {
    return priority;
  }

  /**
   * The evaluation priority for this term, which must be between 0 (inclusive) and 2^31
   * (exclusive), and unique within the list.
   * @param priority priority or {@code null} for none
   */
  public RoutePolicyPolicyTerm setPriority(java.lang.Integer priority) {
    this.priority = priority;
    return this;
  }

  @Override
  public RoutePolicyPolicyTerm set(String fieldName, Object value) {
    return (RoutePolicyPolicyTerm) super.set(fieldName, value);
  }

  @Override
  public RoutePolicyPolicyTerm clone() {
    return (RoutePolicyPolicyTerm) super.clone();
  }

}
