/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Represents the physical host topology of the host on which the VM is running.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ResourceStatusPhysicalHostTopology extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] The ID of the block in which the running instance is located. Instances within
   * the same block experience low network latency.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String block;

  /**
   * [Output Only] The global name of the Compute Engine cluster where the running instance is
   * located.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String cluster;

  /**
   * [Output Only] The ID of the host on which the running instance is located. Instances on the
   * same host experience the lowest possible network latency.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String host;

  /**
   * [Output Only] The ID of the sub-block in which the running instance is located. Instances in
   * the same sub-block experience lower network latency than instances in the same block.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String subblock;

  /**
   * [Output Only] The ID of the block in which the running instance is located. Instances within
   * the same block experience low network latency.
   * @return value or {@code null} for none
   */
  public java.lang.String getBlock() {
    return block;
  }

  /**
   * [Output Only] The ID of the block in which the running instance is located. Instances within
   * the same block experience low network latency.
   * @param block block or {@code null} for none
   */
  public ResourceStatusPhysicalHostTopology setBlock(java.lang.String block) {
    this.block = block;
    return this;
  }

  /**
   * [Output Only] The global name of the Compute Engine cluster where the running instance is
   * located.
   * @return value or {@code null} for none
   */
  public java.lang.String getCluster() {
    return cluster;
  }

  /**
   * [Output Only] The global name of the Compute Engine cluster where the running instance is
   * located.
   * @param cluster cluster or {@code null} for none
   */
  public ResourceStatusPhysicalHostTopology setCluster(java.lang.String cluster) {
    this.cluster = cluster;
    return this;
  }

  /**
   * [Output Only] The ID of the host on which the running instance is located. Instances on the
   * same host experience the lowest possible network latency.
   * @return value or {@code null} for none
   */
  public java.lang.String getHost() {
    return host;
  }

  /**
   * [Output Only] The ID of the host on which the running instance is located. Instances on the
   * same host experience the lowest possible network latency.
   * @param host host or {@code null} for none
   */
  public ResourceStatusPhysicalHostTopology setHost(java.lang.String host) {
    this.host = host;
    return this;
  }

  /**
   * [Output Only] The ID of the sub-block in which the running instance is located. Instances in
   * the same sub-block experience lower network latency than instances in the same block.
   * @return value or {@code null} for none
   */
  public java.lang.String getSubblock() {
    return subblock;
  }

  /**
   * [Output Only] The ID of the sub-block in which the running instance is located. Instances in
   * the same sub-block experience lower network latency than instances in the same block.
   * @param subblock subblock or {@code null} for none
   */
  public ResourceStatusPhysicalHostTopology setSubblock(java.lang.String subblock) {
    this.subblock = subblock;
    return this;
  }

  @Override
  public ResourceStatusPhysicalHostTopology set(String fieldName, Object value) {
    return (ResourceStatusPhysicalHostTopology) super.set(fieldName, value);
  }

  @Override
  public ResourceStatusPhysicalHostTopology clone() {
    return (ResourceStatusPhysicalHostTopology) super.clone();
  }

}
