/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Represents the workload policy.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ResourcePolicyWorkloadPolicy extends com.google.api.client.json.GenericJson {

  /**
   * Specifies the topology required to create a partition for VMs that have interconnected GPUs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String acceleratorTopology;

  /**
   * Specifies the maximum distance between instances.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String maxTopologyDistance;

  /**
   * Specifies the intent of the instance placement in the MIG.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Specifies the topology required to create a partition for VMs that have interconnected GPUs.
   * @return value or {@code null} for none
   */
  public java.lang.String getAcceleratorTopology() {
    return acceleratorTopology;
  }

  /**
   * Specifies the topology required to create a partition for VMs that have interconnected GPUs.
   * @param acceleratorTopology acceleratorTopology or {@code null} for none
   */
  public ResourcePolicyWorkloadPolicy setAcceleratorTopology(java.lang.String acceleratorTopology) {
    this.acceleratorTopology = acceleratorTopology;
    return this;
  }

  /**
   * Specifies the maximum distance between instances.
   * @return value or {@code null} for none
   */
  public java.lang.String getMaxTopologyDistance() {
    return maxTopologyDistance;
  }

  /**
   * Specifies the maximum distance between instances.
   * @param maxTopologyDistance maxTopologyDistance or {@code null} for none
   */
  public ResourcePolicyWorkloadPolicy setMaxTopologyDistance(java.lang.String maxTopologyDistance) {
    this.maxTopologyDistance = maxTopologyDistance;
    return this;
  }

  /**
   * Specifies the intent of the instance placement in the MIG.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Specifies the intent of the instance placement in the MIG.
   * @param type type or {@code null} for none
   */
  public ResourcePolicyWorkloadPolicy setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public ResourcePolicyWorkloadPolicy set(String fieldName, Object value) {
    return (ResourcePolicyWorkloadPolicy) super.set(fieldName, value);
  }

  @Override
  public ResourcePolicyWorkloadPolicy clone() {
    return (ResourcePolicyWorkloadPolicy) super.clone();
  }

}
