/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for ReservationSubBlocksReportFaultyRequest.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReservationSubBlocksReportFaultyRequest extends com.google.api.client.json.GenericJson {

  /**
   * The disruption schedule for the subBlock.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String disruptionSchedule;

  /**
   * The component that experienced the fault.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String failureComponent;

  /**
   * The reasons for the fault experienced with the subBlock.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ReservationSubBlocksReportFaultyRequestFaultReason> faultReasons;

  /**
   * The disruption schedule for the subBlock.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisruptionSchedule() {
    return disruptionSchedule;
  }

  /**
   * The disruption schedule for the subBlock.
   * @param disruptionSchedule disruptionSchedule or {@code null} for none
   */
  public ReservationSubBlocksReportFaultyRequest setDisruptionSchedule(java.lang.String disruptionSchedule) {
    this.disruptionSchedule = disruptionSchedule;
    return this;
  }

  /**
   * The component that experienced the fault.
   * @return value or {@code null} for none
   */
  public java.lang.String getFailureComponent() {
    return failureComponent;
  }

  /**
   * The component that experienced the fault.
   * @param failureComponent failureComponent or {@code null} for none
   */
  public ReservationSubBlocksReportFaultyRequest setFailureComponent(java.lang.String failureComponent) {
    this.failureComponent = failureComponent;
    return this;
  }

  /**
   * The reasons for the fault experienced with the subBlock.
   * @return value or {@code null} for none
   */
  public java.util.List<ReservationSubBlocksReportFaultyRequestFaultReason> getFaultReasons() {
    return faultReasons;
  }

  /**
   * The reasons for the fault experienced with the subBlock.
   * @param faultReasons faultReasons or {@code null} for none
   */
  public ReservationSubBlocksReportFaultyRequest setFaultReasons(java.util.List<ReservationSubBlocksReportFaultyRequestFaultReason> faultReasons) {
    this.faultReasons = faultReasons;
    return this;
  }

  @Override
  public ReservationSubBlocksReportFaultyRequest set(String fieldName, Object value) {
    return (ReservationSubBlocksReportFaultyRequest) super.set(fieldName, value);
  }

  @Override
  public ReservationSubBlocksReportFaultyRequest clone() {
    return (ReservationSubBlocksReportFaultyRequest) super.clone();
  }

}
