/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Health information for the reservation subBlock.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReservationSubBlockHealthInfo extends com.google.api.client.json.GenericJson {

  /**
   * The number of degraded hosts in the reservation subBlock.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer degradedHostCount;

  /**
   * The number of degraded infrastructure (e.g NV link domain) in the reservation subblock.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer degradedInfraCount;

  /**
   * The health status of the reservation subBlock.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String healthStatus;

  /**
   * The number of healthy hosts in the reservation subBlock.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer healthyHostCount;

  /**
   * The number of healthy infrastructure (e.g NV link domain) in the reservation subblock.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer healthyInfraCount;

  /**
   * The number of degraded hosts in the reservation subBlock.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getDegradedHostCount() {
    return degradedHostCount;
  }

  /**
   * The number of degraded hosts in the reservation subBlock.
   * @param degradedHostCount degradedHostCount or {@code null} for none
   */
  public ReservationSubBlockHealthInfo setDegradedHostCount(java.lang.Integer degradedHostCount) {
    this.degradedHostCount = degradedHostCount;
    return this;
  }

  /**
   * The number of degraded infrastructure (e.g NV link domain) in the reservation subblock.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getDegradedInfraCount() {
    return degradedInfraCount;
  }

  /**
   * The number of degraded infrastructure (e.g NV link domain) in the reservation subblock.
   * @param degradedInfraCount degradedInfraCount or {@code null} for none
   */
  public ReservationSubBlockHealthInfo setDegradedInfraCount(java.lang.Integer degradedInfraCount) {
    this.degradedInfraCount = degradedInfraCount;
    return this;
  }

  /**
   * The health status of the reservation subBlock.
   * @return value or {@code null} for none
   */
  public java.lang.String getHealthStatus() {
    return healthStatus;
  }

  /**
   * The health status of the reservation subBlock.
   * @param healthStatus healthStatus or {@code null} for none
   */
  public ReservationSubBlockHealthInfo setHealthStatus(java.lang.String healthStatus) {
    this.healthStatus = healthStatus;
    return this;
  }

  /**
   * The number of healthy hosts in the reservation subBlock.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getHealthyHostCount() {
    return healthyHostCount;
  }

  /**
   * The number of healthy hosts in the reservation subBlock.
   * @param healthyHostCount healthyHostCount or {@code null} for none
   */
  public ReservationSubBlockHealthInfo setHealthyHostCount(java.lang.Integer healthyHostCount) {
    this.healthyHostCount = healthyHostCount;
    return this;
  }

  /**
   * The number of healthy infrastructure (e.g NV link domain) in the reservation subblock.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getHealthyInfraCount() {
    return healthyInfraCount;
  }

  /**
   * The number of healthy infrastructure (e.g NV link domain) in the reservation subblock.
   * @param healthyInfraCount healthyInfraCount or {@code null} for none
   */
  public ReservationSubBlockHealthInfo setHealthyInfraCount(java.lang.Integer healthyInfraCount) {
    this.healthyInfraCount = healthyInfraCount;
    return this;
  }

  @Override
  public ReservationSubBlockHealthInfo set(String fieldName, Object value) {
    return (ReservationSubBlockHealthInfo) super.set(fieldName, value);
  }

  @Override
  public ReservationSubBlockHealthInfo clone() {
    return (ReservationSubBlockHealthInfo) super.clone();
  }

}
