/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] Deprecated, please use short name instead. The display name of the firewall
   * policy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * [Output Only] The name of the firewall policy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * [Output Only] The packet mirroring rules that apply to the network.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<FirewallPolicyRule> packetMirroringRules;

  static {
    // hack to force ProGuard to consider FirewallPolicyRule used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(FirewallPolicyRule.class);
  }

  /**
   * [Output only] Priority of firewall policy association. Not applicable for type=HIERARCHY.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer priority;

  /**
   * [Output Only] The rules that apply to the network.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<FirewallPolicyRule> rules;

  static {
    // hack to force ProGuard to consider FirewallPolicyRule used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(FirewallPolicyRule.class);
  }

  /**
   * [Output Only] The short name of the firewall policy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String shortName;

  /**
   * [Output Only] The type of the firewall policy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * [Output Only] Deprecated, please use short name instead. The display name of the firewall
   * policy.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * [Output Only] Deprecated, please use short name instead. The display name of the firewall
   * policy.
   * @param displayName displayName or {@code null} for none
   */
  public NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * [Output Only] The name of the firewall policy.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * [Output Only] The name of the firewall policy.
   * @param name name or {@code null} for none
   */
  public NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * [Output Only] The packet mirroring rules that apply to the network.
   * @return value or {@code null} for none
   */
  public java.util.List<FirewallPolicyRule> getPacketMirroringRules() {
    return packetMirroringRules;
  }

  /**
   * [Output Only] The packet mirroring rules that apply to the network.
   * @param packetMirroringRules packetMirroringRules or {@code null} for none
   */
  public NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy setPacketMirroringRules(java.util.List<FirewallPolicyRule> packetMirroringRules) {
    this.packetMirroringRules = packetMirroringRules;
    return this;
  }

  /**
   * [Output only] Priority of firewall policy association. Not applicable for type=HIERARCHY.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getPriority() {
    return priority;
  }

  /**
   * [Output only] Priority of firewall policy association. Not applicable for type=HIERARCHY.
   * @param priority priority or {@code null} for none
   */
  public NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy setPriority(java.lang.Integer priority) {
    this.priority = priority;
    return this;
  }

  /**
   * [Output Only] The rules that apply to the network.
   * @return value or {@code null} for none
   */
  public java.util.List<FirewallPolicyRule> getRules() {
    return rules;
  }

  /**
   * [Output Only] The rules that apply to the network.
   * @param rules rules or {@code null} for none
   */
  public NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy setRules(java.util.List<FirewallPolicyRule> rules) {
    this.rules = rules;
    return this;
  }

  /**
   * [Output Only] The short name of the firewall policy.
   * @return value or {@code null} for none
   */
  public java.lang.String getShortName() {
    return shortName;
  }

  /**
   * [Output Only] The short name of the firewall policy.
   * @param shortName shortName or {@code null} for none
   */
  public NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy setShortName(java.lang.String shortName) {
    this.shortName = shortName;
    return this;
  }

  /**
   * [Output Only] The type of the firewall policy.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * [Output Only] The type of the firewall policy.
   * @param type type or {@code null} for none
   */
  public NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy set(String fieldName, Object value) {
    return (NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy) super.set(fieldName, value);
  }

  @Override
  public NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy clone() {
    return (NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy) super.clone();
  }

}
