/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A routing configuration attached to a network resource. The message includes the list of routers
 * associated with the network, and a flag indicating the type of routing behavior to enforce
 * network-wide.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NetworkRoutingConfig extends com.google.api.client.json.GenericJson {

  /**
   * Enable comparison of Multi-Exit Discriminators (MED) across routes with different neighbor ASNs
   * when using the STANDARD BGP best path selection algorithm.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean bgpAlwaysCompareMed;

  /**
   * The BGP best path selection algorithm to be employed within this network for dynamic routes
   * learned by Cloud Routers. Can be LEGACY (default) or STANDARD.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bgpBestPathSelectionMode;

  /**
   * Allows to define a preferred approach for handling inter-region cost in the selection process
   * when using the STANDARD BGP best path selection algorithm. Can be DEFAULT orADD_COST_TO_MED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bgpInterRegionCost;

  /**
   * [Output Only] Effective value of the bgp_always_compare_med field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean effectiveBgpAlwaysCompareMed;

  /**
   * [Output Only] Effective value of the bgp_inter_region_cost field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String effectiveBgpInterRegionCost;

  /**
   * The network-wide routing mode to use. If set to REGIONAL, this network's Cloud Routers will
   * only advertise routes with subnets of this network in the same region as the router. If set
   * toGLOBAL, this network's Cloud Routers will advertise routes with all subnets of this network,
   * across regions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String routingMode;

  /**
   * Enable comparison of Multi-Exit Discriminators (MED) across routes with different neighbor ASNs
   * when using the STANDARD BGP best path selection algorithm.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getBgpAlwaysCompareMed() {
    return bgpAlwaysCompareMed;
  }

  /**
   * Enable comparison of Multi-Exit Discriminators (MED) across routes with different neighbor ASNs
   * when using the STANDARD BGP best path selection algorithm.
   * @param bgpAlwaysCompareMed bgpAlwaysCompareMed or {@code null} for none
   */
  public NetworkRoutingConfig setBgpAlwaysCompareMed(java.lang.Boolean bgpAlwaysCompareMed) {
    this.bgpAlwaysCompareMed = bgpAlwaysCompareMed;
    return this;
  }

  /**
   * The BGP best path selection algorithm to be employed within this network for dynamic routes
   * learned by Cloud Routers. Can be LEGACY (default) or STANDARD.
   * @return value or {@code null} for none
   */
  public java.lang.String getBgpBestPathSelectionMode() {
    return bgpBestPathSelectionMode;
  }

  /**
   * The BGP best path selection algorithm to be employed within this network for dynamic routes
   * learned by Cloud Routers. Can be LEGACY (default) or STANDARD.
   * @param bgpBestPathSelectionMode bgpBestPathSelectionMode or {@code null} for none
   */
  public NetworkRoutingConfig setBgpBestPathSelectionMode(java.lang.String bgpBestPathSelectionMode) {
    this.bgpBestPathSelectionMode = bgpBestPathSelectionMode;
    return this;
  }

  /**
   * Allows to define a preferred approach for handling inter-region cost in the selection process
   * when using the STANDARD BGP best path selection algorithm. Can be DEFAULT orADD_COST_TO_MED.
   * @return value or {@code null} for none
   */
  public java.lang.String getBgpInterRegionCost() {
    return bgpInterRegionCost;
  }

  /**
   * Allows to define a preferred approach for handling inter-region cost in the selection process
   * when using the STANDARD BGP best path selection algorithm. Can be DEFAULT orADD_COST_TO_MED.
   * @param bgpInterRegionCost bgpInterRegionCost or {@code null} for none
   */
  public NetworkRoutingConfig setBgpInterRegionCost(java.lang.String bgpInterRegionCost) {
    this.bgpInterRegionCost = bgpInterRegionCost;
    return this;
  }

  /**
   * [Output Only] Effective value of the bgp_always_compare_med field.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEffectiveBgpAlwaysCompareMed() {
    return effectiveBgpAlwaysCompareMed;
  }

  /**
   * [Output Only] Effective value of the bgp_always_compare_med field.
   * @param effectiveBgpAlwaysCompareMed effectiveBgpAlwaysCompareMed or {@code null} for none
   */
  public NetworkRoutingConfig setEffectiveBgpAlwaysCompareMed(java.lang.Boolean effectiveBgpAlwaysCompareMed) {
    this.effectiveBgpAlwaysCompareMed = effectiveBgpAlwaysCompareMed;
    return this;
  }

  /**
   * [Output Only] Effective value of the bgp_inter_region_cost field.
   * @return value or {@code null} for none
   */
  public java.lang.String getEffectiveBgpInterRegionCost() {
    return effectiveBgpInterRegionCost;
  }

  /**
   * [Output Only] Effective value of the bgp_inter_region_cost field.
   * @param effectiveBgpInterRegionCost effectiveBgpInterRegionCost or {@code null} for none
   */
  public NetworkRoutingConfig setEffectiveBgpInterRegionCost(java.lang.String effectiveBgpInterRegionCost) {
    this.effectiveBgpInterRegionCost = effectiveBgpInterRegionCost;
    return this;
  }

  /**
   * The network-wide routing mode to use. If set to REGIONAL, this network's Cloud Routers will
   * only advertise routes with subnets of this network in the same region as the router. If set
   * toGLOBAL, this network's Cloud Routers will advertise routes with all subnets of this network,
   * across regions.
   * @return value or {@code null} for none
   */
  public java.lang.String getRoutingMode() {
    return routingMode;
  }

  /**
   * The network-wide routing mode to use. If set to REGIONAL, this network's Cloud Routers will
   * only advertise routes with subnets of this network in the same region as the router. If set
   * toGLOBAL, this network's Cloud Routers will advertise routes with all subnets of this network,
   * across regions.
   * @param routingMode routingMode or {@code null} for none
   */
  public NetworkRoutingConfig setRoutingMode(java.lang.String routingMode) {
    this.routingMode = routingMode;
    return this;
  }

  @Override
  public NetworkRoutingConfig set(String fieldName, Object value) {
    return (NetworkRoutingConfig) super.set(fieldName, value);
  }

  @Override
  public NetworkRoutingConfig clone() {
    return (NetworkRoutingConfig) super.clone();
  }

}
