/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * All data that is specifically relevant to only network endpoint groups of type
 * PRIVATE_SERVICE_CONNECT.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NetworkEndpointGroupPscData extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] Address allocated from given subnetwork for PSC. This IP address acts as a VIP
   * for a PSC NEG, allowing it to act as an endpoint in L7 PSC-XLB.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String consumerPscAddress;

  /**
   * The psc producer port is used to connect PSC NEG with specific port on the PSC Producer side;
   * should only be used for the PRIVATE_SERVICE_CONNECT NEG type
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer producerPort;

  /**
   * [Output Only] The PSC connection id of the PSC Network Endpoint Group Consumer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger pscConnectionId;

  /**
   * [Output Only] The connection status of the PSC Forwarding Rule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pscConnectionStatus;

  /**
   * [Output Only] Address allocated from given subnetwork for PSC. This IP address acts as a VIP
   * for a PSC NEG, allowing it to act as an endpoint in L7 PSC-XLB.
   * @return value or {@code null} for none
   */
  public java.lang.String getConsumerPscAddress() {
    return consumerPscAddress;
  }

  /**
   * [Output Only] Address allocated from given subnetwork for PSC. This IP address acts as a VIP
   * for a PSC NEG, allowing it to act as an endpoint in L7 PSC-XLB.
   * @param consumerPscAddress consumerPscAddress or {@code null} for none
   */
  public NetworkEndpointGroupPscData setConsumerPscAddress(java.lang.String consumerPscAddress) {
    this.consumerPscAddress = consumerPscAddress;
    return this;
  }

  /**
   * The psc producer port is used to connect PSC NEG with specific port on the PSC Producer side;
   * should only be used for the PRIVATE_SERVICE_CONNECT NEG type
   * @return value or {@code null} for none
   */
  public java.lang.Integer getProducerPort() {
    return producerPort;
  }

  /**
   * The psc producer port is used to connect PSC NEG with specific port on the PSC Producer side;
   * should only be used for the PRIVATE_SERVICE_CONNECT NEG type
   * @param producerPort producerPort or {@code null} for none
   */
  public NetworkEndpointGroupPscData setProducerPort(java.lang.Integer producerPort) {
    this.producerPort = producerPort;
    return this;
  }

  /**
   * [Output Only] The PSC connection id of the PSC Network Endpoint Group Consumer.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getPscConnectionId() {
    return pscConnectionId;
  }

  /**
   * [Output Only] The PSC connection id of the PSC Network Endpoint Group Consumer.
   * @param pscConnectionId pscConnectionId or {@code null} for none
   */
  public NetworkEndpointGroupPscData setPscConnectionId(java.math.BigInteger pscConnectionId) {
    this.pscConnectionId = pscConnectionId;
    return this;
  }

  /**
   * [Output Only] The connection status of the PSC Forwarding Rule.
   * @return value or {@code null} for none
   */
  public java.lang.String getPscConnectionStatus() {
    return pscConnectionStatus;
  }

  /**
   * [Output Only] The connection status of the PSC Forwarding Rule.
   * @param pscConnectionStatus pscConnectionStatus or {@code null} for none
   */
  public NetworkEndpointGroupPscData setPscConnectionStatus(java.lang.String pscConnectionStatus) {
    this.pscConnectionStatus = pscConnectionStatus;
    return this;
  }

  @Override
  public NetworkEndpointGroupPscData set(String fieldName, Object value) {
    return (NetworkEndpointGroupPscData) super.set(fieldName, value);
  }

  @Override
  public NetworkEndpointGroupPscData clone() {
    return (NetworkEndpointGroupPscData) super.clone();
  }

}
