/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * MACsec configuration information for the Interconnect connection. Contains the generated
 * Connectivity Association Key Name (CKN) and the key (CAK) for this Interconnect connection.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InterconnectMacsecConfig extends com.google.api.client.json.GenericJson {

  /**
   * A keychain placeholder describing a set of named key objects along with their start times. A
   * MACsec CKN/CAK is generated for each key in the key chain. Google router automatically picks
   * the key with the most recent startTime when establishing or re-establishing a MACsec secure
   * link.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<InterconnectMacsecConfigPreSharedKey> preSharedKeys;

  /**
   * A keychain placeholder describing a set of named key objects along with their start times. A
   * MACsec CKN/CAK is generated for each key in the key chain. Google router automatically picks
   * the key with the most recent startTime when establishing or re-establishing a MACsec secure
   * link.
   * @return value or {@code null} for none
   */
  public java.util.List<InterconnectMacsecConfigPreSharedKey> getPreSharedKeys() {
    return preSharedKeys;
  }

  /**
   * A keychain placeholder describing a set of named key objects along with their start times. A
   * MACsec CKN/CAK is generated for each key in the key chain. Google router automatically picks
   * the key with the most recent startTime when establishing or re-establishing a MACsec secure
   * link.
   * @param preSharedKeys preSharedKeys or {@code null} for none
   */
  public InterconnectMacsecConfig setPreSharedKeys(java.util.List<InterconnectMacsecConfigPreSharedKey> preSharedKeys) {
    this.preSharedKeys = preSharedKeys;
    return this;
  }

  @Override
  public InterconnectMacsecConfig set(String fieldName, Object value) {
    return (InterconnectMacsecConfig) super.set(fieldName, value);
  }

  @Override
  public InterconnectMacsecConfig clone() {
    return (InterconnectMacsecConfig) super.clone();
  }

}
