/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * The status of one Attachment in the group. List order is arbitrary.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InterconnectAttachmentGroupsOperationalStatusAttachmentStatus extends com.google.api.client.json.GenericJson {

  /**
   * Whether this Attachment is enabled. This becomes false when the customer drains their
   * Attachment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean adminEnabled;

  /**
   * The URL of the Attachment being described.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String attachment;

  /**
   * Whether this Attachment is participating in the redundant configuration. This will be ACTIVE if
   * and only if the status below is CONNECTION_UP. Any INACTIVE Attachments are excluded from the
   * analysis that generates operational.availabilitySLA.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String isActive;

  /**
   * Whether this Attachment is active, and if so, whether BGP is up.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * Whether this Attachment is enabled. This becomes false when the customer drains their
   * Attachment.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAdminEnabled() {
    return adminEnabled;
  }

  /**
   * Whether this Attachment is enabled. This becomes false when the customer drains their
   * Attachment.
   * @param adminEnabled adminEnabled or {@code null} for none
   */
  public InterconnectAttachmentGroupsOperationalStatusAttachmentStatus setAdminEnabled(java.lang.Boolean adminEnabled) {
    this.adminEnabled = adminEnabled;
    return this;
  }

  /**
   * The URL of the Attachment being described.
   * @return value or {@code null} for none
   */
  public java.lang.String getAttachment() {
    return attachment;
  }

  /**
   * The URL of the Attachment being described.
   * @param attachment attachment or {@code null} for none
   */
  public InterconnectAttachmentGroupsOperationalStatusAttachmentStatus setAttachment(java.lang.String attachment) {
    this.attachment = attachment;
    return this;
  }

  /**
   * Whether this Attachment is participating in the redundant configuration. This will be ACTIVE if
   * and only if the status below is CONNECTION_UP. Any INACTIVE Attachments are excluded from the
   * analysis that generates operational.availabilitySLA.
   * @return value or {@code null} for none
   */
  public java.lang.String getIsActive() {
    return isActive;
  }

  /**
   * Whether this Attachment is participating in the redundant configuration. This will be ACTIVE if
   * and only if the status below is CONNECTION_UP. Any INACTIVE Attachments are excluded from the
   * analysis that generates operational.availabilitySLA.
   * @param isActive isActive or {@code null} for none
   */
  public InterconnectAttachmentGroupsOperationalStatusAttachmentStatus setIsActive(java.lang.String isActive) {
    this.isActive = isActive;
    return this;
  }

  /**
   * Whether this Attachment is active, and if so, whether BGP is up.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * Whether this Attachment is active, and if so, whether BGP is up.
   * @param status status or {@code null} for none
   */
  public InterconnectAttachmentGroupsOperationalStatusAttachmentStatus setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  @Override
  public InterconnectAttachmentGroupsOperationalStatusAttachmentStatus set(String fieldName, Object value) {
    return (InterconnectAttachmentGroupsOperationalStatusAttachmentStatus) super.set(fieldName, value);
  }

  @Override
  public InterconnectAttachmentGroupsOperationalStatusAttachmentStatus clone() {
    return (InterconnectAttachmentGroupsOperationalStatusAttachmentStatus) super.clone();
  }

}
