/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * [Output Only] The zones that Attachments in this group are present in, in the given facilities.
 * This is inherited from their Interconnects.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InterconnectAttachmentGroupLogicalStructureRegionMetroFacilityZone extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] URLs of Attachments in the given zone, to the given region, on Interconnects in
   * the given facility and metro. Every Attachment in the AG has such an entry.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> attachments;

  /**
   * [Output Only] The name of a zone, either "zone1" or "zone2".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String zone;

  /**
   * [Output Only] URLs of Attachments in the given zone, to the given region, on Interconnects in
   * the given facility and metro. Every Attachment in the AG has such an entry.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getAttachments() {
    return attachments;
  }

  /**
   * [Output Only] URLs of Attachments in the given zone, to the given region, on Interconnects in
   * the given facility and metro. Every Attachment in the AG has such an entry.
   * @param attachments attachments or {@code null} for none
   */
  public InterconnectAttachmentGroupLogicalStructureRegionMetroFacilityZone setAttachments(java.util.List<java.lang.String> attachments) {
    this.attachments = attachments;
    return this;
  }

  /**
   * [Output Only] The name of a zone, either "zone1" or "zone2".
   * @return value or {@code null} for none
   */
  public java.lang.String getZone() {
    return zone;
  }

  /**
   * [Output Only] The name of a zone, either "zone1" or "zone2".
   * @param zone zone or {@code null} for none
   */
  public InterconnectAttachmentGroupLogicalStructureRegionMetroFacilityZone setZone(java.lang.String zone) {
    this.zone = zone;
    return this;
  }

  @Override
  public InterconnectAttachmentGroupLogicalStructureRegionMetroFacilityZone set(String fieldName, Object value) {
    return (InterconnectAttachmentGroupLogicalStructureRegionMetroFacilityZone) super.set(fieldName, value);
  }

  @Override
  public InterconnectAttachmentGroupLogicalStructureRegionMetroFacilityZone clone() {
    return (InterconnectAttachmentGroupLogicalStructureRegionMetroFacilityZone) super.clone();
  }

}
