/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * An interconnect attachment group resource allows customers to create, analyze, and expand highly
 * available deployments.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InterconnectAttachmentGroup extends com.google.api.client.json.GenericJson {

  /**
   * Attachments in the AttachmentGroup. Keys are arbitrary user-specified strings. Users are
   * encouraged, but not required, to use their preferred format for resource links as keys. Note
   * that there are add-members and remove-members methods in gcloud. The size of this map is
   * limited by an "Attachments per group" quota.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, InterconnectAttachmentGroupAttachment> attachments;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InterconnectAttachmentGroupConfigured configured;

  /**
   * [Output Only] Creation timestamp inRFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Opaque system-generated token that uniquely identifies the configuration. If provided when
   * patching a configuration in update mode, the provided token must match the current token or the
   * update is rejected. This provides a reliable means of doing read-modify-write (optimistic
   * locking) as described byAIP 154.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * [Output Only] The unique identifier for the resource type. The server generates this
   * identifier.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InterconnectAttachmentGroupIntent intent;

  /**
   * The URL of an InterconnectGroup that groups these Attachments' Interconnects. Customers do not
   * need to set this unless directed by Google Support.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String interconnectGroup;

  /**
   * [Output Only] Type of the resource. Always compute#interconnectAttachmentGroup.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InterconnectAttachmentGroupLogicalStructure logicalStructure;

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply withRFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * [Output Only] Server-defined URL for the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * Attachments in the AttachmentGroup. Keys are arbitrary user-specified strings. Users are
   * encouraged, but not required, to use their preferred format for resource links as keys. Note
   * that there are add-members and remove-members methods in gcloud. The size of this map is
   * limited by an "Attachments per group" quota.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, InterconnectAttachmentGroupAttachment> getAttachments() {
    return attachments;
  }

  /**
   * Attachments in the AttachmentGroup. Keys are arbitrary user-specified strings. Users are
   * encouraged, but not required, to use their preferred format for resource links as keys. Note
   * that there are add-members and remove-members methods in gcloud. The size of this map is
   * limited by an "Attachments per group" quota.
   * @param attachments attachments or {@code null} for none
   */
  public InterconnectAttachmentGroup setAttachments(java.util.Map<String, InterconnectAttachmentGroupAttachment> attachments) {
    this.attachments = attachments;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public InterconnectAttachmentGroupConfigured getConfigured() {
    return configured;
  }

  /**
   * @param configured configured or {@code null} for none
   */
  public InterconnectAttachmentGroup setConfigured(InterconnectAttachmentGroupConfigured configured) {
    this.configured = configured;
    return this;
  }

  /**
   * [Output Only] Creation timestamp inRFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * [Output Only] Creation timestamp inRFC3339 text format.
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public InterconnectAttachmentGroup setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @param description description or {@code null} for none
   */
  public InterconnectAttachmentGroup setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Opaque system-generated token that uniquely identifies the configuration. If provided when
   * patching a configuration in update mode, the provided token must match the current token or the
   * update is rejected. This provides a reliable means of doing read-modify-write (optimistic
   * locking) as described byAIP 154.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * Opaque system-generated token that uniquely identifies the configuration. If provided when
   * patching a configuration in update mode, the provided token must match the current token or the
   * update is rejected. This provides a reliable means of doing read-modify-write (optimistic
   * locking) as described byAIP 154.
   * @param etag etag or {@code null} for none
   */
  public InterconnectAttachmentGroup setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * [Output Only] The unique identifier for the resource type. The server generates this
   * identifier.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * [Output Only] The unique identifier for the resource type. The server generates this
   * identifier.
   * @param id id or {@code null} for none
   */
  public InterconnectAttachmentGroup setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public InterconnectAttachmentGroupIntent getIntent() {
    return intent;
  }

  /**
   * @param intent intent or {@code null} for none
   */
  public InterconnectAttachmentGroup setIntent(InterconnectAttachmentGroupIntent intent) {
    this.intent = intent;
    return this;
  }

  /**
   * The URL of an InterconnectGroup that groups these Attachments' Interconnects. Customers do not
   * need to set this unless directed by Google Support.
   * @return value or {@code null} for none
   */
  public java.lang.String getInterconnectGroup() {
    return interconnectGroup;
  }

  /**
   * The URL of an InterconnectGroup that groups these Attachments' Interconnects. Customers do not
   * need to set this unless directed by Google Support.
   * @param interconnectGroup interconnectGroup or {@code null} for none
   */
  public InterconnectAttachmentGroup setInterconnectGroup(java.lang.String interconnectGroup) {
    this.interconnectGroup = interconnectGroup;
    return this;
  }

  /**
   * [Output Only] Type of the resource. Always compute#interconnectAttachmentGroup.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] Type of the resource. Always compute#interconnectAttachmentGroup.
   * @param kind kind or {@code null} for none
   */
  public InterconnectAttachmentGroup setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public InterconnectAttachmentGroupLogicalStructure getLogicalStructure() {
    return logicalStructure;
  }

  /**
   * @param logicalStructure logicalStructure or {@code null} for none
   */
  public InterconnectAttachmentGroup setLogicalStructure(InterconnectAttachmentGroupLogicalStructure logicalStructure) {
    this.logicalStructure = logicalStructure;
    return this;
  }

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply withRFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply withRFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @param name name or {@code null} for none
   */
  public InterconnectAttachmentGroup setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public InterconnectAttachmentGroup setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  @Override
  public InterconnectAttachmentGroup set(String fieldName, Object value) {
    return (InterconnectAttachmentGroup) super.set(fieldName, value);
  }

  @Override
  public InterconnectAttachmentGroup clone() {
    return (InterconnectAttachmentGroup) super.clone();
  }

}
