/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InstanceGroupManagerAllInstancesConfig.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstanceGroupManagerAllInstancesConfig extends com.google.api.client.json.GenericJson {

  /**
   * Properties to set on all instances in the group.
   *
   * You can add or modify properties using theinstanceGroupManagers.patch
   * orregionInstanceGroupManagers.patch. After settingallInstancesConfig on the group, you must
   * update the group's instances to apply the configuration. To apply the configuration, set the
   * group's updatePolicy.type field to use proactive updates or use the applyUpdatesToInstances
   * method.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InstancePropertiesPatch properties;

  /**
   * Properties to set on all instances in the group.
   *
   * You can add or modify properties using theinstanceGroupManagers.patch
   * orregionInstanceGroupManagers.patch. After settingallInstancesConfig on the group, you must
   * update the group's instances to apply the configuration. To apply the configuration, set the
   * group's updatePolicy.type field to use proactive updates or use the applyUpdatesToInstances
   * method.
   * @return value or {@code null} for none
   */
  public InstancePropertiesPatch getProperties() {
    return properties;
  }

  /**
   * Properties to set on all instances in the group.
   *
   * You can add or modify properties using theinstanceGroupManagers.patch
   * orregionInstanceGroupManagers.patch. After settingallInstancesConfig on the group, you must
   * update the group's instances to apply the configuration. To apply the configuration, set the
   * group's updatePolicy.type field to use proactive updates or use the applyUpdatesToInstances
   * method.
   * @param properties properties or {@code null} for none
   */
  public InstanceGroupManagerAllInstancesConfig setProperties(InstancePropertiesPatch properties) {
    this.properties = properties;
    return this;
  }

  @Override
  public InstanceGroupManagerAllInstancesConfig set(String fieldName, Object value) {
    return (InstanceGroupManagerAllInstancesConfig) super.set(fieldName, value);
  }

  @Override
  public InstanceGroupManagerAllInstancesConfig clone() {
    return (InstanceGroupManagerAllInstancesConfig) super.clone();
  }

}
