/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for GRPCTLSHealthCheck.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GRPCTLSHealthCheck extends com.google.api.client.json.GenericJson {

  /**
   * The gRPC service name for the health check. This field is optional. The value of
   * grpc_service_name has the following meanings by convention:
   *
   * - Empty service_name means the overall status of all services at the backend.
   *
   * - Non-empty service_name means the health of that gRPC service, as defined by the owner of the
   * service.
   *
   * The grpc_service_name can only be ASCII.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String grpcServiceName;

  /**
   * The TCP port number to which the health check prober sends packets. Valid values are 1 through
   * 65535.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer port;

  /**
   * Specifies how a port is selected for health checking. Can be one of the following values:
   * USE_FIXED_PORT: Specifies a port number explicitly using theport field  in the health check.
   * Supported by backend services for passthrough load balancers and backend services for proxy
   * load balancers. Not supported by target pools. The health check supports all backends supported
   * by the backend service provided the backend can be health checked. For example, GCE_VM_IP
   * network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends.
   * USE_NAMED_PORT: Not supported.  USE_SERVING_PORT: Provides an indirect method of specifying the
   * health check port by referring to the backend service. Only supported by backend services for
   * proxy load balancers. Not supported by target pools.  Not supported by backend services for
   * passthrough load balancers. Supports all backends that can be health checked; for
   * example,GCE_VM_IP_PORT network endpoint groups and instance group backends.
   *
   * For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number
   * specified for each endpoint in the network endpoint group.  For instance group backends, the
   * health check uses the port number determined by looking up the backend service's named port in
   * the instance group's list of named ports.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String portSpecification;

  /**
   * The gRPC service name for the health check. This field is optional. The value of
   * grpc_service_name has the following meanings by convention:
   *
   * - Empty service_name means the overall status of all services at the backend.
   *
   * - Non-empty service_name means the health of that gRPC service, as defined by the owner of the
   * service.
   *
   * The grpc_service_name can only be ASCII.
   * @return value or {@code null} for none
   */
  public java.lang.String getGrpcServiceName() {
    return grpcServiceName;
  }

  /**
   * The gRPC service name for the health check. This field is optional. The value of
   * grpc_service_name has the following meanings by convention:
   *
   * - Empty service_name means the overall status of all services at the backend.
   *
   * - Non-empty service_name means the health of that gRPC service, as defined by the owner of the
   * service.
   *
   * The grpc_service_name can only be ASCII.
   * @param grpcServiceName grpcServiceName or {@code null} for none
   */
  public GRPCTLSHealthCheck setGrpcServiceName(java.lang.String grpcServiceName) {
    this.grpcServiceName = grpcServiceName;
    return this;
  }

  /**
   * The TCP port number to which the health check prober sends packets. Valid values are 1 through
   * 65535.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getPort() {
    return port;
  }

  /**
   * The TCP port number to which the health check prober sends packets. Valid values are 1 through
   * 65535.
   * @param port port or {@code null} for none
   */
  public GRPCTLSHealthCheck setPort(java.lang.Integer port) {
    this.port = port;
    return this;
  }

  /**
   * Specifies how a port is selected for health checking. Can be one of the following values:
   * USE_FIXED_PORT: Specifies a port number explicitly using theport field  in the health check.
   * Supported by backend services for passthrough load balancers and backend services for proxy
   * load balancers. Not supported by target pools. The health check supports all backends supported
   * by the backend service provided the backend can be health checked. For example, GCE_VM_IP
   * network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends.
   * USE_NAMED_PORT: Not supported.  USE_SERVING_PORT: Provides an indirect method of specifying the
   * health check port by referring to the backend service. Only supported by backend services for
   * proxy load balancers. Not supported by target pools.  Not supported by backend services for
   * passthrough load balancers. Supports all backends that can be health checked; for
   * example,GCE_VM_IP_PORT network endpoint groups and instance group backends.
   *
   * For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number
   * specified for each endpoint in the network endpoint group.  For instance group backends, the
   * health check uses the port number determined by looking up the backend service's named port in
   * the instance group's list of named ports.
   * @return value or {@code null} for none
   */
  public java.lang.String getPortSpecification() {
    return portSpecification;
  }

  /**
   * Specifies how a port is selected for health checking. Can be one of the following values:
   * USE_FIXED_PORT: Specifies a port number explicitly using theport field  in the health check.
   * Supported by backend services for passthrough load balancers and backend services for proxy
   * load balancers. Not supported by target pools. The health check supports all backends supported
   * by the backend service provided the backend can be health checked. For example, GCE_VM_IP
   * network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends.
   * USE_NAMED_PORT: Not supported.  USE_SERVING_PORT: Provides an indirect method of specifying the
   * health check port by referring to the backend service. Only supported by backend services for
   * proxy load balancers. Not supported by target pools.  Not supported by backend services for
   * passthrough load balancers. Supports all backends that can be health checked; for
   * example,GCE_VM_IP_PORT network endpoint groups and instance group backends.
   *
   * For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number
   * specified for each endpoint in the network endpoint group.  For instance group backends, the
   * health check uses the port number determined by looking up the backend service's named port in
   * the instance group's list of named ports.
   * @param portSpecification portSpecification or {@code null} for none
   */
  public GRPCTLSHealthCheck setPortSpecification(java.lang.String portSpecification) {
    this.portSpecification = portSpecification;
    return this;
  }

  @Override
  public GRPCTLSHealthCheck set(String fieldName, Object value) {
    return (GRPCTLSHealthCheck) super.set(fieldName, value);
  }

  @Override
  public GRPCTLSHealthCheck clone() {
    return (GRPCTLSHealthCheck) super.clone();
  }

}
