/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for BgpRouteAsPath.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BgpRouteAsPath extends com.google.api.client.json.GenericJson {

  /**
   * [Output only] ASNs in the path segment. When type is SEQUENCE, these are ordered.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.Integer> asns;

  /**
   * [Output only] ASNs in the path segment. This field is for better support of 32 bit ASNs as the
   * other asns field suffers from overflow when the ASN is larger. When type is SEQUENCE, these are
   * ordered.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.Long> asns32;

  /**
   * [Output only] Type of AS-PATH segment (SEQUENCE or SET)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * [Output only] ASNs in the path segment. When type is SEQUENCE, these are ordered.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Integer> getAsns() {
    return asns;
  }

  /**
   * [Output only] ASNs in the path segment. When type is SEQUENCE, these are ordered.
   * @param asns asns or {@code null} for none
   */
  public BgpRouteAsPath setAsns(java.util.List<java.lang.Integer> asns) {
    this.asns = asns;
    return this;
  }

  /**
   * [Output only] ASNs in the path segment. This field is for better support of 32 bit ASNs as the
   * other asns field suffers from overflow when the ASN is larger. When type is SEQUENCE, these are
   * ordered.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Long> getAsns32() {
    return asns32;
  }

  /**
   * [Output only] ASNs in the path segment. This field is for better support of 32 bit ASNs as the
   * other asns field suffers from overflow when the ASN is larger. When type is SEQUENCE, these are
   * ordered.
   * @param asns32 asns32 or {@code null} for none
   */
  public BgpRouteAsPath setAsns32(java.util.List<java.lang.Long> asns32) {
    this.asns32 = asns32;
    return this;
  }

  /**
   * [Output only] Type of AS-PATH segment (SEQUENCE or SET)
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * [Output only] Type of AS-PATH segment (SEQUENCE or SET)
   * @param type type or {@code null} for none
   */
  public BgpRouteAsPath setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public BgpRouteAsPath set(String fieldName, Object value) {
    return (BgpRouteAsPath) super.set(fieldName, value);
  }

  @Override
  public BgpRouteAsPath clone() {
    return (BgpRouteAsPath) super.clone();
  }

}
