/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for BgpRoute.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BgpRoute extends com.google.api.client.json.GenericJson {

  /**
   * [Output only] AS-PATH for the route
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<BgpRouteAsPath> asPaths;

  /**
   * [Output only] BGP communities in human-readable A:B format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> communities;

  /**
   * [Output only] Destination IP range for the route, in human-readable CIDR format
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BgpRouteNetworkLayerReachabilityInformation destination;

  /**
   * [Output only] BGP multi-exit discriminator
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long med;

  /**
   * [Output only] BGP origin (EGP, IGP or INCOMPLETE)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String origin;

  /**
   * [Output only] AS-PATH for the route
   * @return value or {@code null} for none
   */
  public java.util.List<BgpRouteAsPath> getAsPaths() {
    return asPaths;
  }

  /**
   * [Output only] AS-PATH for the route
   * @param asPaths asPaths or {@code null} for none
   */
  public BgpRoute setAsPaths(java.util.List<BgpRouteAsPath> asPaths) {
    this.asPaths = asPaths;
    return this;
  }

  /**
   * [Output only] BGP communities in human-readable A:B format.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getCommunities() {
    return communities;
  }

  /**
   * [Output only] BGP communities in human-readable A:B format.
   * @param communities communities or {@code null} for none
   */
  public BgpRoute setCommunities(java.util.List<java.lang.String> communities) {
    this.communities = communities;
    return this;
  }

  /**
   * [Output only] Destination IP range for the route, in human-readable CIDR format
   * @return value or {@code null} for none
   */
  public BgpRouteNetworkLayerReachabilityInformation getDestination() {
    return destination;
  }

  /**
   * [Output only] Destination IP range for the route, in human-readable CIDR format
   * @param destination destination or {@code null} for none
   */
  public BgpRoute setDestination(BgpRouteNetworkLayerReachabilityInformation destination) {
    this.destination = destination;
    return this;
  }

  /**
   * [Output only] BGP multi-exit discriminator
   * @return value or {@code null} for none
   */
  public java.lang.Long getMed() {
    return med;
  }

  /**
   * [Output only] BGP multi-exit discriminator
   * @param med med or {@code null} for none
   */
  public BgpRoute setMed(java.lang.Long med) {
    this.med = med;
    return this;
  }

  /**
   * [Output only] BGP origin (EGP, IGP or INCOMPLETE)
   * @return value or {@code null} for none
   */
  public java.lang.String getOrigin() {
    return origin;
  }

  /**
   * [Output only] BGP origin (EGP, IGP or INCOMPLETE)
   * @param origin origin or {@code null} for none
   */
  public BgpRoute setOrigin(java.lang.String origin) {
    this.origin = origin;
    return this;
  }

  @Override
  public BgpRoute set(String fieldName, Object value) {
    return (BgpRoute) super.set(fieldName, value);
  }

  @Override
  public BgpRoute clone() {
    return (BgpRoute) super.clone();
  }

}
