/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for BackendServiceTlsSettings.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BackendServiceTlsSettings extends com.google.api.client.json.GenericJson {

  /**
   * Reference to the BackendAuthenticationConfig resource from the networksecurity.googleapis.com
   * namespace. Can be used in authenticating TLS connections to the backend, as specified by the
   * authenticationMode field. Can only be specified if authenticationMode is not NONE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String authenticationConfig;

  /**
   * Server Name Indication - see RFC3546 section 3.1. If set, the load balancer sends this string
   * as the SNI hostname in the TLS connection to the backend, and requires that this string match a
   * Subject Alternative Name (SAN) in the backend's server certificate. With a Regional Internet
   * NEG backend, if the SNI is specified here, the load balancer uses it regardless of whether the
   * Regional Internet NEG is specified with FQDN or IP address and port. When both sni and
   * subjectAltNames[] are specified, the load balancer matches the backend certificate's SAN only
   * to subjectAltNames[].
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sni;

  /**
   * A list of Subject Alternative Names (SANs) that the Load Balancer verifies during a TLS
   * handshake with the backend. When the server presents its X.509 certificate to the Load
   * Balancer, the Load Balancer inspects the certificate's SAN field, and requires that at least
   * one SAN match one of the subjectAltNames in the list. This field is limited to 5 entries. When
   * both sni and subjectAltNames[] are specified, the load balancer matches the backend
   * certificate's SAN only to subjectAltNames[].
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<BackendServiceTlsSettingsSubjectAltName> subjectAltNames;

  /**
   * Reference to the BackendAuthenticationConfig resource from the networksecurity.googleapis.com
   * namespace. Can be used in authenticating TLS connections to the backend, as specified by the
   * authenticationMode field. Can only be specified if authenticationMode is not NONE.
   * @return value or {@code null} for none
   */
  public java.lang.String getAuthenticationConfig() {
    return authenticationConfig;
  }

  /**
   * Reference to the BackendAuthenticationConfig resource from the networksecurity.googleapis.com
   * namespace. Can be used in authenticating TLS connections to the backend, as specified by the
   * authenticationMode field. Can only be specified if authenticationMode is not NONE.
   * @param authenticationConfig authenticationConfig or {@code null} for none
   */
  public BackendServiceTlsSettings setAuthenticationConfig(java.lang.String authenticationConfig) {
    this.authenticationConfig = authenticationConfig;
    return this;
  }

  /**
   * Server Name Indication - see RFC3546 section 3.1. If set, the load balancer sends this string
   * as the SNI hostname in the TLS connection to the backend, and requires that this string match a
   * Subject Alternative Name (SAN) in the backend's server certificate. With a Regional Internet
   * NEG backend, if the SNI is specified here, the load balancer uses it regardless of whether the
   * Regional Internet NEG is specified with FQDN or IP address and port. When both sni and
   * subjectAltNames[] are specified, the load balancer matches the backend certificate's SAN only
   * to subjectAltNames[].
   * @return value or {@code null} for none
   */
  public java.lang.String getSni() {
    return sni;
  }

  /**
   * Server Name Indication - see RFC3546 section 3.1. If set, the load balancer sends this string
   * as the SNI hostname in the TLS connection to the backend, and requires that this string match a
   * Subject Alternative Name (SAN) in the backend's server certificate. With a Regional Internet
   * NEG backend, if the SNI is specified here, the load balancer uses it regardless of whether the
   * Regional Internet NEG is specified with FQDN or IP address and port. When both sni and
   * subjectAltNames[] are specified, the load balancer matches the backend certificate's SAN only
   * to subjectAltNames[].
   * @param sni sni or {@code null} for none
   */
  public BackendServiceTlsSettings setSni(java.lang.String sni) {
    this.sni = sni;
    return this;
  }

  /**
   * A list of Subject Alternative Names (SANs) that the Load Balancer verifies during a TLS
   * handshake with the backend. When the server presents its X.509 certificate to the Load
   * Balancer, the Load Balancer inspects the certificate's SAN field, and requires that at least
   * one SAN match one of the subjectAltNames in the list. This field is limited to 5 entries. When
   * both sni and subjectAltNames[] are specified, the load balancer matches the backend
   * certificate's SAN only to subjectAltNames[].
   * @return value or {@code null} for none
   */
  public java.util.List<BackendServiceTlsSettingsSubjectAltName> getSubjectAltNames() {
    return subjectAltNames;
  }

  /**
   * A list of Subject Alternative Names (SANs) that the Load Balancer verifies during a TLS
   * handshake with the backend. When the server presents its X.509 certificate to the Load
   * Balancer, the Load Balancer inspects the certificate's SAN field, and requires that at least
   * one SAN match one of the subjectAltNames in the list. This field is limited to 5 entries. When
   * both sni and subjectAltNames[] are specified, the load balancer matches the backend
   * certificate's SAN only to subjectAltNames[].
   * @param subjectAltNames subjectAltNames or {@code null} for none
   */
  public BackendServiceTlsSettings setSubjectAltNames(java.util.List<BackendServiceTlsSettingsSubjectAltName> subjectAltNames) {
    this.subjectAltNames = subjectAltNames;
    return this;
  }

  @Override
  public BackendServiceTlsSettings set(String fieldName, Object value) {
    return (BackendServiceTlsSettings) super.set(fieldName, value);
  }

  @Override
  public BackendServiceTlsSettings clone() {
    return (BackendServiceTlsSettings) super.clone();
  }

}
