/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Bypass the cache when the specified request headers are present, e.g. Pragma or Authorization
 * headers. Values are case insensitive. The presence of such a header overrides the cache_mode
 * setting.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BackendBucketCdnPolicyBypassCacheOnRequestHeader extends com.google.api.client.json.GenericJson {

  /**
   * The header field name to match on when bypassing cache. Values are case-insensitive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String headerName;

  /**
   * The header field name to match on when bypassing cache. Values are case-insensitive.
   * @return value or {@code null} for none
   */
  public java.lang.String getHeaderName() {
    return headerName;
  }

  /**
   * The header field name to match on when bypassing cache. Values are case-insensitive.
   * @param headerName headerName or {@code null} for none
   */
  public BackendBucketCdnPolicyBypassCacheOnRequestHeader setHeaderName(java.lang.String headerName) {
    this.headerName = headerName;
    return this;
  }

  @Override
  public BackendBucketCdnPolicyBypassCacheOnRequestHeader set(String fieldName, Object value) {
    return (BackendBucketCdnPolicyBypassCacheOnRequestHeader) super.set(fieldName, value);
  }

  @Override
  public BackendBucketCdnPolicyBypassCacheOnRequestHeader clone() {
    return (BackendBucketCdnPolicyBypassCacheOnRequestHeader) super.clone();
  }

}
