/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for SecurityPolicyRuleRateLimitOptionsThreshold.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SecurityPolicyRuleRateLimitOptionsThreshold extends com.google.api.client.json.GenericJson {

  /**
   * Number of HTTP(S) requests for calculating the threshold.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer count;

  /**
   * Interval over which the threshold is computed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer intervalSec;

  /**
   * Number of HTTP(S) requests for calculating the threshold.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getCount() {
    return count;
  }

  /**
   * Number of HTTP(S) requests for calculating the threshold.
   * @param count count or {@code null} for none
   */
  public SecurityPolicyRuleRateLimitOptionsThreshold setCount(java.lang.Integer count) {
    this.count = count;
    return this;
  }

  /**
   * Interval over which the threshold is computed.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getIntervalSec() {
    return intervalSec;
  }

  /**
   * Interval over which the threshold is computed.
   * @param intervalSec intervalSec or {@code null} for none
   */
  public SecurityPolicyRuleRateLimitOptionsThreshold setIntervalSec(java.lang.Integer intervalSec) {
    this.intervalSec = intervalSec;
    return this;
  }

  @Override
  public SecurityPolicyRuleRateLimitOptionsThreshold set(String fieldName, Object value) {
    return (SecurityPolicyRuleRateLimitOptionsThreshold) super.set(fieldName, value);
  }

  @Override
  public SecurityPolicyRuleRateLimitOptionsThreshold clone() {
    return (SecurityPolicyRuleRateLimitOptionsThreshold) super.clone();
  }

}
