/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * HttpRouteRuleMatch criteria for field values that must stay within the specified integer range.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Int64RangeMatch extends com.google.api.client.json.GenericJson {

  /**
   * The end of the range (exclusive) in signed long integer format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long rangeEnd;

  /**
   * The start of the range (inclusive) in signed long integer format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long rangeStart;

  /**
   * The end of the range (exclusive) in signed long integer format.
   * @return value or {@code null} for none
   */
  public java.lang.Long getRangeEnd() {
    return rangeEnd;
  }

  /**
   * The end of the range (exclusive) in signed long integer format.
   * @param rangeEnd rangeEnd or {@code null} for none
   */
  public Int64RangeMatch setRangeEnd(java.lang.Long rangeEnd) {
    this.rangeEnd = rangeEnd;
    return this;
  }

  /**
   * The start of the range (inclusive) in signed long integer format.
   * @return value or {@code null} for none
   */
  public java.lang.Long getRangeStart() {
    return rangeStart;
  }

  /**
   * The start of the range (inclusive) in signed long integer format.
   * @param rangeStart rangeStart or {@code null} for none
   */
  public Int64RangeMatch setRangeStart(java.lang.Long rangeStart) {
    this.rangeStart = rangeStart;
    return this;
  }

  @Override
  public Int64RangeMatch set(String fieldName, Object value) {
    return (Int64RangeMatch) super.set(fieldName, value);
  }

  @Override
  public Int64RangeMatch clone() {
    return (Int64RangeMatch) super.clone();
  }

}
