/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InstanceManagedByIgmError.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstanceManagedByIgmError extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] Contents of the error.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InstanceManagedByIgmErrorManagedInstanceError error;

  /**
   * [Output Only] Details of the instance action that triggered this error. May be null, if the
   * error was not caused by an action on an instance. This field is optional.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InstanceManagedByIgmErrorInstanceActionDetails instanceActionDetails;

  /**
   * [Output Only] The time that this error occurred. This value is in RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String timestamp;

  /**
   * [Output Only] Contents of the error.
   * @return value or {@code null} for none
   */
  public InstanceManagedByIgmErrorManagedInstanceError getError() {
    return error;
  }

  /**
   * [Output Only] Contents of the error.
   * @param error error or {@code null} for none
   */
  public InstanceManagedByIgmError setError(InstanceManagedByIgmErrorManagedInstanceError error) {
    this.error = error;
    return this;
  }

  /**
   * [Output Only] Details of the instance action that triggered this error. May be null, if the
   * error was not caused by an action on an instance. This field is optional.
   * @return value or {@code null} for none
   */
  public InstanceManagedByIgmErrorInstanceActionDetails getInstanceActionDetails() {
    return instanceActionDetails;
  }

  /**
   * [Output Only] Details of the instance action that triggered this error. May be null, if the
   * error was not caused by an action on an instance. This field is optional.
   * @param instanceActionDetails instanceActionDetails or {@code null} for none
   */
  public InstanceManagedByIgmError setInstanceActionDetails(InstanceManagedByIgmErrorInstanceActionDetails instanceActionDetails) {
    this.instanceActionDetails = instanceActionDetails;
    return this;
  }

  /**
   * [Output Only] The time that this error occurred. This value is in RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getTimestamp() {
    return timestamp;
  }

  /**
   * [Output Only] The time that this error occurred. This value is in RFC3339 text format.
   * @param timestamp timestamp or {@code null} for none
   */
  public InstanceManagedByIgmError setTimestamp(java.lang.String timestamp) {
    this.timestamp = timestamp;
    return this;
  }

  @Override
  public InstanceManagedByIgmError set(String fieldName, Object value) {
    return (InstanceManagedByIgmError) super.set(fieldName, value);
  }

  @Override
  public InstanceManagedByIgmError clone() {
    return (InstanceManagedByIgmError) super.clone();
  }

}
