/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * HttpRouteRuleMatch criteria for a request's query parameter.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class HttpQueryParameterMatch extends com.google.api.client.json.GenericJson {

  /**
   * The queryParameterMatch matches if the value of the parameter exactly matches the contents of
   * exactMatch. Only one of presentMatch, exactMatch, or regexMatch must be set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String exactMatch;

  /**
   * The name of the query parameter to match. The query parameter must exist in the request, in the
   * absence of which the request match fails.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Specifies that the queryParameterMatch matches if the request contains the query parameter,
   * irrespective of whether the parameter has a value or not. Only one of presentMatch, exactMatch,
   * or regexMatch must be set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean presentMatch;

  /**
   * The queryParameterMatch matches if the value of the parameter matches the regular expression
   * specified by regexMatch. For more information about regular expression syntax, see Syntax. Only
   * one of presentMatch, exactMatch, or regexMatch must be set. Regular expressions can only be
   * used when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String regexMatch;

  /**
   * The queryParameterMatch matches if the value of the parameter exactly matches the contents of
   * exactMatch. Only one of presentMatch, exactMatch, or regexMatch must be set.
   * @return value or {@code null} for none
   */
  public java.lang.String getExactMatch() {
    return exactMatch;
  }

  /**
   * The queryParameterMatch matches if the value of the parameter exactly matches the contents of
   * exactMatch. Only one of presentMatch, exactMatch, or regexMatch must be set.
   * @param exactMatch exactMatch or {@code null} for none
   */
  public HttpQueryParameterMatch setExactMatch(java.lang.String exactMatch) {
    this.exactMatch = exactMatch;
    return this;
  }

  /**
   * The name of the query parameter to match. The query parameter must exist in the request, in the
   * absence of which the request match fails.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of the query parameter to match. The query parameter must exist in the request, in the
   * absence of which the request match fails.
   * @param name name or {@code null} for none
   */
  public HttpQueryParameterMatch setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Specifies that the queryParameterMatch matches if the request contains the query parameter,
   * irrespective of whether the parameter has a value or not. Only one of presentMatch, exactMatch,
   * or regexMatch must be set.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getPresentMatch() {
    return presentMatch;
  }

  /**
   * Specifies that the queryParameterMatch matches if the request contains the query parameter,
   * irrespective of whether the parameter has a value or not. Only one of presentMatch, exactMatch,
   * or regexMatch must be set.
   * @param presentMatch presentMatch or {@code null} for none
   */
  public HttpQueryParameterMatch setPresentMatch(java.lang.Boolean presentMatch) {
    this.presentMatch = presentMatch;
    return this;
  }

  /**
   * The queryParameterMatch matches if the value of the parameter matches the regular expression
   * specified by regexMatch. For more information about regular expression syntax, see Syntax. Only
   * one of presentMatch, exactMatch, or regexMatch must be set. Regular expressions can only be
   * used when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED.
   * @return value or {@code null} for none
   */
  public java.lang.String getRegexMatch() {
    return regexMatch;
  }

  /**
   * The queryParameterMatch matches if the value of the parameter matches the regular expression
   * specified by regexMatch. For more information about regular expression syntax, see Syntax. Only
   * one of presentMatch, exactMatch, or regexMatch must be set. Regular expressions can only be
   * used when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED.
   * @param regexMatch regexMatch or {@code null} for none
   */
  public HttpQueryParameterMatch setRegexMatch(java.lang.String regexMatch) {
    this.regexMatch = regexMatch;
    return this;
  }

  @Override
  public HttpQueryParameterMatch set(String fieldName, Object value) {
    return (HttpQueryParameterMatch) super.set(fieldName, value);
  }

  @Override
  public HttpQueryParameterMatch clone() {
    return (HttpQueryParameterMatch) super.clone();
  }

}
