/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.cloudkms.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.cloudkms.v1.CloudKMSRequest;
import com.google.api.services.cloudkms.v1.CloudKMSRequestInitializer;
import com.google.api.services.cloudkms.v1.model.CryptoKey;
import com.google.api.services.cloudkms.v1.model.CryptoKeyVersion;
import com.google.api.services.cloudkms.v1.model.DecryptRequest;
import com.google.api.services.cloudkms.v1.model.DecryptResponse;
import com.google.api.services.cloudkms.v1.model.DestroyCryptoKeyVersionRequest;
import com.google.api.services.cloudkms.v1.model.EncryptRequest;
import com.google.api.services.cloudkms.v1.model.EncryptResponse;
import com.google.api.services.cloudkms.v1.model.KeyRing;
import com.google.api.services.cloudkms.v1.model.ListCryptoKeyVersionsResponse;
import com.google.api.services.cloudkms.v1.model.ListCryptoKeysResponse;
import com.google.api.services.cloudkms.v1.model.ListKeyRingsResponse;
import com.google.api.services.cloudkms.v1.model.ListLocationsResponse;
import com.google.api.services.cloudkms.v1.model.Location;
import com.google.api.services.cloudkms.v1.model.Policy;
import com.google.api.services.cloudkms.v1.model.RestoreCryptoKeyVersionRequest;
import com.google.api.services.cloudkms.v1.model.SetIamPolicyRequest;
import com.google.api.services.cloudkms.v1.model.TestIamPermissionsRequest;
import com.google.api.services.cloudkms.v1.model.TestIamPermissionsResponse;
import com.google.api.services.cloudkms.v1.model.UpdateCryptoKeyPrimaryVersionRequest;
import java.io.IOException;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloudKMS
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://cloudkms.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BASE_URL = "https://cloudkms.googleapis.com/";

    public CloudKMS(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    CloudKMS(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.21.0 of the Google Cloud Key Management Service (KMS) API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, "https://cloudkms.googleapis.com/", CloudKMS.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public CloudKMS build() {
            return new CloudKMS(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setCloudKMSRequestInitializer(CloudKMSRequestInitializer cloudKMSRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)cloudKMSRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Projects {
        public Locations locations() {
            return new Locations();
        }

        public class Locations {
            public Get get(String string) throws IOException {
                Get get = new Get(string);
                CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public KeyRings keyRings() {
                return new KeyRings();
            }

            public class KeyRings {
                public Create create(String string, KeyRing keyRing) throws IOException {
                    Create create = new Create(string, keyRing);
                    CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)create);
                    return create;
                }

                public Get get(String string) throws IOException {
                    Get get = new Get(string);
                    CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)get);
                    return get;
                }

                public GetIamPolicy getIamPolicy(String string) throws IOException {
                    GetIamPolicy getIamPolicy = new GetIamPolicy(string);
                    CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)getIamPolicy);
                    return getIamPolicy;
                }

                public List list(String string) throws IOException {
                    List list = new List(string);
                    CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                public SetIamPolicy setIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) throws IOException {
                    SetIamPolicy setIamPolicy = new SetIamPolicy(string, setIamPolicyRequest);
                    CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)setIamPolicy);
                    return setIamPolicy;
                }

                public TestIamPermissions testIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) throws IOException {
                    TestIamPermissions testIamPermissions = new TestIamPermissions(string, testIamPermissionsRequest);
                    CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)testIamPermissions);
                    return testIamPermissions;
                }

                public CryptoKeys cryptoKeys() {
                    return new CryptoKeys();
                }

                public class CryptoKeys {
                    public Create create(String string, CryptoKey cryptoKey) throws IOException {
                        Create create = new Create(string, cryptoKey);
                        CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)create);
                        return create;
                    }

                    public Decrypt decrypt(String string, DecryptRequest decryptRequest) throws IOException {
                        Decrypt decrypt = new Decrypt(string, decryptRequest);
                        CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)decrypt);
                        return decrypt;
                    }

                    public Encrypt encrypt(String string, EncryptRequest encryptRequest) throws IOException {
                        Encrypt encrypt = new Encrypt(string, encryptRequest);
                        CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)encrypt);
                        return encrypt;
                    }

                    public Get get(String string) throws IOException {
                        Get get = new Get(string);
                        CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)get);
                        return get;
                    }

                    public GetIamPolicy getIamPolicy(String string) throws IOException {
                        GetIamPolicy getIamPolicy = new GetIamPolicy(string);
                        CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)getIamPolicy);
                        return getIamPolicy;
                    }

                    public List list(String string) throws IOException {
                        List list = new List(string);
                        CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)list);
                        return list;
                    }

                    public Patch patch(String string, CryptoKey cryptoKey) throws IOException {
                        Patch patch = new Patch(string, cryptoKey);
                        CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)patch);
                        return patch;
                    }

                    public SetIamPolicy setIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) throws IOException {
                        SetIamPolicy setIamPolicy = new SetIamPolicy(string, setIamPolicyRequest);
                        CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)setIamPolicy);
                        return setIamPolicy;
                    }

                    public TestIamPermissions testIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) throws IOException {
                        TestIamPermissions testIamPermissions = new TestIamPermissions(string, testIamPermissionsRequest);
                        CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)testIamPermissions);
                        return testIamPermissions;
                    }

                    public UpdatePrimaryVersion updatePrimaryVersion(String string, UpdateCryptoKeyPrimaryVersionRequest updateCryptoKeyPrimaryVersionRequest) throws IOException {
                        UpdatePrimaryVersion updatePrimaryVersion = new UpdatePrimaryVersion(string, updateCryptoKeyPrimaryVersionRequest);
                        CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)updatePrimaryVersion);
                        return updatePrimaryVersion;
                    }

                    public CryptoKeyVersions cryptoKeyVersions() {
                        return new CryptoKeyVersions();
                    }

                    public class CryptoKeyVersions {
                        public Create create(String string, CryptoKeyVersion cryptoKeyVersion) throws IOException {
                            Create create = new Create(string, cryptoKeyVersion);
                            CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)create);
                            return create;
                        }

                        public Destroy destroy(String string, DestroyCryptoKeyVersionRequest destroyCryptoKeyVersionRequest) throws IOException {
                            Destroy destroy = new Destroy(string, destroyCryptoKeyVersionRequest);
                            CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)destroy);
                            return destroy;
                        }

                        public Get get(String string) throws IOException {
                            Get get = new Get(string);
                            CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)get);
                            return get;
                        }

                        public List list(String string) throws IOException {
                            List list = new List(string);
                            CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)list);
                            return list;
                        }

                        public Patch patch(String string, CryptoKeyVersion cryptoKeyVersion) throws IOException {
                            Patch patch = new Patch(string, cryptoKeyVersion);
                            CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)patch);
                            return patch;
                        }

                        public Restore restore(String string, RestoreCryptoKeyVersionRequest restoreCryptoKeyVersionRequest) throws IOException {
                            Restore restore = new Restore(string, restoreCryptoKeyVersionRequest);
                            CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)restore);
                            return restore;
                        }

                        /*
                         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                         */
                        public class Restore
                        extends CloudKMSRequest<CryptoKeyVersion> {
                            private static final String REST_PATH = "v1/{+name}:restore";
                            private final Pattern NAME_PATTERN;
                            @Key
                            private String name;

                            protected Restore(String string, RestoreCryptoKeyVersionRequest restoreCryptoKeyVersionRequest) {
                                super(CloudKMS.this, "POST", REST_PATH, (Object)restoreCryptoKeyVersionRequest, CryptoKeyVersion.class);
                                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                }
                            }

                            public Restore set$Xgafv(String string) {
                                return (Restore)super.set$Xgafv(string);
                            }

                            public Restore setAccessToken(String string) {
                                return (Restore)super.setAccessToken(string);
                            }

                            public Restore setAlt(String string) {
                                return (Restore)super.setAlt(string);
                            }

                            public Restore setBearerToken(String string) {
                                return (Restore)super.setBearerToken(string);
                            }

                            public Restore setCallback(String string) {
                                return (Restore)super.setCallback(string);
                            }

                            public Restore setFields(String string) {
                                return (Restore)super.setFields(string);
                            }

                            public Restore setKey(String string) {
                                return (Restore)super.setKey(string);
                            }

                            public Restore setOauthToken(String string) {
                                return (Restore)super.setOauthToken(string);
                            }

                            public Restore setPp(Boolean bl) {
                                return (Restore)super.setPp(bl);
                            }

                            public Restore setPrettyPrint(Boolean bl) {
                                return (Restore)super.setPrettyPrint(bl);
                            }

                            public Restore setQuotaUser(String string) {
                                return (Restore)super.setQuotaUser(string);
                            }

                            public Restore setUploadType(String string) {
                                return (Restore)super.setUploadType(string);
                            }

                            public Restore setUploadProtocol(String string) {
                                return (Restore)super.setUploadProtocol(string);
                            }

                            public String getName() {
                                return this.name;
                            }

                            public Restore setName(String string) {
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                }
                                this.name = string;
                                return this;
                            }

                            @Override
                            public Restore set(String string, Object object) {
                                return (Restore)super.set(string, object);
                            }
                        }

                        /*
                         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                         */
                        public class Patch
                        extends CloudKMSRequest<CryptoKeyVersion> {
                            private static final String REST_PATH = "v1/{+name}";
                            private final Pattern NAME_PATTERN;
                            @Key
                            private String name;
                            @Key
                            private String updateMask;

                            protected Patch(String string, CryptoKeyVersion cryptoKeyVersion) {
                                super(CloudKMS.this, "PATCH", REST_PATH, (Object)cryptoKeyVersion, CryptoKeyVersion.class);
                                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                }
                            }

                            public Patch set$Xgafv(String string) {
                                return (Patch)super.set$Xgafv(string);
                            }

                            public Patch setAccessToken(String string) {
                                return (Patch)super.setAccessToken(string);
                            }

                            public Patch setAlt(String string) {
                                return (Patch)super.setAlt(string);
                            }

                            public Patch setBearerToken(String string) {
                                return (Patch)super.setBearerToken(string);
                            }

                            public Patch setCallback(String string) {
                                return (Patch)super.setCallback(string);
                            }

                            public Patch setFields(String string) {
                                return (Patch)super.setFields(string);
                            }

                            public Patch setKey(String string) {
                                return (Patch)super.setKey(string);
                            }

                            public Patch setOauthToken(String string) {
                                return (Patch)super.setOauthToken(string);
                            }

                            public Patch setPp(Boolean bl) {
                                return (Patch)super.setPp(bl);
                            }

                            public Patch setPrettyPrint(Boolean bl) {
                                return (Patch)super.setPrettyPrint(bl);
                            }

                            public Patch setQuotaUser(String string) {
                                return (Patch)super.setQuotaUser(string);
                            }

                            public Patch setUploadType(String string) {
                                return (Patch)super.setUploadType(string);
                            }

                            public Patch setUploadProtocol(String string) {
                                return (Patch)super.setUploadProtocol(string);
                            }

                            public String getName() {
                                return this.name;
                            }

                            public Patch setName(String string) {
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                }
                                this.name = string;
                                return this;
                            }

                            public String getUpdateMask() {
                                return this.updateMask;
                            }

                            public Patch setUpdateMask(String string) {
                                this.updateMask = string;
                                return this;
                            }

                            @Override
                            public Patch set(String string, Object object) {
                                return (Patch)super.set(string, object);
                            }
                        }

                        /*
                         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                         */
                        public class List
                        extends CloudKMSRequest<ListCryptoKeyVersionsResponse> {
                            private static final String REST_PATH = "v1/{+parent}/cryptoKeyVersions";
                            private final Pattern PARENT_PATTERN;
                            @Key
                            private String parent;
                            @Key
                            private String pageToken;
                            @Key
                            private Integer pageSize;

                            protected List(String string) {
                                super(CloudKMS.this, "GET", REST_PATH, null, ListCryptoKeyVersionsResponse.class);
                                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                                this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                                }
                            }

                            public HttpResponse executeUsingHead() throws IOException {
                                return super.executeUsingHead();
                            }

                            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                return super.buildHttpRequestUsingHead();
                            }

                            public List set$Xgafv(String string) {
                                return (List)super.set$Xgafv(string);
                            }

                            public List setAccessToken(String string) {
                                return (List)super.setAccessToken(string);
                            }

                            public List setAlt(String string) {
                                return (List)super.setAlt(string);
                            }

                            public List setBearerToken(String string) {
                                return (List)super.setBearerToken(string);
                            }

                            public List setCallback(String string) {
                                return (List)super.setCallback(string);
                            }

                            public List setFields(String string) {
                                return (List)super.setFields(string);
                            }

                            public List setKey(String string) {
                                return (List)super.setKey(string);
                            }

                            public List setOauthToken(String string) {
                                return (List)super.setOauthToken(string);
                            }

                            public List setPp(Boolean bl) {
                                return (List)super.setPp(bl);
                            }

                            public List setPrettyPrint(Boolean bl) {
                                return (List)super.setPrettyPrint(bl);
                            }

                            public List setQuotaUser(String string) {
                                return (List)super.setQuotaUser(string);
                            }

                            public List setUploadType(String string) {
                                return (List)super.setUploadType(string);
                            }

                            public List setUploadProtocol(String string) {
                                return (List)super.setUploadProtocol(string);
                            }

                            public String getParent() {
                                return this.parent;
                            }

                            public List setParent(String string) {
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                                }
                                this.parent = string;
                                return this;
                            }

                            public String getPageToken() {
                                return this.pageToken;
                            }

                            public List setPageToken(String string) {
                                this.pageToken = string;
                                return this;
                            }

                            public Integer getPageSize() {
                                return this.pageSize;
                            }

                            public List setPageSize(Integer n) {
                                this.pageSize = n;
                                return this;
                            }

                            @Override
                            public List set(String string, Object object) {
                                return (List)super.set(string, object);
                            }
                        }

                        /*
                         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                         */
                        public class Get
                        extends CloudKMSRequest<CryptoKeyVersion> {
                            private static final String REST_PATH = "v1/{+name}";
                            private final Pattern NAME_PATTERN;
                            @Key
                            private String name;

                            protected Get(String string) {
                                super(CloudKMS.this, "GET", REST_PATH, null, CryptoKeyVersion.class);
                                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                }
                            }

                            public HttpResponse executeUsingHead() throws IOException {
                                return super.executeUsingHead();
                            }

                            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                return super.buildHttpRequestUsingHead();
                            }

                            public Get set$Xgafv(String string) {
                                return (Get)super.set$Xgafv(string);
                            }

                            public Get setAccessToken(String string) {
                                return (Get)super.setAccessToken(string);
                            }

                            public Get setAlt(String string) {
                                return (Get)super.setAlt(string);
                            }

                            public Get setBearerToken(String string) {
                                return (Get)super.setBearerToken(string);
                            }

                            public Get setCallback(String string) {
                                return (Get)super.setCallback(string);
                            }

                            public Get setFields(String string) {
                                return (Get)super.setFields(string);
                            }

                            public Get setKey(String string) {
                                return (Get)super.setKey(string);
                            }

                            public Get setOauthToken(String string) {
                                return (Get)super.setOauthToken(string);
                            }

                            public Get setPp(Boolean bl) {
                                return (Get)super.setPp(bl);
                            }

                            public Get setPrettyPrint(Boolean bl) {
                                return (Get)super.setPrettyPrint(bl);
                            }

                            public Get setQuotaUser(String string) {
                                return (Get)super.setQuotaUser(string);
                            }

                            public Get setUploadType(String string) {
                                return (Get)super.setUploadType(string);
                            }

                            public Get setUploadProtocol(String string) {
                                return (Get)super.setUploadProtocol(string);
                            }

                            public String getName() {
                                return this.name;
                            }

                            public Get setName(String string) {
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                }
                                this.name = string;
                                return this;
                            }

                            @Override
                            public Get set(String string, Object object) {
                                return (Get)super.set(string, object);
                            }
                        }

                        /*
                         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                         */
                        public class Destroy
                        extends CloudKMSRequest<CryptoKeyVersion> {
                            private static final String REST_PATH = "v1/{+name}:destroy";
                            private final Pattern NAME_PATTERN;
                            @Key
                            private String name;

                            protected Destroy(String string, DestroyCryptoKeyVersionRequest destroyCryptoKeyVersionRequest) {
                                super(CloudKMS.this, "POST", REST_PATH, (Object)destroyCryptoKeyVersionRequest, CryptoKeyVersion.class);
                                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                }
                            }

                            public Destroy set$Xgafv(String string) {
                                return (Destroy)super.set$Xgafv(string);
                            }

                            public Destroy setAccessToken(String string) {
                                return (Destroy)super.setAccessToken(string);
                            }

                            public Destroy setAlt(String string) {
                                return (Destroy)super.setAlt(string);
                            }

                            public Destroy setBearerToken(String string) {
                                return (Destroy)super.setBearerToken(string);
                            }

                            public Destroy setCallback(String string) {
                                return (Destroy)super.setCallback(string);
                            }

                            public Destroy setFields(String string) {
                                return (Destroy)super.setFields(string);
                            }

                            public Destroy setKey(String string) {
                                return (Destroy)super.setKey(string);
                            }

                            public Destroy setOauthToken(String string) {
                                return (Destroy)super.setOauthToken(string);
                            }

                            public Destroy setPp(Boolean bl) {
                                return (Destroy)super.setPp(bl);
                            }

                            public Destroy setPrettyPrint(Boolean bl) {
                                return (Destroy)super.setPrettyPrint(bl);
                            }

                            public Destroy setQuotaUser(String string) {
                                return (Destroy)super.setQuotaUser(string);
                            }

                            public Destroy setUploadType(String string) {
                                return (Destroy)super.setUploadType(string);
                            }

                            public Destroy setUploadProtocol(String string) {
                                return (Destroy)super.setUploadProtocol(string);
                            }

                            public String getName() {
                                return this.name;
                            }

                            public Destroy setName(String string) {
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                }
                                this.name = string;
                                return this;
                            }

                            @Override
                            public Destroy set(String string, Object object) {
                                return (Destroy)super.set(string, object);
                            }
                        }

                        /*
                         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                         */
                        public class Create
                        extends CloudKMSRequest<CryptoKeyVersion> {
                            private static final String REST_PATH = "v1/{+parent}/cryptoKeyVersions";
                            private final Pattern PARENT_PATTERN;
                            @Key
                            private String parent;

                            protected Create(String string, CryptoKeyVersion cryptoKeyVersion) {
                                super(CloudKMS.this, "POST", REST_PATH, (Object)cryptoKeyVersion, CryptoKeyVersion.class);
                                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                                this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                                }
                            }

                            public Create set$Xgafv(String string) {
                                return (Create)super.set$Xgafv(string);
                            }

                            public Create setAccessToken(String string) {
                                return (Create)super.setAccessToken(string);
                            }

                            public Create setAlt(String string) {
                                return (Create)super.setAlt(string);
                            }

                            public Create setBearerToken(String string) {
                                return (Create)super.setBearerToken(string);
                            }

                            public Create setCallback(String string) {
                                return (Create)super.setCallback(string);
                            }

                            public Create setFields(String string) {
                                return (Create)super.setFields(string);
                            }

                            public Create setKey(String string) {
                                return (Create)super.setKey(string);
                            }

                            public Create setOauthToken(String string) {
                                return (Create)super.setOauthToken(string);
                            }

                            public Create setPp(Boolean bl) {
                                return (Create)super.setPp(bl);
                            }

                            public Create setPrettyPrint(Boolean bl) {
                                return (Create)super.setPrettyPrint(bl);
                            }

                            public Create setQuotaUser(String string) {
                                return (Create)super.setQuotaUser(string);
                            }

                            public Create setUploadType(String string) {
                                return (Create)super.setUploadType(string);
                            }

                            public Create setUploadProtocol(String string) {
                                return (Create)super.setUploadProtocol(string);
                            }

                            public String getParent() {
                                return this.parent;
                            }

                            public Create setParent(String string) {
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                                }
                                this.parent = string;
                                return this;
                            }

                            @Override
                            public Create set(String string, Object object) {
                                return (Create)super.set(string, object);
                            }
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class UpdatePrimaryVersion
                    extends CloudKMSRequest<CryptoKey> {
                        private static final String REST_PATH = "v1/{+name}:updatePrimaryVersion";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected UpdatePrimaryVersion(String string, UpdateCryptoKeyPrimaryVersionRequest updateCryptoKeyPrimaryVersionRequest) {
                            super(CloudKMS.this, "POST", REST_PATH, (Object)updateCryptoKeyPrimaryVersionRequest, CryptoKey.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            }
                        }

                        public UpdatePrimaryVersion set$Xgafv(String string) {
                            return (UpdatePrimaryVersion)super.set$Xgafv(string);
                        }

                        public UpdatePrimaryVersion setAccessToken(String string) {
                            return (UpdatePrimaryVersion)super.setAccessToken(string);
                        }

                        public UpdatePrimaryVersion setAlt(String string) {
                            return (UpdatePrimaryVersion)super.setAlt(string);
                        }

                        public UpdatePrimaryVersion setBearerToken(String string) {
                            return (UpdatePrimaryVersion)super.setBearerToken(string);
                        }

                        public UpdatePrimaryVersion setCallback(String string) {
                            return (UpdatePrimaryVersion)super.setCallback(string);
                        }

                        public UpdatePrimaryVersion setFields(String string) {
                            return (UpdatePrimaryVersion)super.setFields(string);
                        }

                        public UpdatePrimaryVersion setKey(String string) {
                            return (UpdatePrimaryVersion)super.setKey(string);
                        }

                        public UpdatePrimaryVersion setOauthToken(String string) {
                            return (UpdatePrimaryVersion)super.setOauthToken(string);
                        }

                        public UpdatePrimaryVersion setPp(Boolean bl) {
                            return (UpdatePrimaryVersion)super.setPp(bl);
                        }

                        public UpdatePrimaryVersion setPrettyPrint(Boolean bl) {
                            return (UpdatePrimaryVersion)super.setPrettyPrint(bl);
                        }

                        public UpdatePrimaryVersion setQuotaUser(String string) {
                            return (UpdatePrimaryVersion)super.setQuotaUser(string);
                        }

                        public UpdatePrimaryVersion setUploadType(String string) {
                            return (UpdatePrimaryVersion)super.setUploadType(string);
                        }

                        public UpdatePrimaryVersion setUploadProtocol(String string) {
                            return (UpdatePrimaryVersion)super.setUploadProtocol(string);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public UpdatePrimaryVersion setName(String string) {
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            }
                            this.name = string;
                            return this;
                        }

                        @Override
                        public UpdatePrimaryVersion set(String string, Object object) {
                            return (UpdatePrimaryVersion)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class TestIamPermissions
                    extends CloudKMSRequest<TestIamPermissionsResponse> {
                        private static final String REST_PATH = "v1/{+resource}:testIamPermissions";
                        private final Pattern RESOURCE_PATTERN;
                        @Key
                        private String resource;

                        protected TestIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) {
                            super(CloudKMS.this, "POST", REST_PATH, (Object)testIamPermissionsRequest, TestIamPermissionsResponse.class);
                            this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            }
                        }

                        public TestIamPermissions set$Xgafv(String string) {
                            return (TestIamPermissions)super.set$Xgafv(string);
                        }

                        public TestIamPermissions setAccessToken(String string) {
                            return (TestIamPermissions)super.setAccessToken(string);
                        }

                        public TestIamPermissions setAlt(String string) {
                            return (TestIamPermissions)super.setAlt(string);
                        }

                        public TestIamPermissions setBearerToken(String string) {
                            return (TestIamPermissions)super.setBearerToken(string);
                        }

                        public TestIamPermissions setCallback(String string) {
                            return (TestIamPermissions)super.setCallback(string);
                        }

                        public TestIamPermissions setFields(String string) {
                            return (TestIamPermissions)super.setFields(string);
                        }

                        public TestIamPermissions setKey(String string) {
                            return (TestIamPermissions)super.setKey(string);
                        }

                        public TestIamPermissions setOauthToken(String string) {
                            return (TestIamPermissions)super.setOauthToken(string);
                        }

                        public TestIamPermissions setPp(Boolean bl) {
                            return (TestIamPermissions)super.setPp(bl);
                        }

                        public TestIamPermissions setPrettyPrint(Boolean bl) {
                            return (TestIamPermissions)super.setPrettyPrint(bl);
                        }

                        public TestIamPermissions setQuotaUser(String string) {
                            return (TestIamPermissions)super.setQuotaUser(string);
                        }

                        public TestIamPermissions setUploadType(String string) {
                            return (TestIamPermissions)super.setUploadType(string);
                        }

                        public TestIamPermissions setUploadProtocol(String string) {
                            return (TestIamPermissions)super.setUploadProtocol(string);
                        }

                        public String getResource() {
                            return this.resource;
                        }

                        public TestIamPermissions setResource(String string) {
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            }
                            this.resource = string;
                            return this;
                        }

                        @Override
                        public TestIamPermissions set(String string, Object object) {
                            return (TestIamPermissions)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class SetIamPolicy
                    extends CloudKMSRequest<Policy> {
                        private static final String REST_PATH = "v1/{+resource}:setIamPolicy";
                        private final Pattern RESOURCE_PATTERN;
                        @Key
                        private String resource;

                        protected SetIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) {
                            super(CloudKMS.this, "POST", REST_PATH, (Object)setIamPolicyRequest, Policy.class);
                            this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            }
                        }

                        public SetIamPolicy set$Xgafv(String string) {
                            return (SetIamPolicy)super.set$Xgafv(string);
                        }

                        public SetIamPolicy setAccessToken(String string) {
                            return (SetIamPolicy)super.setAccessToken(string);
                        }

                        public SetIamPolicy setAlt(String string) {
                            return (SetIamPolicy)super.setAlt(string);
                        }

                        public SetIamPolicy setBearerToken(String string) {
                            return (SetIamPolicy)super.setBearerToken(string);
                        }

                        public SetIamPolicy setCallback(String string) {
                            return (SetIamPolicy)super.setCallback(string);
                        }

                        public SetIamPolicy setFields(String string) {
                            return (SetIamPolicy)super.setFields(string);
                        }

                        public SetIamPolicy setKey(String string) {
                            return (SetIamPolicy)super.setKey(string);
                        }

                        public SetIamPolicy setOauthToken(String string) {
                            return (SetIamPolicy)super.setOauthToken(string);
                        }

                        public SetIamPolicy setPp(Boolean bl) {
                            return (SetIamPolicy)super.setPp(bl);
                        }

                        public SetIamPolicy setPrettyPrint(Boolean bl) {
                            return (SetIamPolicy)super.setPrettyPrint(bl);
                        }

                        public SetIamPolicy setQuotaUser(String string) {
                            return (SetIamPolicy)super.setQuotaUser(string);
                        }

                        public SetIamPolicy setUploadType(String string) {
                            return (SetIamPolicy)super.setUploadType(string);
                        }

                        public SetIamPolicy setUploadProtocol(String string) {
                            return (SetIamPolicy)super.setUploadProtocol(string);
                        }

                        public String getResource() {
                            return this.resource;
                        }

                        public SetIamPolicy setResource(String string) {
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            }
                            this.resource = string;
                            return this;
                        }

                        @Override
                        public SetIamPolicy set(String string, Object object) {
                            return (SetIamPolicy)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Patch
                    extends CloudKMSRequest<CryptoKey> {
                        private static final String REST_PATH = "v1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;
                        @Key
                        private String updateMask;

                        protected Patch(String string, CryptoKey cryptoKey) {
                            super(CloudKMS.this, "PATCH", REST_PATH, (Object)cryptoKey, CryptoKey.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            }
                        }

                        public Patch set$Xgafv(String string) {
                            return (Patch)super.set$Xgafv(string);
                        }

                        public Patch setAccessToken(String string) {
                            return (Patch)super.setAccessToken(string);
                        }

                        public Patch setAlt(String string) {
                            return (Patch)super.setAlt(string);
                        }

                        public Patch setBearerToken(String string) {
                            return (Patch)super.setBearerToken(string);
                        }

                        public Patch setCallback(String string) {
                            return (Patch)super.setCallback(string);
                        }

                        public Patch setFields(String string) {
                            return (Patch)super.setFields(string);
                        }

                        public Patch setKey(String string) {
                            return (Patch)super.setKey(string);
                        }

                        public Patch setOauthToken(String string) {
                            return (Patch)super.setOauthToken(string);
                        }

                        public Patch setPp(Boolean bl) {
                            return (Patch)super.setPp(bl);
                        }

                        public Patch setPrettyPrint(Boolean bl) {
                            return (Patch)super.setPrettyPrint(bl);
                        }

                        public Patch setQuotaUser(String string) {
                            return (Patch)super.setQuotaUser(string);
                        }

                        public Patch setUploadType(String string) {
                            return (Patch)super.setUploadType(string);
                        }

                        public Patch setUploadProtocol(String string) {
                            return (Patch)super.setUploadProtocol(string);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Patch setName(String string) {
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            }
                            this.name = string;
                            return this;
                        }

                        public String getUpdateMask() {
                            return this.updateMask;
                        }

                        public Patch setUpdateMask(String string) {
                            this.updateMask = string;
                            return this;
                        }

                        @Override
                        public Patch set(String string, Object object) {
                            return (Patch)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class List
                    extends CloudKMSRequest<ListCryptoKeysResponse> {
                        private static final String REST_PATH = "v1/{+parent}/cryptoKeys";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String pageToken;
                        @Key
                        private Integer pageSize;

                        protected List(String string) {
                            super(CloudKMS.this, "GET", REST_PATH, null, ListCryptoKeysResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String string) {
                            return (List)super.set$Xgafv(string);
                        }

                        public List setAccessToken(String string) {
                            return (List)super.setAccessToken(string);
                        }

                        public List setAlt(String string) {
                            return (List)super.setAlt(string);
                        }

                        public List setBearerToken(String string) {
                            return (List)super.setBearerToken(string);
                        }

                        public List setCallback(String string) {
                            return (List)super.setCallback(string);
                        }

                        public List setFields(String string) {
                            return (List)super.setFields(string);
                        }

                        public List setKey(String string) {
                            return (List)super.setKey(string);
                        }

                        public List setOauthToken(String string) {
                            return (List)super.setOauthToken(string);
                        }

                        public List setPp(Boolean bl) {
                            return (List)super.setPp(bl);
                        }

                        public List setPrettyPrint(Boolean bl) {
                            return (List)super.setPrettyPrint(bl);
                        }

                        public List setQuotaUser(String string) {
                            return (List)super.setQuotaUser(string);
                        }

                        public List setUploadType(String string) {
                            return (List)super.setUploadType(string);
                        }

                        public List setUploadProtocol(String string) {
                            return (List)super.setUploadProtocol(string);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public List setParent(String string) {
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                            }
                            this.parent = string;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String string) {
                            this.pageToken = string;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer n) {
                            this.pageSize = n;
                            return this;
                        }

                        @Override
                        public List set(String string, Object object) {
                            return (List)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class GetIamPolicy
                    extends CloudKMSRequest<Policy> {
                        private static final String REST_PATH = "v1/{+resource}:getIamPolicy";
                        private final Pattern RESOURCE_PATTERN;
                        @Key
                        private String resource;

                        protected GetIamPolicy(String string) {
                            super(CloudKMS.this, "GET", REST_PATH, null, Policy.class);
                            this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public GetIamPolicy set$Xgafv(String string) {
                            return (GetIamPolicy)super.set$Xgafv(string);
                        }

                        public GetIamPolicy setAccessToken(String string) {
                            return (GetIamPolicy)super.setAccessToken(string);
                        }

                        public GetIamPolicy setAlt(String string) {
                            return (GetIamPolicy)super.setAlt(string);
                        }

                        public GetIamPolicy setBearerToken(String string) {
                            return (GetIamPolicy)super.setBearerToken(string);
                        }

                        public GetIamPolicy setCallback(String string) {
                            return (GetIamPolicy)super.setCallback(string);
                        }

                        public GetIamPolicy setFields(String string) {
                            return (GetIamPolicy)super.setFields(string);
                        }

                        public GetIamPolicy setKey(String string) {
                            return (GetIamPolicy)super.setKey(string);
                        }

                        public GetIamPolicy setOauthToken(String string) {
                            return (GetIamPolicy)super.setOauthToken(string);
                        }

                        public GetIamPolicy setPp(Boolean bl) {
                            return (GetIamPolicy)super.setPp(bl);
                        }

                        public GetIamPolicy setPrettyPrint(Boolean bl) {
                            return (GetIamPolicy)super.setPrettyPrint(bl);
                        }

                        public GetIamPolicy setQuotaUser(String string) {
                            return (GetIamPolicy)super.setQuotaUser(string);
                        }

                        public GetIamPolicy setUploadType(String string) {
                            return (GetIamPolicy)super.setUploadType(string);
                        }

                        public GetIamPolicy setUploadProtocol(String string) {
                            return (GetIamPolicy)super.setUploadProtocol(string);
                        }

                        public String getResource() {
                            return this.resource;
                        }

                        public GetIamPolicy setResource(String string) {
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            }
                            this.resource = string;
                            return this;
                        }

                        @Override
                        public GetIamPolicy set(String string, Object object) {
                            return (GetIamPolicy)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Get
                    extends CloudKMSRequest<CryptoKey> {
                        private static final String REST_PATH = "v1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Get(String string) {
                            super(CloudKMS.this, "GET", REST_PATH, null, CryptoKey.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String string) {
                            return (Get)super.set$Xgafv(string);
                        }

                        public Get setAccessToken(String string) {
                            return (Get)super.setAccessToken(string);
                        }

                        public Get setAlt(String string) {
                            return (Get)super.setAlt(string);
                        }

                        public Get setBearerToken(String string) {
                            return (Get)super.setBearerToken(string);
                        }

                        public Get setCallback(String string) {
                            return (Get)super.setCallback(string);
                        }

                        public Get setFields(String string) {
                            return (Get)super.setFields(string);
                        }

                        public Get setKey(String string) {
                            return (Get)super.setKey(string);
                        }

                        public Get setOauthToken(String string) {
                            return (Get)super.setOauthToken(string);
                        }

                        public Get setPp(Boolean bl) {
                            return (Get)super.setPp(bl);
                        }

                        public Get setPrettyPrint(Boolean bl) {
                            return (Get)super.setPrettyPrint(bl);
                        }

                        public Get setQuotaUser(String string) {
                            return (Get)super.setQuotaUser(string);
                        }

                        public Get setUploadType(String string) {
                            return (Get)super.setUploadType(string);
                        }

                        public Get setUploadProtocol(String string) {
                            return (Get)super.setUploadProtocol(string);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Get setName(String string) {
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            }
                            this.name = string;
                            return this;
                        }

                        @Override
                        public Get set(String string, Object object) {
                            return (Get)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Encrypt
                    extends CloudKMSRequest<EncryptResponse> {
                        private static final String REST_PATH = "v1/{+name}:encrypt";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Encrypt(String string, EncryptRequest encryptRequest) {
                            super(CloudKMS.this, "POST", REST_PATH, (Object)encryptRequest, EncryptResponse.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/.+$");
                            this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/.+$");
                            }
                        }

                        public Encrypt set$Xgafv(String string) {
                            return (Encrypt)super.set$Xgafv(string);
                        }

                        public Encrypt setAccessToken(String string) {
                            return (Encrypt)super.setAccessToken(string);
                        }

                        public Encrypt setAlt(String string) {
                            return (Encrypt)super.setAlt(string);
                        }

                        public Encrypt setBearerToken(String string) {
                            return (Encrypt)super.setBearerToken(string);
                        }

                        public Encrypt setCallback(String string) {
                            return (Encrypt)super.setCallback(string);
                        }

                        public Encrypt setFields(String string) {
                            return (Encrypt)super.setFields(string);
                        }

                        public Encrypt setKey(String string) {
                            return (Encrypt)super.setKey(string);
                        }

                        public Encrypt setOauthToken(String string) {
                            return (Encrypt)super.setOauthToken(string);
                        }

                        public Encrypt setPp(Boolean bl) {
                            return (Encrypt)super.setPp(bl);
                        }

                        public Encrypt setPrettyPrint(Boolean bl) {
                            return (Encrypt)super.setPrettyPrint(bl);
                        }

                        public Encrypt setQuotaUser(String string) {
                            return (Encrypt)super.setQuotaUser(string);
                        }

                        public Encrypt setUploadType(String string) {
                            return (Encrypt)super.setUploadType(string);
                        }

                        public Encrypt setUploadProtocol(String string) {
                            return (Encrypt)super.setUploadProtocol(string);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Encrypt setName(String string) {
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/.+$");
                            }
                            this.name = string;
                            return this;
                        }

                        @Override
                        public Encrypt set(String string, Object object) {
                            return (Encrypt)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Decrypt
                    extends CloudKMSRequest<DecryptResponse> {
                        private static final String REST_PATH = "v1/{+name}:decrypt";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Decrypt(String string, DecryptRequest decryptRequest) {
                            super(CloudKMS.this, "POST", REST_PATH, (Object)decryptRequest, DecryptResponse.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            }
                        }

                        public Decrypt set$Xgafv(String string) {
                            return (Decrypt)super.set$Xgafv(string);
                        }

                        public Decrypt setAccessToken(String string) {
                            return (Decrypt)super.setAccessToken(string);
                        }

                        public Decrypt setAlt(String string) {
                            return (Decrypt)super.setAlt(string);
                        }

                        public Decrypt setBearerToken(String string) {
                            return (Decrypt)super.setBearerToken(string);
                        }

                        public Decrypt setCallback(String string) {
                            return (Decrypt)super.setCallback(string);
                        }

                        public Decrypt setFields(String string) {
                            return (Decrypt)super.setFields(string);
                        }

                        public Decrypt setKey(String string) {
                            return (Decrypt)super.setKey(string);
                        }

                        public Decrypt setOauthToken(String string) {
                            return (Decrypt)super.setOauthToken(string);
                        }

                        public Decrypt setPp(Boolean bl) {
                            return (Decrypt)super.setPp(bl);
                        }

                        public Decrypt setPrettyPrint(Boolean bl) {
                            return (Decrypt)super.setPrettyPrint(bl);
                        }

                        public Decrypt setQuotaUser(String string) {
                            return (Decrypt)super.setQuotaUser(string);
                        }

                        public Decrypt setUploadType(String string) {
                            return (Decrypt)super.setUploadType(string);
                        }

                        public Decrypt setUploadProtocol(String string) {
                            return (Decrypt)super.setUploadProtocol(string);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Decrypt setName(String string) {
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            }
                            this.name = string;
                            return this;
                        }

                        @Override
                        public Decrypt set(String string, Object object) {
                            return (Decrypt)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Create
                    extends CloudKMSRequest<CryptoKey> {
                        private static final String REST_PATH = "v1/{+parent}/cryptoKeys";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String cryptoKeyId;

                        protected Create(String string, CryptoKey cryptoKey) {
                            super(CloudKMS.this, "POST", REST_PATH, (Object)cryptoKey, CryptoKey.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                            }
                        }

                        public Create set$Xgafv(String string) {
                            return (Create)super.set$Xgafv(string);
                        }

                        public Create setAccessToken(String string) {
                            return (Create)super.setAccessToken(string);
                        }

                        public Create setAlt(String string) {
                            return (Create)super.setAlt(string);
                        }

                        public Create setBearerToken(String string) {
                            return (Create)super.setBearerToken(string);
                        }

                        public Create setCallback(String string) {
                            return (Create)super.setCallback(string);
                        }

                        public Create setFields(String string) {
                            return (Create)super.setFields(string);
                        }

                        public Create setKey(String string) {
                            return (Create)super.setKey(string);
                        }

                        public Create setOauthToken(String string) {
                            return (Create)super.setOauthToken(string);
                        }

                        public Create setPp(Boolean bl) {
                            return (Create)super.setPp(bl);
                        }

                        public Create setPrettyPrint(Boolean bl) {
                            return (Create)super.setPrettyPrint(bl);
                        }

                        public Create setQuotaUser(String string) {
                            return (Create)super.setQuotaUser(string);
                        }

                        public Create setUploadType(String string) {
                            return (Create)super.setUploadType(string);
                        }

                        public Create setUploadProtocol(String string) {
                            return (Create)super.setUploadProtocol(string);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public Create setParent(String string) {
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                            }
                            this.parent = string;
                            return this;
                        }

                        public String getCryptoKeyId() {
                            return this.cryptoKeyId;
                        }

                        public Create setCryptoKeyId(String string) {
                            this.cryptoKeyId = string;
                            return this;
                        }

                        @Override
                        public Create set(String string, Object object) {
                            return (Create)super.set(string, object);
                        }
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class TestIamPermissions
                extends CloudKMSRequest<TestIamPermissionsResponse> {
                    private static final String REST_PATH = "v1/{+resource}:testIamPermissions";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected TestIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) {
                        super(CloudKMS.this, "POST", REST_PATH, (Object)testIamPermissionsRequest, TestIamPermissionsResponse.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                        }
                    }

                    public TestIamPermissions set$Xgafv(String string) {
                        return (TestIamPermissions)super.set$Xgafv(string);
                    }

                    public TestIamPermissions setAccessToken(String string) {
                        return (TestIamPermissions)super.setAccessToken(string);
                    }

                    public TestIamPermissions setAlt(String string) {
                        return (TestIamPermissions)super.setAlt(string);
                    }

                    public TestIamPermissions setBearerToken(String string) {
                        return (TestIamPermissions)super.setBearerToken(string);
                    }

                    public TestIamPermissions setCallback(String string) {
                        return (TestIamPermissions)super.setCallback(string);
                    }

                    public TestIamPermissions setFields(String string) {
                        return (TestIamPermissions)super.setFields(string);
                    }

                    public TestIamPermissions setKey(String string) {
                        return (TestIamPermissions)super.setKey(string);
                    }

                    public TestIamPermissions setOauthToken(String string) {
                        return (TestIamPermissions)super.setOauthToken(string);
                    }

                    public TestIamPermissions setPp(Boolean bl) {
                        return (TestIamPermissions)super.setPp(bl);
                    }

                    public TestIamPermissions setPrettyPrint(Boolean bl) {
                        return (TestIamPermissions)super.setPrettyPrint(bl);
                    }

                    public TestIamPermissions setQuotaUser(String string) {
                        return (TestIamPermissions)super.setQuotaUser(string);
                    }

                    public TestIamPermissions setUploadType(String string) {
                        return (TestIamPermissions)super.setUploadType(string);
                    }

                    public TestIamPermissions setUploadProtocol(String string) {
                        return (TestIamPermissions)super.setUploadProtocol(string);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public TestIamPermissions setResource(String string) {
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                        }
                        this.resource = string;
                        return this;
                    }

                    @Override
                    public TestIamPermissions set(String string, Object object) {
                        return (TestIamPermissions)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class SetIamPolicy
                extends CloudKMSRequest<Policy> {
                    private static final String REST_PATH = "v1/{+resource}:setIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected SetIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) {
                        super(CloudKMS.this, "POST", REST_PATH, (Object)setIamPolicyRequest, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                        }
                    }

                    public SetIamPolicy set$Xgafv(String string) {
                        return (SetIamPolicy)super.set$Xgafv(string);
                    }

                    public SetIamPolicy setAccessToken(String string) {
                        return (SetIamPolicy)super.setAccessToken(string);
                    }

                    public SetIamPolicy setAlt(String string) {
                        return (SetIamPolicy)super.setAlt(string);
                    }

                    public SetIamPolicy setBearerToken(String string) {
                        return (SetIamPolicy)super.setBearerToken(string);
                    }

                    public SetIamPolicy setCallback(String string) {
                        return (SetIamPolicy)super.setCallback(string);
                    }

                    public SetIamPolicy setFields(String string) {
                        return (SetIamPolicy)super.setFields(string);
                    }

                    public SetIamPolicy setKey(String string) {
                        return (SetIamPolicy)super.setKey(string);
                    }

                    public SetIamPolicy setOauthToken(String string) {
                        return (SetIamPolicy)super.setOauthToken(string);
                    }

                    public SetIamPolicy setPp(Boolean bl) {
                        return (SetIamPolicy)super.setPp(bl);
                    }

                    public SetIamPolicy setPrettyPrint(Boolean bl) {
                        return (SetIamPolicy)super.setPrettyPrint(bl);
                    }

                    public SetIamPolicy setQuotaUser(String string) {
                        return (SetIamPolicy)super.setQuotaUser(string);
                    }

                    public SetIamPolicy setUploadType(String string) {
                        return (SetIamPolicy)super.setUploadType(string);
                    }

                    public SetIamPolicy setUploadProtocol(String string) {
                        return (SetIamPolicy)super.setUploadProtocol(string);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public SetIamPolicy setResource(String string) {
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                        }
                        this.resource = string;
                        return this;
                    }

                    @Override
                    public SetIamPolicy set(String string, Object object) {
                        return (SetIamPolicy)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends CloudKMSRequest<ListKeyRingsResponse> {
                    private static final String REST_PATH = "v1/{+parent}/keyRings";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String pageToken;
                    @Key
                    private Integer pageSize;

                    protected List(String string) {
                        super(CloudKMS.this, "GET", REST_PATH, null, ListKeyRingsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String string) {
                        return (List)super.set$Xgafv(string);
                    }

                    public List setAccessToken(String string) {
                        return (List)super.setAccessToken(string);
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setBearerToken(String string) {
                        return (List)super.setBearerToken(string);
                    }

                    public List setCallback(String string) {
                        return (List)super.setCallback(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPp(Boolean bl) {
                        return (List)super.setPp(bl);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUploadType(String string) {
                        return (List)super.setUploadType(string);
                    }

                    public List setUploadProtocol(String string) {
                        return (List)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String string) {
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = string;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String string) {
                        this.pageToken = string;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer n) {
                        this.pageSize = n;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class GetIamPolicy
                extends CloudKMSRequest<Policy> {
                    private static final String REST_PATH = "v1/{+resource}:getIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected GetIamPolicy(String string) {
                        super(CloudKMS.this, "GET", REST_PATH, null, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public GetIamPolicy set$Xgafv(String string) {
                        return (GetIamPolicy)super.set$Xgafv(string);
                    }

                    public GetIamPolicy setAccessToken(String string) {
                        return (GetIamPolicy)super.setAccessToken(string);
                    }

                    public GetIamPolicy setAlt(String string) {
                        return (GetIamPolicy)super.setAlt(string);
                    }

                    public GetIamPolicy setBearerToken(String string) {
                        return (GetIamPolicy)super.setBearerToken(string);
                    }

                    public GetIamPolicy setCallback(String string) {
                        return (GetIamPolicy)super.setCallback(string);
                    }

                    public GetIamPolicy setFields(String string) {
                        return (GetIamPolicy)super.setFields(string);
                    }

                    public GetIamPolicy setKey(String string) {
                        return (GetIamPolicy)super.setKey(string);
                    }

                    public GetIamPolicy setOauthToken(String string) {
                        return (GetIamPolicy)super.setOauthToken(string);
                    }

                    public GetIamPolicy setPp(Boolean bl) {
                        return (GetIamPolicy)super.setPp(bl);
                    }

                    public GetIamPolicy setPrettyPrint(Boolean bl) {
                        return (GetIamPolicy)super.setPrettyPrint(bl);
                    }

                    public GetIamPolicy setQuotaUser(String string) {
                        return (GetIamPolicy)super.setQuotaUser(string);
                    }

                    public GetIamPolicy setUploadType(String string) {
                        return (GetIamPolicy)super.setUploadType(string);
                    }

                    public GetIamPolicy setUploadProtocol(String string) {
                        return (GetIamPolicy)super.setUploadProtocol(string);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public GetIamPolicy setResource(String string) {
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                        }
                        this.resource = string;
                        return this;
                    }

                    @Override
                    public GetIamPolicy set(String string, Object object) {
                        return (GetIamPolicy)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Get
                extends CloudKMSRequest<KeyRing> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String string) {
                        super(CloudKMS.this, "GET", REST_PATH, null, KeyRing.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String string) {
                        return (Get)super.set$Xgafv(string);
                    }

                    public Get setAccessToken(String string) {
                        return (Get)super.setAccessToken(string);
                    }

                    public Get setAlt(String string) {
                        return (Get)super.setAlt(string);
                    }

                    public Get setBearerToken(String string) {
                        return (Get)super.setBearerToken(string);
                    }

                    public Get setCallback(String string) {
                        return (Get)super.setCallback(string);
                    }

                    public Get setFields(String string) {
                        return (Get)super.setFields(string);
                    }

                    public Get setKey(String string) {
                        return (Get)super.setKey(string);
                    }

                    public Get setOauthToken(String string) {
                        return (Get)super.setOauthToken(string);
                    }

                    public Get setPp(Boolean bl) {
                        return (Get)super.setPp(bl);
                    }

                    public Get setPrettyPrint(Boolean bl) {
                        return (Get)super.setPrettyPrint(bl);
                    }

                    public Get setQuotaUser(String string) {
                        return (Get)super.setQuotaUser(string);
                    }

                    public Get setUploadType(String string) {
                        return (Get)super.setUploadType(string);
                    }

                    public Get setUploadProtocol(String string) {
                        return (Get)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String string) {
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public Get set(String string, Object object) {
                        return (Get)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Create
                extends CloudKMSRequest<KeyRing> {
                    private static final String REST_PATH = "v1/{+parent}/keyRings";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String keyRingId;

                    protected Create(String string, KeyRing keyRing) {
                        super(CloudKMS.this, "POST", REST_PATH, (Object)keyRing, KeyRing.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String string) {
                        return (Create)super.set$Xgafv(string);
                    }

                    public Create setAccessToken(String string) {
                        return (Create)super.setAccessToken(string);
                    }

                    public Create setAlt(String string) {
                        return (Create)super.setAlt(string);
                    }

                    public Create setBearerToken(String string) {
                        return (Create)super.setBearerToken(string);
                    }

                    public Create setCallback(String string) {
                        return (Create)super.setCallback(string);
                    }

                    public Create setFields(String string) {
                        return (Create)super.setFields(string);
                    }

                    public Create setKey(String string) {
                        return (Create)super.setKey(string);
                    }

                    public Create setOauthToken(String string) {
                        return (Create)super.setOauthToken(string);
                    }

                    public Create setPp(Boolean bl) {
                        return (Create)super.setPp(bl);
                    }

                    public Create setPrettyPrint(Boolean bl) {
                        return (Create)super.setPrettyPrint(bl);
                    }

                    public Create setQuotaUser(String string) {
                        return (Create)super.setQuotaUser(string);
                    }

                    public Create setUploadType(String string) {
                        return (Create)super.setUploadType(string);
                    }

                    public Create setUploadProtocol(String string) {
                        return (Create)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String string) {
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = string;
                        return this;
                    }

                    public String getKeyRingId() {
                        return this.keyRingId;
                    }

                    public Create setKeyRingId(String string) {
                        this.keyRingId = string;
                        return this;
                    }

                    @Override
                    public Create set(String string, Object object) {
                        return (Create)super.set(string, object);
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends CloudKMSRequest<ListLocationsResponse> {
                private static final String REST_PATH = "v1/{+name}/locations";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String pageToken;
                @Key
                private Integer pageSize;
                @Key
                private String filter;

                protected List(String string) {
                    super(CloudKMS.this, "GET", REST_PATH, null, ListLocationsResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!CloudKMS.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setBearerToken(String string) {
                    return (List)super.setBearerToken(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPp(Boolean bl) {
                    return (List)super.setPp(bl);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public List setName(String string) {
                    if (!CloudKMS.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String string) {
                    this.filter = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends CloudKMSRequest<Location> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String string) {
                    super(CloudKMS.this, "GET", REST_PATH, null, Location.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!CloudKMS.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setBearerToken(String string) {
                    return (Get)super.setBearerToken(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPp(Boolean bl) {
                    return (Get)super.setPp(bl);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String string) {
                    if (!CloudKMS.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }
        }
    }
}

