/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/audit/audit_log.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.audit;

/**
 *
 *
 * <pre>
 * Metadata about the request.
 * </pre>
 *
 * Protobuf type {@code google.cloud.audit.RequestMetadata}
 */
public final class RequestMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.audit.RequestMetadata)
    RequestMetadataOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use RequestMetadata.newBuilder() to construct.
  private RequestMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RequestMetadata() {
    callerIp_ = "";
    callerSuppliedUserAgent_ = "";
    callerNetwork_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RequestMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.audit.AuditLogProto
        .internal_static_google_cloud_audit_RequestMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.audit.AuditLogProto
        .internal_static_google_cloud_audit_RequestMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.audit.RequestMetadata.class,
            com.google.cloud.audit.RequestMetadata.Builder.class);
  }

  private int bitField0_;
  public static final int CALLER_IP_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object callerIp_ = "";

  /**
   *
   *
   * <pre>
   * The IP address of the caller.
   * For a caller from the internet, this will be the public IPv4 or IPv6
   * address. For calls made from inside Google's internal production network
   * from one GCP service to another, `caller_ip` will be redacted to "private".
   * For a caller from a Compute Engine VM with a external IP address,
   * `caller_ip` will be the VM's external IP address. For a caller from a
   * Compute Engine VM without a external IP address, if the VM is in the same
   * organization (or project) as the accessed resource, `caller_ip` will be the
   * VM's internal IPv4 address, otherwise `caller_ip` will be redacted to
   * "gce-internal-ip". See https://cloud.google.com/compute/docs/vpc/ for more
   * information.
   * </pre>
   *
   * <code>string caller_ip = 1;</code>
   *
   * @return The callerIp.
   */
  @java.lang.Override
  public java.lang.String getCallerIp() {
    java.lang.Object ref = callerIp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      callerIp_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The IP address of the caller.
   * For a caller from the internet, this will be the public IPv4 or IPv6
   * address. For calls made from inside Google's internal production network
   * from one GCP service to another, `caller_ip` will be redacted to "private".
   * For a caller from a Compute Engine VM with a external IP address,
   * `caller_ip` will be the VM's external IP address. For a caller from a
   * Compute Engine VM without a external IP address, if the VM is in the same
   * organization (or project) as the accessed resource, `caller_ip` will be the
   * VM's internal IPv4 address, otherwise `caller_ip` will be redacted to
   * "gce-internal-ip". See https://cloud.google.com/compute/docs/vpc/ for more
   * information.
   * </pre>
   *
   * <code>string caller_ip = 1;</code>
   *
   * @return The bytes for callerIp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCallerIpBytes() {
    java.lang.Object ref = callerIp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      callerIp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CALLER_SUPPLIED_USER_AGENT_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object callerSuppliedUserAgent_ = "";

  /**
   *
   *
   * <pre>
   * The user agent of the caller.
   * This information is not authenticated and should be treated accordingly.
   * For example:
   *
   * +   `google-api-python-client/1.4.0`:
   *     The request was made by the Google API client for Python.
   * +   `Cloud SDK Command Line Tool apitools-client/1.0 gcloud/0.9.62`:
   *     The request was made by the Google Cloud SDK CLI (gcloud).
   * +   `AppEngine-Google; (+http://code.google.com/appengine; appid:
   * s~my-project`:
   *     The request was made from the `my-project` App Engine app.
   * </pre>
   *
   * <code>string caller_supplied_user_agent = 2;</code>
   *
   * @return The callerSuppliedUserAgent.
   */
  @java.lang.Override
  public java.lang.String getCallerSuppliedUserAgent() {
    java.lang.Object ref = callerSuppliedUserAgent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      callerSuppliedUserAgent_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The user agent of the caller.
   * This information is not authenticated and should be treated accordingly.
   * For example:
   *
   * +   `google-api-python-client/1.4.0`:
   *     The request was made by the Google API client for Python.
   * +   `Cloud SDK Command Line Tool apitools-client/1.0 gcloud/0.9.62`:
   *     The request was made by the Google Cloud SDK CLI (gcloud).
   * +   `AppEngine-Google; (+http://code.google.com/appengine; appid:
   * s~my-project`:
   *     The request was made from the `my-project` App Engine app.
   * </pre>
   *
   * <code>string caller_supplied_user_agent = 2;</code>
   *
   * @return The bytes for callerSuppliedUserAgent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCallerSuppliedUserAgentBytes() {
    java.lang.Object ref = callerSuppliedUserAgent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      callerSuppliedUserAgent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CALLER_NETWORK_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object callerNetwork_ = "";

  /**
   *
   *
   * <pre>
   * The network of the caller.
   * Set only if the network host project is part of the same GCP organization
   * (or project) as the accessed resource.
   * See https://cloud.google.com/compute/docs/vpc/ for more information.
   * This is a scheme-less URI full resource name. For example:
   *
   *     "//compute.googleapis.com/projects/PROJECT_ID/global/networks/NETWORK_ID"
   * </pre>
   *
   * <code>string caller_network = 3;</code>
   *
   * @return The callerNetwork.
   */
  @java.lang.Override
  public java.lang.String getCallerNetwork() {
    java.lang.Object ref = callerNetwork_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      callerNetwork_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The network of the caller.
   * Set only if the network host project is part of the same GCP organization
   * (or project) as the accessed resource.
   * See https://cloud.google.com/compute/docs/vpc/ for more information.
   * This is a scheme-less URI full resource name. For example:
   *
   *     "//compute.googleapis.com/projects/PROJECT_ID/global/networks/NETWORK_ID"
   * </pre>
   *
   * <code>string caller_network = 3;</code>
   *
   * @return The bytes for callerNetwork.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCallerNetworkBytes() {
    java.lang.Object ref = callerNetwork_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      callerNetwork_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REQUEST_ATTRIBUTES_FIELD_NUMBER = 7;
  private com.google.rpc.context.AttributeContext.Request requestAttributes_;

  /**
   *
   *
   * <pre>
   * Request attributes used in IAM condition evaluation. This field contains
   * request attributes like request time and access levels associated with
   * the request.
   *
   *
   * To get the whole view of the attributes used in IAM
   * condition evaluation, the user must also look into
   * `AuditLog.authentication_info.resource_attributes`.
   * </pre>
   *
   * <code>.google.rpc.context.AttributeContext.Request request_attributes = 7;</code>
   *
   * @return Whether the requestAttributes field is set.
   */
  @java.lang.Override
  public boolean hasRequestAttributes() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Request attributes used in IAM condition evaluation. This field contains
   * request attributes like request time and access levels associated with
   * the request.
   *
   *
   * To get the whole view of the attributes used in IAM
   * condition evaluation, the user must also look into
   * `AuditLog.authentication_info.resource_attributes`.
   * </pre>
   *
   * <code>.google.rpc.context.AttributeContext.Request request_attributes = 7;</code>
   *
   * @return The requestAttributes.
   */
  @java.lang.Override
  public com.google.rpc.context.AttributeContext.Request getRequestAttributes() {
    return requestAttributes_ == null
        ? com.google.rpc.context.AttributeContext.Request.getDefaultInstance()
        : requestAttributes_;
  }

  /**
   *
   *
   * <pre>
   * Request attributes used in IAM condition evaluation. This field contains
   * request attributes like request time and access levels associated with
   * the request.
   *
   *
   * To get the whole view of the attributes used in IAM
   * condition evaluation, the user must also look into
   * `AuditLog.authentication_info.resource_attributes`.
   * </pre>
   *
   * <code>.google.rpc.context.AttributeContext.Request request_attributes = 7;</code>
   */
  @java.lang.Override
  public com.google.rpc.context.AttributeContext.RequestOrBuilder getRequestAttributesOrBuilder() {
    return requestAttributes_ == null
        ? com.google.rpc.context.AttributeContext.Request.getDefaultInstance()
        : requestAttributes_;
  }

  public static final int DESTINATION_ATTRIBUTES_FIELD_NUMBER = 8;
  private com.google.rpc.context.AttributeContext.Peer destinationAttributes_;

  /**
   *
   *
   * <pre>
   * The destination of a network activity, such as accepting a TCP connection.
   * In a multi hop network activity, the destination represents the receiver of
   * the last hop. Only two fields are used in this message, Peer.port and
   * Peer.ip. These fields are optionally populated by those services utilizing
   * the IAM condition feature.
   * </pre>
   *
   * <code>.google.rpc.context.AttributeContext.Peer destination_attributes = 8;</code>
   *
   * @return Whether the destinationAttributes field is set.
   */
  @java.lang.Override
  public boolean hasDestinationAttributes() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * The destination of a network activity, such as accepting a TCP connection.
   * In a multi hop network activity, the destination represents the receiver of
   * the last hop. Only two fields are used in this message, Peer.port and
   * Peer.ip. These fields are optionally populated by those services utilizing
   * the IAM condition feature.
   * </pre>
   *
   * <code>.google.rpc.context.AttributeContext.Peer destination_attributes = 8;</code>
   *
   * @return The destinationAttributes.
   */
  @java.lang.Override
  public com.google.rpc.context.AttributeContext.Peer getDestinationAttributes() {
    return destinationAttributes_ == null
        ? com.google.rpc.context.AttributeContext.Peer.getDefaultInstance()
        : destinationAttributes_;
  }

  /**
   *
   *
   * <pre>
   * The destination of a network activity, such as accepting a TCP connection.
   * In a multi hop network activity, the destination represents the receiver of
   * the last hop. Only two fields are used in this message, Peer.port and
   * Peer.ip. These fields are optionally populated by those services utilizing
   * the IAM condition feature.
   * </pre>
   *
   * <code>.google.rpc.context.AttributeContext.Peer destination_attributes = 8;</code>
   */
  @java.lang.Override
  public com.google.rpc.context.AttributeContext.PeerOrBuilder getDestinationAttributesOrBuilder() {
    return destinationAttributes_ == null
        ? com.google.rpc.context.AttributeContext.Peer.getDefaultInstance()
        : destinationAttributes_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(callerIp_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, callerIp_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(callerSuppliedUserAgent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, callerSuppliedUserAgent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(callerNetwork_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, callerNetwork_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(7, getRequestAttributes());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(8, getDestinationAttributes());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(callerIp_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, callerIp_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(callerSuppliedUserAgent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, callerSuppliedUserAgent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(callerNetwork_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, callerNetwork_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getRequestAttributes());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(8, getDestinationAttributes());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.audit.RequestMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.audit.RequestMetadata other = (com.google.cloud.audit.RequestMetadata) obj;

    if (!getCallerIp().equals(other.getCallerIp())) return false;
    if (!getCallerSuppliedUserAgent().equals(other.getCallerSuppliedUserAgent())) return false;
    if (!getCallerNetwork().equals(other.getCallerNetwork())) return false;
    if (hasRequestAttributes() != other.hasRequestAttributes()) return false;
    if (hasRequestAttributes()) {
      if (!getRequestAttributes().equals(other.getRequestAttributes())) return false;
    }
    if (hasDestinationAttributes() != other.hasDestinationAttributes()) return false;
    if (hasDestinationAttributes()) {
      if (!getDestinationAttributes().equals(other.getDestinationAttributes())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CALLER_IP_FIELD_NUMBER;
    hash = (53 * hash) + getCallerIp().hashCode();
    hash = (37 * hash) + CALLER_SUPPLIED_USER_AGENT_FIELD_NUMBER;
    hash = (53 * hash) + getCallerSuppliedUserAgent().hashCode();
    hash = (37 * hash) + CALLER_NETWORK_FIELD_NUMBER;
    hash = (53 * hash) + getCallerNetwork().hashCode();
    if (hasRequestAttributes()) {
      hash = (37 * hash) + REQUEST_ATTRIBUTES_FIELD_NUMBER;
      hash = (53 * hash) + getRequestAttributes().hashCode();
    }
    if (hasDestinationAttributes()) {
      hash = (37 * hash) + DESTINATION_ATTRIBUTES_FIELD_NUMBER;
      hash = (53 * hash) + getDestinationAttributes().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.audit.RequestMetadata parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.audit.RequestMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.audit.RequestMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.audit.RequestMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.audit.RequestMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.audit.RequestMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.audit.RequestMetadata parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.audit.RequestMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.audit.RequestMetadata parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.audit.RequestMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.audit.RequestMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.audit.RequestMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.audit.RequestMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Metadata about the request.
   * </pre>
   *
   * Protobuf type {@code google.cloud.audit.RequestMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.audit.RequestMetadata)
      com.google.cloud.audit.RequestMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.audit.AuditLogProto
          .internal_static_google_cloud_audit_RequestMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.audit.AuditLogProto
          .internal_static_google_cloud_audit_RequestMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.audit.RequestMetadata.class,
              com.google.cloud.audit.RequestMetadata.Builder.class);
    }

    // Construct using com.google.cloud.audit.RequestMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getRequestAttributesFieldBuilder();
        getDestinationAttributesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      callerIp_ = "";
      callerSuppliedUserAgent_ = "";
      callerNetwork_ = "";
      requestAttributes_ = null;
      if (requestAttributesBuilder_ != null) {
        requestAttributesBuilder_.dispose();
        requestAttributesBuilder_ = null;
      }
      destinationAttributes_ = null;
      if (destinationAttributesBuilder_ != null) {
        destinationAttributesBuilder_.dispose();
        destinationAttributesBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.audit.AuditLogProto
          .internal_static_google_cloud_audit_RequestMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.audit.RequestMetadata getDefaultInstanceForType() {
      return com.google.cloud.audit.RequestMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.audit.RequestMetadata build() {
      com.google.cloud.audit.RequestMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.audit.RequestMetadata buildPartial() {
      com.google.cloud.audit.RequestMetadata result =
          new com.google.cloud.audit.RequestMetadata(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.audit.RequestMetadata result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.callerIp_ = callerIp_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.callerSuppliedUserAgent_ = callerSuppliedUserAgent_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.callerNetwork_ = callerNetwork_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.requestAttributes_ =
            requestAttributesBuilder_ == null
                ? requestAttributes_
                : requestAttributesBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.destinationAttributes_ =
            destinationAttributesBuilder_ == null
                ? destinationAttributes_
                : destinationAttributesBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.audit.RequestMetadata) {
        return mergeFrom((com.google.cloud.audit.RequestMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.audit.RequestMetadata other) {
      if (other == com.google.cloud.audit.RequestMetadata.getDefaultInstance()) return this;
      if (!other.getCallerIp().isEmpty()) {
        callerIp_ = other.callerIp_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getCallerSuppliedUserAgent().isEmpty()) {
        callerSuppliedUserAgent_ = other.callerSuppliedUserAgent_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getCallerNetwork().isEmpty()) {
        callerNetwork_ = other.callerNetwork_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasRequestAttributes()) {
        mergeRequestAttributes(other.getRequestAttributes());
      }
      if (other.hasDestinationAttributes()) {
        mergeDestinationAttributes(other.getDestinationAttributes());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                callerIp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                callerSuppliedUserAgent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                callerNetwork_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 58:
              {
                input.readMessage(
                    getRequestAttributesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getDestinationAttributesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object callerIp_ = "";

    /**
     *
     *
     * <pre>
     * The IP address of the caller.
     * For a caller from the internet, this will be the public IPv4 or IPv6
     * address. For calls made from inside Google's internal production network
     * from one GCP service to another, `caller_ip` will be redacted to "private".
     * For a caller from a Compute Engine VM with a external IP address,
     * `caller_ip` will be the VM's external IP address. For a caller from a
     * Compute Engine VM without a external IP address, if the VM is in the same
     * organization (or project) as the accessed resource, `caller_ip` will be the
     * VM's internal IPv4 address, otherwise `caller_ip` will be redacted to
     * "gce-internal-ip". See https://cloud.google.com/compute/docs/vpc/ for more
     * information.
     * </pre>
     *
     * <code>string caller_ip = 1;</code>
     *
     * @return The callerIp.
     */
    public java.lang.String getCallerIp() {
      java.lang.Object ref = callerIp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        callerIp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The IP address of the caller.
     * For a caller from the internet, this will be the public IPv4 or IPv6
     * address. For calls made from inside Google's internal production network
     * from one GCP service to another, `caller_ip` will be redacted to "private".
     * For a caller from a Compute Engine VM with a external IP address,
     * `caller_ip` will be the VM's external IP address. For a caller from a
     * Compute Engine VM without a external IP address, if the VM is in the same
     * organization (or project) as the accessed resource, `caller_ip` will be the
     * VM's internal IPv4 address, otherwise `caller_ip` will be redacted to
     * "gce-internal-ip". See https://cloud.google.com/compute/docs/vpc/ for more
     * information.
     * </pre>
     *
     * <code>string caller_ip = 1;</code>
     *
     * @return The bytes for callerIp.
     */
    public com.google.protobuf.ByteString getCallerIpBytes() {
      java.lang.Object ref = callerIp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        callerIp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The IP address of the caller.
     * For a caller from the internet, this will be the public IPv4 or IPv6
     * address. For calls made from inside Google's internal production network
     * from one GCP service to another, `caller_ip` will be redacted to "private".
     * For a caller from a Compute Engine VM with a external IP address,
     * `caller_ip` will be the VM's external IP address. For a caller from a
     * Compute Engine VM without a external IP address, if the VM is in the same
     * organization (or project) as the accessed resource, `caller_ip` will be the
     * VM's internal IPv4 address, otherwise `caller_ip` will be redacted to
     * "gce-internal-ip". See https://cloud.google.com/compute/docs/vpc/ for more
     * information.
     * </pre>
     *
     * <code>string caller_ip = 1;</code>
     *
     * @param value The callerIp to set.
     * @return This builder for chaining.
     */
    public Builder setCallerIp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      callerIp_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The IP address of the caller.
     * For a caller from the internet, this will be the public IPv4 or IPv6
     * address. For calls made from inside Google's internal production network
     * from one GCP service to another, `caller_ip` will be redacted to "private".
     * For a caller from a Compute Engine VM with a external IP address,
     * `caller_ip` will be the VM's external IP address. For a caller from a
     * Compute Engine VM without a external IP address, if the VM is in the same
     * organization (or project) as the accessed resource, `caller_ip` will be the
     * VM's internal IPv4 address, otherwise `caller_ip` will be redacted to
     * "gce-internal-ip". See https://cloud.google.com/compute/docs/vpc/ for more
     * information.
     * </pre>
     *
     * <code>string caller_ip = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCallerIp() {
      callerIp_ = getDefaultInstance().getCallerIp();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The IP address of the caller.
     * For a caller from the internet, this will be the public IPv4 or IPv6
     * address. For calls made from inside Google's internal production network
     * from one GCP service to another, `caller_ip` will be redacted to "private".
     * For a caller from a Compute Engine VM with a external IP address,
     * `caller_ip` will be the VM's external IP address. For a caller from a
     * Compute Engine VM without a external IP address, if the VM is in the same
     * organization (or project) as the accessed resource, `caller_ip` will be the
     * VM's internal IPv4 address, otherwise `caller_ip` will be redacted to
     * "gce-internal-ip". See https://cloud.google.com/compute/docs/vpc/ for more
     * information.
     * </pre>
     *
     * <code>string caller_ip = 1;</code>
     *
     * @param value The bytes for callerIp to set.
     * @return This builder for chaining.
     */
    public Builder setCallerIpBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      callerIp_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object callerSuppliedUserAgent_ = "";

    /**
     *
     *
     * <pre>
     * The user agent of the caller.
     * This information is not authenticated and should be treated accordingly.
     * For example:
     *
     * +   `google-api-python-client/1.4.0`:
     *     The request was made by the Google API client for Python.
     * +   `Cloud SDK Command Line Tool apitools-client/1.0 gcloud/0.9.62`:
     *     The request was made by the Google Cloud SDK CLI (gcloud).
     * +   `AppEngine-Google; (+http://code.google.com/appengine; appid:
     * s~my-project`:
     *     The request was made from the `my-project` App Engine app.
     * </pre>
     *
     * <code>string caller_supplied_user_agent = 2;</code>
     *
     * @return The callerSuppliedUserAgent.
     */
    public java.lang.String getCallerSuppliedUserAgent() {
      java.lang.Object ref = callerSuppliedUserAgent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        callerSuppliedUserAgent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The user agent of the caller.
     * This information is not authenticated and should be treated accordingly.
     * For example:
     *
     * +   `google-api-python-client/1.4.0`:
     *     The request was made by the Google API client for Python.
     * +   `Cloud SDK Command Line Tool apitools-client/1.0 gcloud/0.9.62`:
     *     The request was made by the Google Cloud SDK CLI (gcloud).
     * +   `AppEngine-Google; (+http://code.google.com/appengine; appid:
     * s~my-project`:
     *     The request was made from the `my-project` App Engine app.
     * </pre>
     *
     * <code>string caller_supplied_user_agent = 2;</code>
     *
     * @return The bytes for callerSuppliedUserAgent.
     */
    public com.google.protobuf.ByteString getCallerSuppliedUserAgentBytes() {
      java.lang.Object ref = callerSuppliedUserAgent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        callerSuppliedUserAgent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The user agent of the caller.
     * This information is not authenticated and should be treated accordingly.
     * For example:
     *
     * +   `google-api-python-client/1.4.0`:
     *     The request was made by the Google API client for Python.
     * +   `Cloud SDK Command Line Tool apitools-client/1.0 gcloud/0.9.62`:
     *     The request was made by the Google Cloud SDK CLI (gcloud).
     * +   `AppEngine-Google; (+http://code.google.com/appengine; appid:
     * s~my-project`:
     *     The request was made from the `my-project` App Engine app.
     * </pre>
     *
     * <code>string caller_supplied_user_agent = 2;</code>
     *
     * @param value The callerSuppliedUserAgent to set.
     * @return This builder for chaining.
     */
    public Builder setCallerSuppliedUserAgent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      callerSuppliedUserAgent_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The user agent of the caller.
     * This information is not authenticated and should be treated accordingly.
     * For example:
     *
     * +   `google-api-python-client/1.4.0`:
     *     The request was made by the Google API client for Python.
     * +   `Cloud SDK Command Line Tool apitools-client/1.0 gcloud/0.9.62`:
     *     The request was made by the Google Cloud SDK CLI (gcloud).
     * +   `AppEngine-Google; (+http://code.google.com/appengine; appid:
     * s~my-project`:
     *     The request was made from the `my-project` App Engine app.
     * </pre>
     *
     * <code>string caller_supplied_user_agent = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCallerSuppliedUserAgent() {
      callerSuppliedUserAgent_ = getDefaultInstance().getCallerSuppliedUserAgent();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The user agent of the caller.
     * This information is not authenticated and should be treated accordingly.
     * For example:
     *
     * +   `google-api-python-client/1.4.0`:
     *     The request was made by the Google API client for Python.
     * +   `Cloud SDK Command Line Tool apitools-client/1.0 gcloud/0.9.62`:
     *     The request was made by the Google Cloud SDK CLI (gcloud).
     * +   `AppEngine-Google; (+http://code.google.com/appengine; appid:
     * s~my-project`:
     *     The request was made from the `my-project` App Engine app.
     * </pre>
     *
     * <code>string caller_supplied_user_agent = 2;</code>
     *
     * @param value The bytes for callerSuppliedUserAgent to set.
     * @return This builder for chaining.
     */
    public Builder setCallerSuppliedUserAgentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      callerSuppliedUserAgent_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object callerNetwork_ = "";

    /**
     *
     *
     * <pre>
     * The network of the caller.
     * Set only if the network host project is part of the same GCP organization
     * (or project) as the accessed resource.
     * See https://cloud.google.com/compute/docs/vpc/ for more information.
     * This is a scheme-less URI full resource name. For example:
     *
     *     "//compute.googleapis.com/projects/PROJECT_ID/global/networks/NETWORK_ID"
     * </pre>
     *
     * <code>string caller_network = 3;</code>
     *
     * @return The callerNetwork.
     */
    public java.lang.String getCallerNetwork() {
      java.lang.Object ref = callerNetwork_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        callerNetwork_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The network of the caller.
     * Set only if the network host project is part of the same GCP organization
     * (or project) as the accessed resource.
     * See https://cloud.google.com/compute/docs/vpc/ for more information.
     * This is a scheme-less URI full resource name. For example:
     *
     *     "//compute.googleapis.com/projects/PROJECT_ID/global/networks/NETWORK_ID"
     * </pre>
     *
     * <code>string caller_network = 3;</code>
     *
     * @return The bytes for callerNetwork.
     */
    public com.google.protobuf.ByteString getCallerNetworkBytes() {
      java.lang.Object ref = callerNetwork_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        callerNetwork_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The network of the caller.
     * Set only if the network host project is part of the same GCP organization
     * (or project) as the accessed resource.
     * See https://cloud.google.com/compute/docs/vpc/ for more information.
     * This is a scheme-less URI full resource name. For example:
     *
     *     "//compute.googleapis.com/projects/PROJECT_ID/global/networks/NETWORK_ID"
     * </pre>
     *
     * <code>string caller_network = 3;</code>
     *
     * @param value The callerNetwork to set.
     * @return This builder for chaining.
     */
    public Builder setCallerNetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      callerNetwork_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The network of the caller.
     * Set only if the network host project is part of the same GCP organization
     * (or project) as the accessed resource.
     * See https://cloud.google.com/compute/docs/vpc/ for more information.
     * This is a scheme-less URI full resource name. For example:
     *
     *     "//compute.googleapis.com/projects/PROJECT_ID/global/networks/NETWORK_ID"
     * </pre>
     *
     * <code>string caller_network = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCallerNetwork() {
      callerNetwork_ = getDefaultInstance().getCallerNetwork();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The network of the caller.
     * Set only if the network host project is part of the same GCP organization
     * (or project) as the accessed resource.
     * See https://cloud.google.com/compute/docs/vpc/ for more information.
     * This is a scheme-less URI full resource name. For example:
     *
     *     "//compute.googleapis.com/projects/PROJECT_ID/global/networks/NETWORK_ID"
     * </pre>
     *
     * <code>string caller_network = 3;</code>
     *
     * @param value The bytes for callerNetwork to set.
     * @return This builder for chaining.
     */
    public Builder setCallerNetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      callerNetwork_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.rpc.context.AttributeContext.Request requestAttributes_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.context.AttributeContext.Request,
            com.google.rpc.context.AttributeContext.Request.Builder,
            com.google.rpc.context.AttributeContext.RequestOrBuilder>
        requestAttributesBuilder_;

    /**
     *
     *
     * <pre>
     * Request attributes used in IAM condition evaluation. This field contains
     * request attributes like request time and access levels associated with
     * the request.
     *
     *
     * To get the whole view of the attributes used in IAM
     * condition evaluation, the user must also look into
     * `AuditLog.authentication_info.resource_attributes`.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Request request_attributes = 7;</code>
     *
     * @return Whether the requestAttributes field is set.
     */
    public boolean hasRequestAttributes() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Request attributes used in IAM condition evaluation. This field contains
     * request attributes like request time and access levels associated with
     * the request.
     *
     *
     * To get the whole view of the attributes used in IAM
     * condition evaluation, the user must also look into
     * `AuditLog.authentication_info.resource_attributes`.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Request request_attributes = 7;</code>
     *
     * @return The requestAttributes.
     */
    public com.google.rpc.context.AttributeContext.Request getRequestAttributes() {
      if (requestAttributesBuilder_ == null) {
        return requestAttributes_ == null
            ? com.google.rpc.context.AttributeContext.Request.getDefaultInstance()
            : requestAttributes_;
      } else {
        return requestAttributesBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Request attributes used in IAM condition evaluation. This field contains
     * request attributes like request time and access levels associated with
     * the request.
     *
     *
     * To get the whole view of the attributes used in IAM
     * condition evaluation, the user must also look into
     * `AuditLog.authentication_info.resource_attributes`.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Request request_attributes = 7;</code>
     */
    public Builder setRequestAttributes(com.google.rpc.context.AttributeContext.Request value) {
      if (requestAttributesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        requestAttributes_ = value;
      } else {
        requestAttributesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Request attributes used in IAM condition evaluation. This field contains
     * request attributes like request time and access levels associated with
     * the request.
     *
     *
     * To get the whole view of the attributes used in IAM
     * condition evaluation, the user must also look into
     * `AuditLog.authentication_info.resource_attributes`.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Request request_attributes = 7;</code>
     */
    public Builder setRequestAttributes(
        com.google.rpc.context.AttributeContext.Request.Builder builderForValue) {
      if (requestAttributesBuilder_ == null) {
        requestAttributes_ = builderForValue.build();
      } else {
        requestAttributesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Request attributes used in IAM condition evaluation. This field contains
     * request attributes like request time and access levels associated with
     * the request.
     *
     *
     * To get the whole view of the attributes used in IAM
     * condition evaluation, the user must also look into
     * `AuditLog.authentication_info.resource_attributes`.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Request request_attributes = 7;</code>
     */
    public Builder mergeRequestAttributes(com.google.rpc.context.AttributeContext.Request value) {
      if (requestAttributesBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && requestAttributes_ != null
            && requestAttributes_
                != com.google.rpc.context.AttributeContext.Request.getDefaultInstance()) {
          getRequestAttributesBuilder().mergeFrom(value);
        } else {
          requestAttributes_ = value;
        }
      } else {
        requestAttributesBuilder_.mergeFrom(value);
      }
      if (requestAttributes_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Request attributes used in IAM condition evaluation. This field contains
     * request attributes like request time and access levels associated with
     * the request.
     *
     *
     * To get the whole view of the attributes used in IAM
     * condition evaluation, the user must also look into
     * `AuditLog.authentication_info.resource_attributes`.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Request request_attributes = 7;</code>
     */
    public Builder clearRequestAttributes() {
      bitField0_ = (bitField0_ & ~0x00000008);
      requestAttributes_ = null;
      if (requestAttributesBuilder_ != null) {
        requestAttributesBuilder_.dispose();
        requestAttributesBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Request attributes used in IAM condition evaluation. This field contains
     * request attributes like request time and access levels associated with
     * the request.
     *
     *
     * To get the whole view of the attributes used in IAM
     * condition evaluation, the user must also look into
     * `AuditLog.authentication_info.resource_attributes`.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Request request_attributes = 7;</code>
     */
    public com.google.rpc.context.AttributeContext.Request.Builder getRequestAttributesBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getRequestAttributesFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Request attributes used in IAM condition evaluation. This field contains
     * request attributes like request time and access levels associated with
     * the request.
     *
     *
     * To get the whole view of the attributes used in IAM
     * condition evaluation, the user must also look into
     * `AuditLog.authentication_info.resource_attributes`.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Request request_attributes = 7;</code>
     */
    public com.google.rpc.context.AttributeContext.RequestOrBuilder
        getRequestAttributesOrBuilder() {
      if (requestAttributesBuilder_ != null) {
        return requestAttributesBuilder_.getMessageOrBuilder();
      } else {
        return requestAttributes_ == null
            ? com.google.rpc.context.AttributeContext.Request.getDefaultInstance()
            : requestAttributes_;
      }
    }

    /**
     *
     *
     * <pre>
     * Request attributes used in IAM condition evaluation. This field contains
     * request attributes like request time and access levels associated with
     * the request.
     *
     *
     * To get the whole view of the attributes used in IAM
     * condition evaluation, the user must also look into
     * `AuditLog.authentication_info.resource_attributes`.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Request request_attributes = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.context.AttributeContext.Request,
            com.google.rpc.context.AttributeContext.Request.Builder,
            com.google.rpc.context.AttributeContext.RequestOrBuilder>
        getRequestAttributesFieldBuilder() {
      if (requestAttributesBuilder_ == null) {
        requestAttributesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.context.AttributeContext.Request,
                com.google.rpc.context.AttributeContext.Request.Builder,
                com.google.rpc.context.AttributeContext.RequestOrBuilder>(
                getRequestAttributes(), getParentForChildren(), isClean());
        requestAttributes_ = null;
      }
      return requestAttributesBuilder_;
    }

    private com.google.rpc.context.AttributeContext.Peer destinationAttributes_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.context.AttributeContext.Peer,
            com.google.rpc.context.AttributeContext.Peer.Builder,
            com.google.rpc.context.AttributeContext.PeerOrBuilder>
        destinationAttributesBuilder_;

    /**
     *
     *
     * <pre>
     * The destination of a network activity, such as accepting a TCP connection.
     * In a multi hop network activity, the destination represents the receiver of
     * the last hop. Only two fields are used in this message, Peer.port and
     * Peer.ip. These fields are optionally populated by those services utilizing
     * the IAM condition feature.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Peer destination_attributes = 8;</code>
     *
     * @return Whether the destinationAttributes field is set.
     */
    public boolean hasDestinationAttributes() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * The destination of a network activity, such as accepting a TCP connection.
     * In a multi hop network activity, the destination represents the receiver of
     * the last hop. Only two fields are used in this message, Peer.port and
     * Peer.ip. These fields are optionally populated by those services utilizing
     * the IAM condition feature.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Peer destination_attributes = 8;</code>
     *
     * @return The destinationAttributes.
     */
    public com.google.rpc.context.AttributeContext.Peer getDestinationAttributes() {
      if (destinationAttributesBuilder_ == null) {
        return destinationAttributes_ == null
            ? com.google.rpc.context.AttributeContext.Peer.getDefaultInstance()
            : destinationAttributes_;
      } else {
        return destinationAttributesBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The destination of a network activity, such as accepting a TCP connection.
     * In a multi hop network activity, the destination represents the receiver of
     * the last hop. Only two fields are used in this message, Peer.port and
     * Peer.ip. These fields are optionally populated by those services utilizing
     * the IAM condition feature.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Peer destination_attributes = 8;</code>
     */
    public Builder setDestinationAttributes(com.google.rpc.context.AttributeContext.Peer value) {
      if (destinationAttributesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destinationAttributes_ = value;
      } else {
        destinationAttributesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The destination of a network activity, such as accepting a TCP connection.
     * In a multi hop network activity, the destination represents the receiver of
     * the last hop. Only two fields are used in this message, Peer.port and
     * Peer.ip. These fields are optionally populated by those services utilizing
     * the IAM condition feature.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Peer destination_attributes = 8;</code>
     */
    public Builder setDestinationAttributes(
        com.google.rpc.context.AttributeContext.Peer.Builder builderForValue) {
      if (destinationAttributesBuilder_ == null) {
        destinationAttributes_ = builderForValue.build();
      } else {
        destinationAttributesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The destination of a network activity, such as accepting a TCP connection.
     * In a multi hop network activity, the destination represents the receiver of
     * the last hop. Only two fields are used in this message, Peer.port and
     * Peer.ip. These fields are optionally populated by those services utilizing
     * the IAM condition feature.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Peer destination_attributes = 8;</code>
     */
    public Builder mergeDestinationAttributes(com.google.rpc.context.AttributeContext.Peer value) {
      if (destinationAttributesBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && destinationAttributes_ != null
            && destinationAttributes_
                != com.google.rpc.context.AttributeContext.Peer.getDefaultInstance()) {
          getDestinationAttributesBuilder().mergeFrom(value);
        } else {
          destinationAttributes_ = value;
        }
      } else {
        destinationAttributesBuilder_.mergeFrom(value);
      }
      if (destinationAttributes_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The destination of a network activity, such as accepting a TCP connection.
     * In a multi hop network activity, the destination represents the receiver of
     * the last hop. Only two fields are used in this message, Peer.port and
     * Peer.ip. These fields are optionally populated by those services utilizing
     * the IAM condition feature.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Peer destination_attributes = 8;</code>
     */
    public Builder clearDestinationAttributes() {
      bitField0_ = (bitField0_ & ~0x00000010);
      destinationAttributes_ = null;
      if (destinationAttributesBuilder_ != null) {
        destinationAttributesBuilder_.dispose();
        destinationAttributesBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The destination of a network activity, such as accepting a TCP connection.
     * In a multi hop network activity, the destination represents the receiver of
     * the last hop. Only two fields are used in this message, Peer.port and
     * Peer.ip. These fields are optionally populated by those services utilizing
     * the IAM condition feature.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Peer destination_attributes = 8;</code>
     */
    public com.google.rpc.context.AttributeContext.Peer.Builder getDestinationAttributesBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getDestinationAttributesFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The destination of a network activity, such as accepting a TCP connection.
     * In a multi hop network activity, the destination represents the receiver of
     * the last hop. Only two fields are used in this message, Peer.port and
     * Peer.ip. These fields are optionally populated by those services utilizing
     * the IAM condition feature.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Peer destination_attributes = 8;</code>
     */
    public com.google.rpc.context.AttributeContext.PeerOrBuilder
        getDestinationAttributesOrBuilder() {
      if (destinationAttributesBuilder_ != null) {
        return destinationAttributesBuilder_.getMessageOrBuilder();
      } else {
        return destinationAttributes_ == null
            ? com.google.rpc.context.AttributeContext.Peer.getDefaultInstance()
            : destinationAttributes_;
      }
    }

    /**
     *
     *
     * <pre>
     * The destination of a network activity, such as accepting a TCP connection.
     * In a multi hop network activity, the destination represents the receiver of
     * the last hop. Only two fields are used in this message, Peer.port and
     * Peer.ip. These fields are optionally populated by those services utilizing
     * the IAM condition feature.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext.Peer destination_attributes = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.context.AttributeContext.Peer,
            com.google.rpc.context.AttributeContext.Peer.Builder,
            com.google.rpc.context.AttributeContext.PeerOrBuilder>
        getDestinationAttributesFieldBuilder() {
      if (destinationAttributesBuilder_ == null) {
        destinationAttributesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.context.AttributeContext.Peer,
                com.google.rpc.context.AttributeContext.Peer.Builder,
                com.google.rpc.context.AttributeContext.PeerOrBuilder>(
                getDestinationAttributes(), getParentForChildren(), isClean());
        destinationAttributes_ = null;
      }
      return destinationAttributesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.audit.RequestMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.audit.RequestMetadata)
  private static final com.google.cloud.audit.RequestMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.audit.RequestMetadata();
  }

  public static com.google.cloud.audit.RequestMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RequestMetadata> PARSER =
      new com.google.protobuf.AbstractParser<RequestMetadata>() {
        @java.lang.Override
        public RequestMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RequestMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RequestMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.audit.RequestMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
