/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/oslogin/v1/oslogin.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.oslogin.v1;

/**
 *
 *
 * <pre>
 * The user profile information used for logging in to a virtual machine on
 * Google Compute Engine.
 * </pre>
 *
 * Protobuf type {@code google.cloud.oslogin.v1.LoginProfile}
 */
public final class LoginProfile extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.oslogin.v1.LoginProfile)
    LoginProfileOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use LoginProfile.newBuilder() to construct.
  private LoginProfile(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private LoginProfile() {
    name_ = "";
    posixAccounts_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new LoginProfile();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.oslogin.v1.OsLoginProto
        .internal_static_google_cloud_oslogin_v1_LoginProfile_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 3:
        return internalGetSshPublicKeys();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.oslogin.v1.OsLoginProto
        .internal_static_google_cloud_oslogin_v1_LoginProfile_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.oslogin.v1.LoginProfile.class,
            com.google.cloud.oslogin.v1.LoginProfile.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Required. A unique user ID.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. A unique user ID.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int POSIX_ACCOUNTS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.oslogin.common.OsLoginProto.PosixAccount> posixAccounts_;

  /**
   *
   *
   * <pre>
   * The list of POSIX accounts associated with the user.
   * </pre>
   *
   * <code>repeated .google.cloud.oslogin.common.PosixAccount posix_accounts = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.oslogin.common.OsLoginProto.PosixAccount>
      getPosixAccountsList() {
    return posixAccounts_;
  }

  /**
   *
   *
   * <pre>
   * The list of POSIX accounts associated with the user.
   * </pre>
   *
   * <code>repeated .google.cloud.oslogin.common.PosixAccount posix_accounts = 2;</code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.oslogin.common.OsLoginProto.PosixAccountOrBuilder>
      getPosixAccountsOrBuilderList() {
    return posixAccounts_;
  }

  /**
   *
   *
   * <pre>
   * The list of POSIX accounts associated with the user.
   * </pre>
   *
   * <code>repeated .google.cloud.oslogin.common.PosixAccount posix_accounts = 2;</code>
   */
  @java.lang.Override
  public int getPosixAccountsCount() {
    return posixAccounts_.size();
  }

  /**
   *
   *
   * <pre>
   * The list of POSIX accounts associated with the user.
   * </pre>
   *
   * <code>repeated .google.cloud.oslogin.common.PosixAccount posix_accounts = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.oslogin.common.OsLoginProto.PosixAccount getPosixAccounts(int index) {
    return posixAccounts_.get(index);
  }

  /**
   *
   *
   * <pre>
   * The list of POSIX accounts associated with the user.
   * </pre>
   *
   * <code>repeated .google.cloud.oslogin.common.PosixAccount posix_accounts = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.oslogin.common.OsLoginProto.PosixAccountOrBuilder
      getPosixAccountsOrBuilder(int index) {
    return posixAccounts_.get(index);
  }

  public static final int SSH_PUBLIC_KEYS_FIELD_NUMBER = 3;

  private static final class SshPublicKeysDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey>
                    newDefaultInstance(
                        com.google.cloud.oslogin.v1.OsLoginProto
                            .internal_static_google_cloud_oslogin_v1_LoginProfile_SshPublicKeysEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey
                            .getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey>
      sshPublicKeys_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey>
      internalGetSshPublicKeys() {
    if (sshPublicKeys_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          SshPublicKeysDefaultEntryHolder.defaultEntry);
    }
    return sshPublicKeys_;
  }

  public int getSshPublicKeysCount() {
    return internalGetSshPublicKeys().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * A map from SSH public key fingerprint to the associated key object.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.oslogin.common.SshPublicKey&gt; ssh_public_keys = 3;</code>
   */
  @java.lang.Override
  public boolean containsSshPublicKeys(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetSshPublicKeys().getMap().containsKey(key);
  }

  /** Use {@link #getSshPublicKeysMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey>
      getSshPublicKeys() {
    return getSshPublicKeysMap();
  }

  /**
   *
   *
   * <pre>
   * A map from SSH public key fingerprint to the associated key object.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.oslogin.common.SshPublicKey&gt; ssh_public_keys = 3;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey>
      getSshPublicKeysMap() {
    return internalGetSshPublicKeys().getMap();
  }

  /**
   *
   *
   * <pre>
   * A map from SSH public key fingerprint to the associated key object.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.oslogin.common.SshPublicKey&gt; ssh_public_keys = 3;</code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey
      getSshPublicKeysOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey> map =
        internalGetSshPublicKeys().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * A map from SSH public key fingerprint to the associated key object.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.oslogin.common.SshPublicKey&gt; ssh_public_keys = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey getSshPublicKeysOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey> map =
        internalGetSshPublicKeys().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    for (int i = 0; i < posixAccounts_.size(); i++) {
      output.writeMessage(2, posixAccounts_.get(i));
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetSshPublicKeys(), SshPublicKeysDefaultEntryHolder.defaultEntry, 3);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    for (int i = 0; i < posixAccounts_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, posixAccounts_.get(i));
    }
    for (java.util.Map.Entry<
            java.lang.String, com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey>
        entry : internalGetSshPublicKeys().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey>
          sshPublicKeys__ =
              SshPublicKeysDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, sshPublicKeys__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.oslogin.v1.LoginProfile)) {
      return super.equals(obj);
    }
    com.google.cloud.oslogin.v1.LoginProfile other = (com.google.cloud.oslogin.v1.LoginProfile) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getPosixAccountsList().equals(other.getPosixAccountsList())) return false;
    if (!internalGetSshPublicKeys().equals(other.internalGetSshPublicKeys())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getPosixAccountsCount() > 0) {
      hash = (37 * hash) + POSIX_ACCOUNTS_FIELD_NUMBER;
      hash = (53 * hash) + getPosixAccountsList().hashCode();
    }
    if (!internalGetSshPublicKeys().getMap().isEmpty()) {
      hash = (37 * hash) + SSH_PUBLIC_KEYS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetSshPublicKeys().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.oslogin.v1.LoginProfile parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.oslogin.v1.LoginProfile parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.oslogin.v1.LoginProfile parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.oslogin.v1.LoginProfile parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.oslogin.v1.LoginProfile parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.oslogin.v1.LoginProfile parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.oslogin.v1.LoginProfile parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.oslogin.v1.LoginProfile parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.oslogin.v1.LoginProfile parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.oslogin.v1.LoginProfile parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.oslogin.v1.LoginProfile parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.oslogin.v1.LoginProfile parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.oslogin.v1.LoginProfile prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The user profile information used for logging in to a virtual machine on
   * Google Compute Engine.
   * </pre>
   *
   * Protobuf type {@code google.cloud.oslogin.v1.LoginProfile}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.oslogin.v1.LoginProfile)
      com.google.cloud.oslogin.v1.LoginProfileOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.oslogin.v1.OsLoginProto
          .internal_static_google_cloud_oslogin_v1_LoginProfile_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetSshPublicKeys();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetMutableSshPublicKeys();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.oslogin.v1.OsLoginProto
          .internal_static_google_cloud_oslogin_v1_LoginProfile_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.oslogin.v1.LoginProfile.class,
              com.google.cloud.oslogin.v1.LoginProfile.Builder.class);
    }

    // Construct using com.google.cloud.oslogin.v1.LoginProfile.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      if (posixAccountsBuilder_ == null) {
        posixAccounts_ = java.util.Collections.emptyList();
      } else {
        posixAccounts_ = null;
        posixAccountsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      internalGetMutableSshPublicKeys().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.oslogin.v1.OsLoginProto
          .internal_static_google_cloud_oslogin_v1_LoginProfile_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.oslogin.v1.LoginProfile getDefaultInstanceForType() {
      return com.google.cloud.oslogin.v1.LoginProfile.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.oslogin.v1.LoginProfile build() {
      com.google.cloud.oslogin.v1.LoginProfile result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.oslogin.v1.LoginProfile buildPartial() {
      com.google.cloud.oslogin.v1.LoginProfile result =
          new com.google.cloud.oslogin.v1.LoginProfile(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.oslogin.v1.LoginProfile result) {
      if (posixAccountsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          posixAccounts_ = java.util.Collections.unmodifiableList(posixAccounts_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.posixAccounts_ = posixAccounts_;
      } else {
        result.posixAccounts_ = posixAccountsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.oslogin.v1.LoginProfile result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.sshPublicKeys_ =
            internalGetSshPublicKeys().build(SshPublicKeysDefaultEntryHolder.defaultEntry);
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.oslogin.v1.LoginProfile) {
        return mergeFrom((com.google.cloud.oslogin.v1.LoginProfile) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.oslogin.v1.LoginProfile other) {
      if (other == com.google.cloud.oslogin.v1.LoginProfile.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (posixAccountsBuilder_ == null) {
        if (!other.posixAccounts_.isEmpty()) {
          if (posixAccounts_.isEmpty()) {
            posixAccounts_ = other.posixAccounts_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensurePosixAccountsIsMutable();
            posixAccounts_.addAll(other.posixAccounts_);
          }
          onChanged();
        }
      } else {
        if (!other.posixAccounts_.isEmpty()) {
          if (posixAccountsBuilder_.isEmpty()) {
            posixAccountsBuilder_.dispose();
            posixAccountsBuilder_ = null;
            posixAccounts_ = other.posixAccounts_;
            bitField0_ = (bitField0_ & ~0x00000002);
            posixAccountsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPosixAccountsFieldBuilder()
                    : null;
          } else {
            posixAccountsBuilder_.addAllMessages(other.posixAccounts_);
          }
        }
      }
      internalGetMutableSshPublicKeys().mergeFrom(other.internalGetSshPublicKeys());
      bitField0_ |= 0x00000004;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.oslogin.common.OsLoginProto.PosixAccount m =
                    input.readMessage(
                        com.google.cloud.oslogin.common.OsLoginProto.PosixAccount.parser(),
                        extensionRegistry);
                if (posixAccountsBuilder_ == null) {
                  ensurePosixAccountsIsMutable();
                  posixAccounts_.add(m);
                } else {
                  posixAccountsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String, com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey>
                    sshPublicKeys__ =
                        input.readMessage(
                            SshPublicKeysDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableSshPublicKeys()
                    .ensureBuilderMap()
                    .put(sshPublicKeys__.getKey(), sshPublicKeys__.getValue());
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Required. A unique user ID.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. A unique user ID.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. A unique user ID.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. A unique user ID.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. A unique user ID.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.oslogin.common.OsLoginProto.PosixAccount>
        posixAccounts_ = java.util.Collections.emptyList();

    private void ensurePosixAccountsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        posixAccounts_ =
            new java.util.ArrayList<com.google.cloud.oslogin.common.OsLoginProto.PosixAccount>(
                posixAccounts_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.oslogin.common.OsLoginProto.PosixAccount,
            com.google.cloud.oslogin.common.OsLoginProto.PosixAccount.Builder,
            com.google.cloud.oslogin.common.OsLoginProto.PosixAccountOrBuilder>
        posixAccountsBuilder_;

    /**
     *
     *
     * <pre>
     * The list of POSIX accounts associated with the user.
     * </pre>
     *
     * <code>repeated .google.cloud.oslogin.common.PosixAccount posix_accounts = 2;</code>
     */
    public java.util.List<com.google.cloud.oslogin.common.OsLoginProto.PosixAccount>
        getPosixAccountsList() {
      if (posixAccountsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(posixAccounts_);
      } else {
        return posixAccountsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * The list of POSIX accounts associated with the user.
     * </pre>
     *
     * <code>repeated .google.cloud.oslogin.common.PosixAccount posix_accounts = 2;</code>
     */
    public int getPosixAccountsCount() {
      if (posixAccountsBuilder_ == null) {
        return posixAccounts_.size();
      } else {
        return posixAccountsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * The list of POSIX accounts associated with the user.
     * </pre>
     *
     * <code>repeated .google.cloud.oslogin.common.PosixAccount posix_accounts = 2;</code>
     */
    public com.google.cloud.oslogin.common.OsLoginProto.PosixAccount getPosixAccounts(int index) {
      if (posixAccountsBuilder_ == null) {
        return posixAccounts_.get(index);
      } else {
        return posixAccountsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The list of POSIX accounts associated with the user.
     * </pre>
     *
     * <code>repeated .google.cloud.oslogin.common.PosixAccount posix_accounts = 2;</code>
     */
    public Builder setPosixAccounts(
        int index, com.google.cloud.oslogin.common.OsLoginProto.PosixAccount value) {
      if (posixAccountsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePosixAccountsIsMutable();
        posixAccounts_.set(index, value);
        onChanged();
      } else {
        posixAccountsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of POSIX accounts associated with the user.
     * </pre>
     *
     * <code>repeated .google.cloud.oslogin.common.PosixAccount posix_accounts = 2;</code>
     */
    public Builder setPosixAccounts(
        int index,
        com.google.cloud.oslogin.common.OsLoginProto.PosixAccount.Builder builderForValue) {
      if (posixAccountsBuilder_ == null) {
        ensurePosixAccountsIsMutable();
        posixAccounts_.set(index, builderForValue.build());
        onChanged();
      } else {
        posixAccountsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of POSIX accounts associated with the user.
     * </pre>
     *
     * <code>repeated .google.cloud.oslogin.common.PosixAccount posix_accounts = 2;</code>
     */
    public Builder addPosixAccounts(
        com.google.cloud.oslogin.common.OsLoginProto.PosixAccount value) {
      if (posixAccountsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePosixAccountsIsMutable();
        posixAccounts_.add(value);
        onChanged();
      } else {
        posixAccountsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of POSIX accounts associated with the user.
     * </pre>
     *
     * <code>repeated .google.cloud.oslogin.common.PosixAccount posix_accounts = 2;</code>
     */
    public Builder addPosixAccounts(
        int index, com.google.cloud.oslogin.common.OsLoginProto.PosixAccount value) {
      if (posixAccountsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePosixAccountsIsMutable();
        posixAccounts_.add(index, value);
        onChanged();
      } else {
        posixAccountsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of POSIX accounts associated with the user.
     * </pre>
     *
     * <code>repeated .google.cloud.oslogin.common.PosixAccount posix_accounts = 2;</code>
     */
    public Builder addPosixAccounts(
        com.google.cloud.oslogin.common.OsLoginProto.PosixAccount.Builder builderForValue) {
      if (posixAccountsBuilder_ == null) {
        ensurePosixAccountsIsMutable();
        posixAccounts_.add(builderForValue.build());
        onChanged();
      } else {
        posixAccountsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of POSIX accounts associated with the user.
     * </pre>
     *
     * <code>repeated .google.cloud.oslogin.common.PosixAccount posix_accounts = 2;</code>
     */
    public Builder addPosixAccounts(
        int index,
        com.google.cloud.oslogin.common.OsLoginProto.PosixAccount.Builder builderForValue) {
      if (posixAccountsBuilder_ == null) {
        ensurePosixAccountsIsMutable();
        posixAccounts_.add(index, builderForValue.build());
        onChanged();
      } else {
        posixAccountsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of POSIX accounts associated with the user.
     * </pre>
     *
     * <code>repeated .google.cloud.oslogin.common.PosixAccount posix_accounts = 2;</code>
     */
    public Builder addAllPosixAccounts(
        java.lang.Iterable<? extends com.google.cloud.oslogin.common.OsLoginProto.PosixAccount>
            values) {
      if (posixAccountsBuilder_ == null) {
        ensurePosixAccountsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, posixAccounts_);
        onChanged();
      } else {
        posixAccountsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of POSIX accounts associated with the user.
     * </pre>
     *
     * <code>repeated .google.cloud.oslogin.common.PosixAccount posix_accounts = 2;</code>
     */
    public Builder clearPosixAccounts() {
      if (posixAccountsBuilder_ == null) {
        posixAccounts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        posixAccountsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of POSIX accounts associated with the user.
     * </pre>
     *
     * <code>repeated .google.cloud.oslogin.common.PosixAccount posix_accounts = 2;</code>
     */
    public Builder removePosixAccounts(int index) {
      if (posixAccountsBuilder_ == null) {
        ensurePosixAccountsIsMutable();
        posixAccounts_.remove(index);
        onChanged();
      } else {
        posixAccountsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of POSIX accounts associated with the user.
     * </pre>
     *
     * <code>repeated .google.cloud.oslogin.common.PosixAccount posix_accounts = 2;</code>
     */
    public com.google.cloud.oslogin.common.OsLoginProto.PosixAccount.Builder
        getPosixAccountsBuilder(int index) {
      return getPosixAccountsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * The list of POSIX accounts associated with the user.
     * </pre>
     *
     * <code>repeated .google.cloud.oslogin.common.PosixAccount posix_accounts = 2;</code>
     */
    public com.google.cloud.oslogin.common.OsLoginProto.PosixAccountOrBuilder
        getPosixAccountsOrBuilder(int index) {
      if (posixAccountsBuilder_ == null) {
        return posixAccounts_.get(index);
      } else {
        return posixAccountsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The list of POSIX accounts associated with the user.
     * </pre>
     *
     * <code>repeated .google.cloud.oslogin.common.PosixAccount posix_accounts = 2;</code>
     */
    public java.util.List<
            ? extends com.google.cloud.oslogin.common.OsLoginProto.PosixAccountOrBuilder>
        getPosixAccountsOrBuilderList() {
      if (posixAccountsBuilder_ != null) {
        return posixAccountsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(posixAccounts_);
      }
    }

    /**
     *
     *
     * <pre>
     * The list of POSIX accounts associated with the user.
     * </pre>
     *
     * <code>repeated .google.cloud.oslogin.common.PosixAccount posix_accounts = 2;</code>
     */
    public com.google.cloud.oslogin.common.OsLoginProto.PosixAccount.Builder
        addPosixAccountsBuilder() {
      return getPosixAccountsFieldBuilder()
          .addBuilder(
              com.google.cloud.oslogin.common.OsLoginProto.PosixAccount.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The list of POSIX accounts associated with the user.
     * </pre>
     *
     * <code>repeated .google.cloud.oslogin.common.PosixAccount posix_accounts = 2;</code>
     */
    public com.google.cloud.oslogin.common.OsLoginProto.PosixAccount.Builder
        addPosixAccountsBuilder(int index) {
      return getPosixAccountsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.oslogin.common.OsLoginProto.PosixAccount.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The list of POSIX accounts associated with the user.
     * </pre>
     *
     * <code>repeated .google.cloud.oslogin.common.PosixAccount posix_accounts = 2;</code>
     */
    public java.util.List<com.google.cloud.oslogin.common.OsLoginProto.PosixAccount.Builder>
        getPosixAccountsBuilderList() {
      return getPosixAccountsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.oslogin.common.OsLoginProto.PosixAccount,
            com.google.cloud.oslogin.common.OsLoginProto.PosixAccount.Builder,
            com.google.cloud.oslogin.common.OsLoginProto.PosixAccountOrBuilder>
        getPosixAccountsFieldBuilder() {
      if (posixAccountsBuilder_ == null) {
        posixAccountsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.oslogin.common.OsLoginProto.PosixAccount,
                com.google.cloud.oslogin.common.OsLoginProto.PosixAccount.Builder,
                com.google.cloud.oslogin.common.OsLoginProto.PosixAccountOrBuilder>(
                posixAccounts_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        posixAccounts_ = null;
      }
      return posixAccountsBuilder_;
    }

    private static final class SshPublicKeysConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String,
            com.google.cloud.oslogin.common.OsLoginProto.SshPublicKeyOrBuilder,
            com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey> {
      @java.lang.Override
      public com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey build(
          com.google.cloud.oslogin.common.OsLoginProto.SshPublicKeyOrBuilder val) {
        if (val instanceof com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey) {
          return (com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey) val;
        }
        return ((com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey.Builder) val).build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey>
          defaultEntry() {
        return SshPublicKeysDefaultEntryHolder.defaultEntry;
      }
    }
    ;

    private static final SshPublicKeysConverter sshPublicKeysConverter =
        new SshPublicKeysConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.oslogin.common.OsLoginProto.SshPublicKeyOrBuilder,
            com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey,
            com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey.Builder>
        sshPublicKeys_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.oslogin.common.OsLoginProto.SshPublicKeyOrBuilder,
            com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey,
            com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey.Builder>
        internalGetSshPublicKeys() {
      if (sshPublicKeys_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(sshPublicKeysConverter);
      }
      return sshPublicKeys_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.oslogin.common.OsLoginProto.SshPublicKeyOrBuilder,
            com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey,
            com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey.Builder>
        internalGetMutableSshPublicKeys() {
      if (sshPublicKeys_ == null) {
        sshPublicKeys_ = new com.google.protobuf.MapFieldBuilder<>(sshPublicKeysConverter);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return sshPublicKeys_;
    }

    public int getSshPublicKeysCount() {
      return internalGetSshPublicKeys().ensureBuilderMap().size();
    }

    /**
     *
     *
     * <pre>
     * A map from SSH public key fingerprint to the associated key object.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.oslogin.common.SshPublicKey&gt; ssh_public_keys = 3;
     * </code>
     */
    @java.lang.Override
    public boolean containsSshPublicKeys(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetSshPublicKeys().ensureBuilderMap().containsKey(key);
    }

    /** Use {@link #getSshPublicKeysMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey>
        getSshPublicKeys() {
      return getSshPublicKeysMap();
    }

    /**
     *
     *
     * <pre>
     * A map from SSH public key fingerprint to the associated key object.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.oslogin.common.SshPublicKey&gt; ssh_public_keys = 3;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String, com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey>
        getSshPublicKeysMap() {
      return internalGetSshPublicKeys().getImmutableMap();
    }

    /**
     *
     *
     * <pre>
     * A map from SSH public key fingerprint to the associated key object.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.oslogin.common.SshPublicKey&gt; ssh_public_keys = 3;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey
        getSshPublicKeysOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String, com.google.cloud.oslogin.common.OsLoginProto.SshPublicKeyOrBuilder>
          map = internalGetMutableSshPublicKeys().ensureBuilderMap();
      return map.containsKey(key) ? sshPublicKeysConverter.build(map.get(key)) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * A map from SSH public key fingerprint to the associated key object.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.oslogin.common.SshPublicKey&gt; ssh_public_keys = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey getSshPublicKeysOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String, com.google.cloud.oslogin.common.OsLoginProto.SshPublicKeyOrBuilder>
          map = internalGetMutableSshPublicKeys().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return sshPublicKeysConverter.build(map.get(key));
    }

    public Builder clearSshPublicKeys() {
      bitField0_ = (bitField0_ & ~0x00000004);
      internalGetMutableSshPublicKeys().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A map from SSH public key fingerprint to the associated key object.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.oslogin.common.SshPublicKey&gt; ssh_public_keys = 3;
     * </code>
     */
    public Builder removeSshPublicKeys(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableSshPublicKeys().ensureBuilderMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey>
        getMutableSshPublicKeys() {
      bitField0_ |= 0x00000004;
      return internalGetMutableSshPublicKeys().ensureMessageMap();
    }

    /**
     *
     *
     * <pre>
     * A map from SSH public key fingerprint to the associated key object.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.oslogin.common.SshPublicKey&gt; ssh_public_keys = 3;
     * </code>
     */
    public Builder putSshPublicKeys(
        java.lang.String key, com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableSshPublicKeys().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000004;
      return this;
    }

    /**
     *
     *
     * <pre>
     * A map from SSH public key fingerprint to the associated key object.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.oslogin.common.SshPublicKey&gt; ssh_public_keys = 3;
     * </code>
     */
    public Builder putAllSshPublicKeys(
        java.util.Map<java.lang.String, com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey>
            values) {
      for (java.util.Map.Entry<
              java.lang.String, com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey>
          e : values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableSshPublicKeys().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000004;
      return this;
    }

    /**
     *
     *
     * <pre>
     * A map from SSH public key fingerprint to the associated key object.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.oslogin.common.SshPublicKey&gt; ssh_public_keys = 3;
     * </code>
     */
    public com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey.Builder
        putSshPublicKeysBuilderIfAbsent(java.lang.String key) {
      java.util.Map<
              java.lang.String, com.google.cloud.oslogin.common.OsLoginProto.SshPublicKeyOrBuilder>
          builderMap = internalGetMutableSshPublicKeys().ensureBuilderMap();
      com.google.cloud.oslogin.common.OsLoginProto.SshPublicKeyOrBuilder entry =
          builderMap.get(key);
      if (entry == null) {
        entry = com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey) {
        entry = ((com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey) entry).toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey.Builder) entry;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.oslogin.v1.LoginProfile)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.oslogin.v1.LoginProfile)
  private static final com.google.cloud.oslogin.v1.LoginProfile DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.oslogin.v1.LoginProfile();
  }

  public static com.google.cloud.oslogin.v1.LoginProfile getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<LoginProfile> PARSER =
      new com.google.protobuf.AbstractParser<LoginProfile>() {
        @java.lang.Override
        public LoginProfile parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<LoginProfile> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<LoginProfile> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.oslogin.v1.LoginProfile getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
