/*
 * Decompiled with CFR 0.152.
 */
package com.google.accompanist.drawablepainter;

import android.graphics.ColorFilter;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.RememberObserver;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.geometry.SizeKt;
import androidx.compose.ui.graphics.AndroidCanvas_androidKt;
import androidx.compose.ui.graphics.AndroidColorFilter_androidKt;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.painter.Painter;
import androidx.compose.ui.unit.LayoutDirection;
import com.google.accompanist.drawablepainter.DrawablePainter;
import com.google.accompanist.drawablepainter.DrawablePainterKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0012\u0010\u001f\u001a\u00020\u001c2\b\u0010 \u001a\u0004\u0018\u00010!H\u0014J\u0010\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$H\u0014J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020&H\u0016J\b\u0010(\u001a\u00020&H\u0016J\f\u0010)\u001a\u00020&*\u00020*H\u0014R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R+\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00138B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006+"}, d2={"Lcom/google/accompanist/drawablepainter/DrawablePainter;", "Landroidx/compose/ui/graphics/painter/Painter;", "Landroidx/compose/runtime/RememberObserver;", "drawable", "Landroid/graphics/drawable/Drawable;", "(Landroid/graphics/drawable/Drawable;)V", "callback", "Landroid/graphics/drawable/Drawable$Callback;", "getCallback", "()Landroid/graphics/drawable/Drawable$Callback;", "callback$delegate", "Lkotlin/Lazy;", "getDrawable", "()Landroid/graphics/drawable/Drawable;", "intrinsicSize", "Landroidx/compose/ui/geometry/Size;", "getIntrinsicSize-NH-jbRc", "()J", "<set-?>", "", "invalidateTick", "getInvalidateTick", "()I", "setInvalidateTick", "(I)V", "invalidateTick$delegate", "Landroidx/compose/runtime/MutableState;", "applyAlpha", "", "alpha", "", "applyColorFilter", "colorFilter", "Landroidx/compose/ui/graphics/ColorFilter;", "applyLayoutDirection", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "onAbandoned", "", "onForgotten", "onRemembered", "onDraw", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "drawablepainter_release"})
@StabilityInferred(parameters=0)
public final class DrawablePainter
extends Painter
implements RememberObserver {
    @NotNull
    private final Drawable drawable;
    @NotNull
    private final MutableState invalidateTick$delegate;
    @NotNull
    private final Lazy callback$delegate;
    public static final int $stable = 8;

    public DrawablePainter(@NotNull Drawable drawable) {
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        this.drawable = drawable;
        this.invalidateTick$delegate = SnapshotStateKt.mutableStateOf$default((Object)0, null, (int)2, null);
        this.callback$delegate = LazyKt.lazy((Function0)((Function0)new Function0<callback.1>(this){
            final /* synthetic */ DrawablePainter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final callback.1 invoke() {
                return new Drawable.Callback(this.this$0){
                    final /* synthetic */ DrawablePainter this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void invalidateDrawable(@NotNull Drawable d) {
                        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
                        DrawablePainter drawablePainter = this.this$0;
                        int n = DrawablePainter.access$getInvalidateTick(drawablePainter);
                        DrawablePainter.access$setInvalidateTick(drawablePainter, n + 1);
                    }

                    public void scheduleDrawable(@NotNull Drawable d, @NotNull Runnable what, long time) {
                        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
                        Intrinsics.checkNotNullParameter((Object)what, (String)"what");
                        DrawablePainterKt.access$getMAIN_HANDLER().postAtTime(what, time);
                    }

                    public void unscheduleDrawable(@NotNull Drawable d, @NotNull Runnable what) {
                        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
                        Intrinsics.checkNotNullParameter((Object)what, (String)"what");
                        DrawablePainterKt.access$getMAIN_HANDLER().removeCallbacks(what);
                    }
                };
            }
        }));
        if (this.drawable.getIntrinsicWidth() >= 0 && this.drawable.getIntrinsicHeight() >= 0) {
            this.drawable.setBounds(0, 0, this.drawable.getIntrinsicWidth(), this.drawable.getIntrinsicHeight());
        }
    }

    @NotNull
    public final Drawable getDrawable() {
        return this.drawable;
    }

    /*
     * WARNING - void declaration
     */
    private final int getInvalidateTick() {
        void $this$getValue$iv;
        State state = (State)this.invalidateTick$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return ((Number)$this$getValue$iv.getValue()).intValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setInvalidateTick(int n) {
        void $this$setValue$iv;
        MutableState mutableState = this.invalidateTick$delegate;
        Object var3_3 = null;
        Integer value$iv = n;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)value$iv);
    }

    private final Drawable.Callback getCallback() {
        Lazy lazy = this.callback$delegate;
        return (Drawable.Callback)lazy.getValue();
    }

    public void onRemembered() {
        this.drawable.setCallback(this.getCallback());
        this.drawable.setVisible(true, true);
        if (this.drawable instanceof Animatable) {
            ((Animatable)this.drawable).start();
        }
    }

    public void onAbandoned() {
        this.onForgotten();
    }

    public void onForgotten() {
        if (this.drawable instanceof Animatable) {
            ((Animatable)this.drawable).stop();
        }
        this.drawable.setVisible(false, false);
        this.drawable.setCallback(null);
    }

    protected boolean applyAlpha(float alpha) {
        this.drawable.setAlpha(RangesKt.coerceIn((int)MathKt.roundToInt((float)(alpha * (float)255)), (int)0, (int)255));
        return true;
    }

    protected boolean applyColorFilter(@Nullable androidx.compose.ui.graphics.ColorFilter colorFilter) {
        androidx.compose.ui.graphics.ColorFilter colorFilter2 = colorFilter;
        this.drawable.setColorFilter((ColorFilter)(colorFilter2 == null ? null : AndroidColorFilter_androidKt.asAndroidColorFilter((androidx.compose.ui.graphics.ColorFilter)colorFilter2)));
        return true;
    }

    protected boolean applyLayoutDirection(@NotNull LayoutDirection layoutDirection) {
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
        if (Build.VERSION.SDK_INT >= 23) {
            int n;
            switch (WhenMappings.$EnumSwitchMapping$0[layoutDirection.ordinal()]) {
                case 1: {
                    n = 0;
                    break;
                }
                case 2: {
                    n = 1;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return this.drawable.setLayoutDirection(n);
        }
        return false;
    }

    public long getIntrinsicSize-NH-jbRc() {
        return this.drawable.getIntrinsicWidth() >= 0 && this.drawable.getIntrinsicHeight() >= 0 ? SizeKt.Size((float)this.drawable.getIntrinsicWidth(), (float)this.drawable.getIntrinsicHeight()) : Size.Companion.getUnspecified-NH-jbRc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDraw(@NotNull DrawScope $this$onDraw) {
        Intrinsics.checkNotNullParameter((Object)$this$onDraw, (String)"<this>");
        DrawScope $this$drawIntoCanvas$iv = $this$onDraw;
        boolean $i$f$drawIntoCanvas = false;
        Canvas canvas = $this$drawIntoCanvas$iv.getDrawContext().getCanvas();
        boolean bl = false;
        this.getInvalidateTick();
        this.getDrawable().setBounds(0, 0, MathKt.roundToInt((float)Size.getWidth-impl((long)$this$onDraw.getSize-NH-jbRc())), MathKt.roundToInt((float)Size.getHeight-impl((long)$this$onDraw.getSize-NH-jbRc())));
        Canvas $this$withSave$iv = canvas;
        boolean $i$f$withSave = false;
        try {
            $this$withSave$iv.save();
            boolean bl2 = false;
            this.getDrawable().draw(AndroidCanvas_androidKt.getNativeCanvas((Canvas)canvas));
        }
        finally {
            $this$withSave$iv.restore();
        }
    }

    public static final /* synthetic */ int access$getInvalidateTick(DrawablePainter $this) {
        return $this.getInvalidateTick();
    }

    public static final /* synthetic */ void access$setInvalidateTick(DrawablePainter $this, int n) {
        $this.setInvalidateTick(n);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LayoutDirection.values().length];
            nArray[LayoutDirection.Ltr.ordinal()] = 1;
            nArray[LayoutDirection.Rtl.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

