/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs.snom.internal;

import com.github.spotbugs.snom.SpotBugsReport;
import com.github.spotbugs.snom.SpotBugsTask;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.resources.TextResource;
import org.gradle.api.resources.TextResourceFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\u000f\u001a\u0004\u0018\u00010\nH\u0016J \u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\nH\u0016J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/github/spotbugs/snom/internal/SpotBugsHtmlReport;", "Lcom/github/spotbugs/snom/SpotBugsReport;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "task", "Lcom/github/spotbugs/snom/SpotBugsTask;", "<init>", "(Lorg/gradle/api/model/ObjectFactory;Lcom/github/spotbugs/snom/SpotBugsTask;)V", "stylesheet", "Lorg/gradle/api/provider/Property;", "Lorg/gradle/api/resources/TextResource;", "commandLineOption", "", "getCommandLineOption", "()Ljava/lang/String;", "getStylesheet", "resolve", "path", "configuration", "Lorg/gradle/api/artifacts/Configuration;", "textResourceFactory", "Lorg/gradle/api/resources/TextResourceFactory;", "setStylesheet", "", "textResource", "spotbugs-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nSpotBugsHtmlReport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpotBugsHtmlReport.kt\ncom/github/spotbugs/snom/internal/SpotBugsHtmlReport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n1#2:84\n*E\n"})
public abstract class SpotBugsHtmlReport
extends SpotBugsReport {
    @NotNull
    private final Property<TextResource> stylesheet;

    @Inject
    public SpotBugsHtmlReport(@NotNull ObjectFactory objects, @NotNull SpotBugsTask task) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        Intrinsics.checkNotNullParameter((Object)((Object)task), (String)"task");
        super(objects, task);
        this.getOutputLocation().convention(task.getReportsDir().file(task.getBaseName() + ".html"));
        Property property = task.getProject().getObjects().property(TextResource.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(...)");
        this.stylesheet = property;
    }

    @Override
    @NotNull
    public String getCommandLineOption() {
        Object object = this.stylesheet.map(arg_0 -> SpotBugsHtmlReport._get_commandLineOption_$lambda$1(SpotBugsHtmlReport::_get_commandLineOption_$lambda$0, arg_0)).getOrElse((Object)"-html");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrElse(...)");
        return (String)object;
    }

    @Override
    @Nullable
    public TextResource getStylesheet() {
        return (TextResource)this.stylesheet.getOrNull();
    }

    private final TextResource resolve(String path, Configuration configuration, TextResourceFactory textResourceFactory) {
        FileCollection spotbugsJar = configuration.getIncoming().artifactView(arg_0 -> SpotBugsHtmlReport.resolve$lambda$1(SpotBugsHtmlReport::resolve$lambda$0, arg_0)).getFiles();
        if (spotbugsJar == null) {
            throw new InvalidUserDataException("The dependency on SpotBugs not found in 'spotbugs' configuration");
        }
        TextResource textResource = textResourceFactory.fromArchiveEntry((Object)spotbugsJar, path);
        Intrinsics.checkNotNull((Object)textResource);
        return textResource;
    }

    @Override
    public void setStylesheet(@Nullable TextResource textResource) {
        this.stylesheet.set((Object)textResource);
    }

    @Override
    public void setStylesheet(@Nullable String path) {
        if (path == null) {
            this.stylesheet.set(null);
        } else {
            Configuration configuration = this.getTask().getProject().getConfigurations().getByName("spotbugs");
            TextResourceFactory textResourceFactory = this.getTask().getProject().getResources().getText();
            Provider provider = this.getTask().getProject().provider(() -> SpotBugsHtmlReport.setStylesheet$lambda$0(this, path, configuration, textResourceFactory));
            Property<TextResource> property = this.stylesheet;
            Provider p0 = provider;
            boolean bl = false;
            property.set(p0);
        }
    }

    private static final String _get_commandLineOption_$lambda$0(TextResource it) {
        return "-html:" + it.asFile().getAbsolutePath();
    }

    private static final String _get_commandLineOption_$lambda$1(Function1 $tmp0, Object in) {
        return (String)$tmp0.invoke(in);
    }

    private static final Unit resolve$lambda$0(ArtifactView.ViewConfiguration it) {
        it.componentFilter(arg_0 -> SpotBugsHtmlReport.resolve$lambda$0$1(SpotBugsHtmlReport::resolve$lambda$0$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final boolean resolve$lambda$0$0(ComponentIdentifier identifier) {
        return identifier instanceof ModuleComponentIdentifier ? Intrinsics.areEqual((Object)((ModuleComponentIdentifier)identifier).getGroup(), (Object)"com.github.spotbugs") && Intrinsics.areEqual((Object)((ModuleComponentIdentifier)identifier).getModule(), (Object)"spotbugs") : false;
    }

    private static final boolean resolve$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void resolve$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final TextResource setStylesheet$lambda$0(SpotBugsHtmlReport this$0, String $path, Configuration $configuration, TextResourceFactory $textResourceFactory) {
        Intrinsics.checkNotNull((Object)$configuration);
        Intrinsics.checkNotNull((Object)$textResourceFactory);
        return this$0.resolve($path, $configuration, $textResourceFactory);
    }
}

