/*
 * Decompiled with CFR 0.152.
 */
package com.saasquatch.jsonschemainferrer;

import com.saasquatch.jsonschemainferrer.AdditionalPropertiesPolicies;
import com.saasquatch.jsonschemainferrer.AdditionalPropertiesPolicy;
import com.saasquatch.jsonschemainferrer.ArrayLengthFeature;
import com.saasquatch.jsonschemainferrer.DefaultPolicies;
import com.saasquatch.jsonschemainferrer.DefaultPolicy;
import com.saasquatch.jsonschemainferrer.EnumExtractor;
import com.saasquatch.jsonschemainferrer.EnumExtractors;
import com.saasquatch.jsonschemainferrer.ExamplesPolicies;
import com.saasquatch.jsonschemainferrer.ExamplesPolicy;
import com.saasquatch.jsonschemainferrer.FormatInferrer;
import com.saasquatch.jsonschemainferrer.FormatInferrers;
import com.saasquatch.jsonschemainferrer.GenericSchemaFeature;
import com.saasquatch.jsonschemainferrer.GenericSchemaFeatures;
import com.saasquatch.jsonschemainferrer.IntegerTypeCriteria;
import com.saasquatch.jsonschemainferrer.IntegerTypeCriterion;
import com.saasquatch.jsonschemainferrer.IntegerTypePreference;
import com.saasquatch.jsonschemainferrer.JsonSchemaInferrer;
import com.saasquatch.jsonschemainferrer.MultipleOfPolicies;
import com.saasquatch.jsonschemainferrer.MultipleOfPolicy;
import com.saasquatch.jsonschemainferrer.NumberRangeFeature;
import com.saasquatch.jsonschemainferrer.ObjectSizeFeature;
import com.saasquatch.jsonschemainferrer.RequiredPolicies;
import com.saasquatch.jsonschemainferrer.RequiredPolicy;
import com.saasquatch.jsonschemainferrer.SpecVersion;
import com.saasquatch.jsonschemainferrer.StringLengthFeature;
import com.saasquatch.jsonschemainferrer.TitleDescriptionGenerator;
import com.saasquatch.jsonschemainferrer.TitleDescriptionGenerators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class JsonSchemaInferrerBuilder {
    private SpecVersion specVersion = SpecVersion.DRAFT_04;
    private IntegerTypePreference integerTypePreference = IntegerTypePreference.IF_ALL;
    private IntegerTypeCriterion integerTypeCriterion = IntegerTypeCriteria.nonFloatingPoint();
    private List<EnumExtractor> enumExtractors = Collections.emptyList();
    private TitleDescriptionGenerator titleDescriptionGenerator = TitleDescriptionGenerators.noOp();
    private List<FormatInferrer> formatInferrers = Collections.emptyList();
    private AdditionalPropertiesPolicy additionalPropertiesPolicy = AdditionalPropertiesPolicies.noOp();
    private RequiredPolicy requiredPolicy = RequiredPolicies.noOp();
    private DefaultPolicy defaultPolicy = DefaultPolicies.noOp();
    private ExamplesPolicy examplesPolicy = ExamplesPolicies.noOp();
    private MultipleOfPolicy multipleOfPolicy = MultipleOfPolicies.noOp();
    private Set<ObjectSizeFeature> objectSizeFeatures = Collections.emptySet();
    private Set<ArrayLengthFeature> arrayLengthFeatures = Collections.emptySet();
    private Set<StringLengthFeature> stringLengthFeatures = Collections.emptySet();
    private Set<NumberRangeFeature> numberRangeFeatures = Collections.emptySet();
    private List<GenericSchemaFeature> genericSchemaFeatures = Collections.emptyList();

    JsonSchemaInferrerBuilder() {
    }

    public JsonSchemaInferrerBuilder setSpecVersion(@Nonnull SpecVersion specVersion) {
        this.specVersion = Objects.requireNonNull(specVersion);
        return this;
    }

    public JsonSchemaInferrerBuilder setIntegerTypePreference(@Nonnull IntegerTypePreference integerTypePreference) {
        this.integerTypePreference = Objects.requireNonNull(integerTypePreference);
        return this;
    }

    public JsonSchemaInferrerBuilder setIntegerTypeCriterion(@Nonnull IntegerTypeCriterion integerTypeCriterion) {
        this.integerTypeCriterion = Objects.requireNonNull(integerTypeCriterion);
        return this;
    }

    public JsonSchemaInferrerBuilder addEnumExtractors(EnumExtractor ... enumExtractors) {
        if (this.enumExtractors.isEmpty()) {
            this.enumExtractors = new ArrayList<EnumExtractor>();
        }
        for (EnumExtractor enumExtractor : enumExtractors) {
            this.enumExtractors.add(Objects.requireNonNull(enumExtractor));
        }
        return this;
    }

    public JsonSchemaInferrerBuilder setTitleDescriptionGenerator(@Nonnull TitleDescriptionGenerator titleDescriptionGenerator) {
        this.titleDescriptionGenerator = Objects.requireNonNull(titleDescriptionGenerator);
        return this;
    }

    public JsonSchemaInferrerBuilder addFormatInferrers(FormatInferrer ... formatInferrers) {
        if (this.formatInferrers.isEmpty()) {
            this.formatInferrers = new ArrayList<FormatInferrer>();
        }
        for (FormatInferrer formatInferrer : formatInferrers) {
            this.formatInferrers.add(Objects.requireNonNull(formatInferrer));
        }
        return this;
    }

    public JsonSchemaInferrerBuilder setAdditionalPropertiesPolicy(@Nonnull AdditionalPropertiesPolicy additionalPropertiesPolicy) {
        this.additionalPropertiesPolicy = Objects.requireNonNull(additionalPropertiesPolicy);
        return this;
    }

    public JsonSchemaInferrerBuilder setRequiredPolicy(@Nonnull RequiredPolicy requiredPolicy) {
        this.requiredPolicy = Objects.requireNonNull(requiredPolicy);
        return this;
    }

    public JsonSchemaInferrerBuilder setDefaultPolicy(@Nonnull DefaultPolicy defaultPolicy) {
        this.defaultPolicy = Objects.requireNonNull(defaultPolicy);
        return this;
    }

    public JsonSchemaInferrerBuilder setExamplesPolicy(@Nonnull ExamplesPolicy examplesPolicy) {
        this.examplesPolicy = Objects.requireNonNull(examplesPolicy);
        return this;
    }

    public JsonSchemaInferrerBuilder setMultipleOfPolicy(@Nonnull MultipleOfPolicy multipleOfPolicy) {
        this.multipleOfPolicy = Objects.requireNonNull(multipleOfPolicy);
        return this;
    }

    public JsonSchemaInferrerBuilder setObjectSizeFeatures(@Nonnull EnumSet<ObjectSizeFeature> objectSizeFeatures) {
        this.objectSizeFeatures = Objects.requireNonNull(objectSizeFeatures);
        return this;
    }

    public JsonSchemaInferrerBuilder setArrayLengthFeatures(@Nonnull EnumSet<ArrayLengthFeature> arrayLengthFeatures) {
        this.arrayLengthFeatures = Objects.requireNonNull(arrayLengthFeatures);
        return this;
    }

    public JsonSchemaInferrerBuilder setStringLengthFeatures(@Nonnull EnumSet<StringLengthFeature> stringLengthFeatures) {
        this.stringLengthFeatures = Objects.requireNonNull(stringLengthFeatures);
        return this;
    }

    public JsonSchemaInferrerBuilder setNumberRangeFeatures(@Nonnull EnumSet<NumberRangeFeature> numberRangeFeatures) {
        this.numberRangeFeatures = Objects.requireNonNull(numberRangeFeatures);
        return this;
    }

    public JsonSchemaInferrerBuilder addGenericSchemaFeatures(GenericSchemaFeature ... features) {
        if (this.genericSchemaFeatures.isEmpty()) {
            this.genericSchemaFeatures = new ArrayList<GenericSchemaFeature>();
        }
        for (GenericSchemaFeature feature : features) {
            this.genericSchemaFeatures.add(Objects.requireNonNull(feature));
        }
        return this;
    }

    @Nonnull
    private EnumExtractor getCombinedEnumExtractor() {
        return EnumExtractors.chained(this.enumExtractors.toArray(new EnumExtractor[0]));
    }

    @Nonnull
    private FormatInferrer getCombinedFormatInferrer() {
        return FormatInferrers.chained(this.formatInferrers.toArray(new FormatInferrer[0]));
    }

    @Nonnull
    private GenericSchemaFeature getCombinedGenericSchemaFeature() {
        ArrayList<GenericSchemaFeature> features = new ArrayList<GenericSchemaFeature>();
        if (this.additionalPropertiesPolicy != AdditionalPropertiesPolicies.noOp()) {
            features.add(this.additionalPropertiesPolicy);
        }
        if (this.requiredPolicy != RequiredPolicies.noOp()) {
            features.add(this.requiredPolicy);
        }
        if (this.defaultPolicy != DefaultPolicies.noOp()) {
            features.add(this.defaultPolicy);
        }
        if (this.examplesPolicy != ExamplesPolicies.noOp()) {
            features.add(this.examplesPolicy);
        }
        if (this.multipleOfPolicy != MultipleOfPolicies.noOp()) {
            features.add(this.multipleOfPolicy);
        }
        features.addAll(this.objectSizeFeatures);
        features.addAll(this.arrayLengthFeatures);
        features.addAll(this.stringLengthFeatures);
        features.addAll(this.numberRangeFeatures);
        features.addAll(this.genericSchemaFeatures);
        return GenericSchemaFeatures.chained(features.toArray(new GenericSchemaFeature[0]));
    }

    public JsonSchemaInferrer build() {
        return new JsonSchemaInferrer(this.specVersion, this.integerTypePreference, this.integerTypeCriterion, this.getCombinedEnumExtractor(), this.titleDescriptionGenerator, this.getCombinedFormatInferrer(), this.getCombinedGenericSchemaFeature());
    }
}

