/*
 * Decompiled with CFR 0.152.
 */
package com.saasquatch.jsonschemainferrer;

import com.saasquatch.jsonschemainferrer.EnumExtractor;
import com.saasquatch.jsonschemainferrer.JunkDrawer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class EnumExtractors {
    private EnumExtractors() {
    }

    public static EnumExtractor noOp() {
        return input -> Collections.emptySet();
    }

    public static <E extends Enum<E>> EnumExtractor validEnum(@Nonnull Class<E> enumClass) {
        Objects.requireNonNull(enumClass);
        return input -> {
            Set enumNodes = input.getSamples().stream().filter(j -> JunkDrawer.isValidEnum(enumClass, j.textValue())).collect(Collectors.toSet());
            return enumNodes.isEmpty() ? Collections.emptySet() : Collections.singleton(enumNodes);
        };
    }

    public static EnumExtractor chained(EnumExtractor ... enumExtractors) {
        for (EnumExtractor enumExtractor : enumExtractors) {
            Objects.requireNonNull(enumExtractor);
        }
        switch (enumExtractors.length) {
            case 0: {
                return EnumExtractors.noOp();
            }
            case 1: {
                return enumExtractors[0];
            }
        }
        return input -> Arrays.stream(enumExtractors).flatMap(enumExtrator -> enumExtrator.extractEnums(input).stream()).collect(Collectors.toSet());
    }
}

