/*
 * Decompiled with CFR 0.152.
 */
package com.github.jrubygradle.internal.core;

import com.github.jrubygradle.api.core.ApiException;
import com.github.jrubygradle.api.core.GemRepositoryConfiguration;
import com.github.jrubygradle.api.core.IvyXmlProxyServer;
import com.github.jrubygradle.api.core.RubyGemQueryRestApi;
import com.github.jrubygradle.api.gems.GemInfo;
import com.github.jrubygradle.api.gems.GemVersion;
import com.github.jrubygradle.internal.core.DefaultRubyGemRestApi;
import com.github.jrubygradle.internal.core.IvyUtils;
import com.github.jrubygradle.internal.gems.GemToIvy;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import java.io.Writer;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.NioGroovyMethods;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberMultiply;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ysb33r.grolifant.api.ExclusiveFileAccess;

public abstract class AbstractIvyXmlProxyServer
implements IvyXmlProxyServer,
GroovyObject {
    private static final long EXPIRY_PERIOD_MILLIS;
    private volatile int refreshDependencies;
    private final File localCachePath;
    private final GemToIvy gemToIvy;
    private final RubyGemQueryRestApi api;
    private final String group;
    private final GemRepositoryConfiguration configuration;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private final Object $lock;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    protected AbstractIvyXmlProxyServer(File cache, URI serverUri, String group, GemRepositoryConfiguration grc) {
        GemRepositoryConfiguration gemRepositoryConfiguration;
        String string;
        GemToIvy gemToIvy;
        File file;
        Object[] objectArray;
        MetaClass metaClass;
        int n;
        this.refreshDependencies = n = 0;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.$lock = objectArray = new Object[Integer.valueOf(0).intValue()];
        this.localCachePath = file = cache;
        this.gemToIvy = gemToIvy = new GemToIvy(serverUri);
        DefaultRubyGemRestApi defaultRubyGemRestApi = new DefaultRubyGemRestApi(serverUri);
        this.api = defaultRubyGemRestApi;
        this.group = string = group;
        this.configuration = gemRepositoryConfiguration = grc;
    }

    @Override
    public void setRefreshDependencies(boolean refresh) {
        int n;
        this.refreshDependencies = n = refresh ? 1 : 0;
    }

    @Override
    public URI getBindAddress() {
        return ResourceGroovyMethods.toURI((CharSequence)new GStringImpl(new Object[]{this.getBindPort()}, new String[]{"http://localhost:", ""}));
    }

    @Override
    public Path ivyFile(String group, String name, String revision) {
        return new File(this.localCachePath, ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name, revision}, new String[]{"", "/", "/ivy.xml"}))).toPath();
    }

    /*
     * WARNING - void declaration
     */
    protected void createIvyXml(Path ivyXml, String name, String revision) {
        void var3_3;
        void var2_2;
        Reference ivyXml2 = new Reference((Object)ivyXml);
        Reference name2 = new Reference((Object)var2_2);
        Reference revision2 = new Reference((Object)var3_3);
        Object object = this.$lock;
        synchronized (object) {
            ExclusiveFileAccess efa = new ExclusiveFileAccess(120000, 20);
            public final class _createIvyXml_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference name;
                private /* synthetic */ Reference revision;
                private /* synthetic */ Reference ivyXml;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _createIvyXml_closure1(Object _outerInstance, Object _thisObject, Reference name, Reference revision, Reference ivyXml) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    this.name = reference3 = name;
                    this.revision = reference2 = revision;
                    this.ivyXml = reference = ivyXml;
                }

                public Object doCall(Object it) {
                    Reference gemInfo = new Reference((Object)((AbstractIvyXmlProxyServer)this.getThisObject()).api.metadata(ShortTypeHandling.castToString((Object)this.name.get()), ShortTypeHandling.castToString((Object)this.revision.get())));
                    ((Path)this.ivyXml.get()).getParent().toFile().mkdirs();
                    Path tmp = ((Path)this.ivyXml.get()).resolveSibling(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{((Path)this.ivyXml.get()).toFile().getName()}, new String[]{"", ".tmp"})));
                    public final class _closure2
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference gemInfo;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure2(Object _outerInstance, Object _thisObject, Reference gemInfo) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.gemInfo = reference = gemInfo;
                        }

                        public Object doCall(Object writer) {
                            return ((AbstractIvyXmlProxyServer)this.getThisObject()).gemToIvy.writeTo((Writer)ScriptBytecodeAdapter.castToType((Object)writer, Writer.class), (GemInfo)ScriptBytecodeAdapter.castToType((Object)this.gemInfo.get(), GemInfo.class));
                        }

                        public GemInfo getGemInfo() {
                            return (GemInfo)ScriptBytecodeAdapter.castToType((Object)this.gemInfo.get(), GemInfo.class);
                        }

                        public Object call(Object args) {
                            return this.doCall(args);
                        }

                        public Object call() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure2.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    NioGroovyMethods.withWriter((Path)tmp, (Closure)new _closure2((Object)this, this.getThisObject(), gemInfo));
                    Files.move(tmp, (Path)ScriptBytecodeAdapter.castToType((Object)this.ivyXml.get(), Path.class), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                    return ((AbstractIvyXmlProxyServer)this.getThisObject()).gemToIvy.writeSha1(((Path)this.ivyXml.get()).toFile());
                }

                public String getName() {
                    return ShortTypeHandling.castToString((Object)this.name.get());
                }

                public String getRevision() {
                    return ShortTypeHandling.castToString((Object)this.revision.get());
                }

                public Path getIvyXml() {
                    return (Path)ScriptBytecodeAdapter.castToType((Object)this.ivyXml.get(), Path.class);
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _createIvyXml_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            efa.access(((Path)ivyXml2.get()).toFile(), (Closure)new _createIvyXml_closure1(this, this, name2, revision2, ivyXml2));
        }
    }

    protected File getLocalCachePath() {
        return this.localCachePath;
    }

    protected String getGroup() {
        return this.group;
    }

    private boolean inGroups(String grp) {
        return ScriptBytecodeAdapter.compareEqual((Object)grp, (Object)this.group);
    }

    protected boolean expired(Path ivyXml) {
        System.currentTimeMillis();
        Path ivyXmlSha1 = ivyXml.resolveSibling(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{ivyXml.toFile().getName()}, new String[]{"", ".sha1"})));
        return Files.notExists(ivyXml, new LinkOption[0]) || Files.notExists(ivyXmlSha1, new LinkOption[0]) || Files.getLastModifiedTime(ivyXml, new LinkOption[0]).toMillis() + EXPIRY_PERIOD_MILLIS < Instant.now().toEpochMilli();
    }

    protected Path getIvyXml(String grp, String name, String version) throws NotFound {
        if (this.inGroups(grp)) {
            String revision = this.getGemQueryRevisionFromIvy(name, version);
            Path ivyXml = this.ivyFile(grp, name, revision);
            this.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.group, name, version, revision}, new String[]{"Requested ", ":", ":", " translated to GEM with version ", ""})));
            if (DefaultTypeTransformation.booleanUnbox((Object)this.refreshDependencies) || this.expired(ivyXml)) {
                try {
                    this.createIvyXml(ivyXml, name, revision);
                }
                catch (ApiException e) {
                    this.debug(e.getMessage(), e);
                    throw (Throwable)new NotFound();
                }
            }
            this.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{ivyXml.toAbsolutePath()}, new String[]{"Cached file is ", ""})));
            this.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{NioGroovyMethods.getText((Path)ivyXml)}, new String[]{"Cached file contains ", ""})));
            return ivyXml;
        }
        throw (Throwable)new NotFound();
    }

    protected Path getIvyXmlSha1(String grp, String name, String version) throws NotFound {
        if (this.inGroups(grp)) {
            Path ivyXml = this.getIvyXml(grp, name, version);
            return ivyXml.resolveSibling(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{ivyXml.toFile().getName()}, new String[]{"", ".sha1"})));
        }
        throw (Throwable)new NotFound();
    }

    protected String getDirectoryListing(String grp, String name) throws NotFound {
        if (this.inGroups(grp)) {
            this.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{grp, name}, new String[]{"Request to find all versions for ", ":", ""})));
            List<String> versions = this.api.allVersions(name, this.configuration.getPrerelease());
            this.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{DefaultGroovyMethods.join(versions, (String)", ")}, new String[]{"Got versions ", ""})));
            return IvyUtils.revisionsAsHtmlDirectoryListing(versions);
        }
        throw (Throwable)new NotFound();
    }

    protected abstract int getBindPort();

    private String getGemQueryRevisionFromIvy(String gemName, String revisionPattern) {
        GemVersion version = GemVersion.gemVersionFromGradleIvyRequirement(revisionPattern);
        return version.isHighOpenEnded() ? this.api.latestVersion(gemName, this.configuration.getPrerelease()) : version.getHigh();
    }

    private void debug(String text) {
        log.debug(text);
    }

    private void debug(String text, Object context) {
        log.debug(text, context);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AbstractIvyXmlProxyServer.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AbstractIvyXmlProxyServer.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, AbstractIvyXmlProxyServer.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(AbstractIvyXmlProxyServer.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    @Internal
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        int n = DefaultTypeTransformation.intUnbox((Object)NumberNumberMultiply.multiply((Number)StringGroovyMethods.toInteger((CharSequence)System.getProperty("com.github.jrubygradle.cache-expiry-days", "15")), (Number)24)) * 3600 * 1000;
        EXPIRY_PERIOD_MILLIS = n;
        log = logger = LoggerFactory.getLogger((String)"com.github.jrubygradle.internal.core.AbstractIvyXmlProxyServer");
    }

    public static class NotFound
    extends Exception
    implements GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public NotFound() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Generated
        public NotFound(String param0) {
            super(param0);
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Generated
        public NotFound(String param0, Throwable param1) {
            super(param0, param1);
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Generated
        public NotFound(Throwable param0) {
            super(param0);
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Generated
        protected NotFound(String param0, Throwable param1, boolean param2, boolean param3) {
            super(param0, param1, param2, param3);
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != NotFound.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(NotFound.class, AbstractIvyXmlProxyServer.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(NotFound.class, AbstractIvyXmlProxyServer.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AbstractIvyXmlProxyServer.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AbstractIvyXmlProxyServer.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(NotFound.class, AbstractIvyXmlProxyServer.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(NotFound.class, AbstractIvyXmlProxyServer.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }
}

