/*
 * Decompiled with CFR 0.152.
 */
package com.github.jrubygradle.api.gems;

import com.github.jrubygradle.api.gems.GemInstallException;
import com.github.jrubygradle.api.gems.GemOverwriteAction;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DuplicateFileCopyingException;
import org.gradle.api.file.FileCollection;
import org.gradle.process.JavaExecSpec;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.ProcessForkOptions;
import org.ysb33r.grolifant.api.OperatingSystem;

public class GemUtils
implements GroovyObject {
    public static final String JRUBY_MAINCLASS = "org.jruby.Main";
    public static final String JRUBY_ARCHIVE_NAME = "jruby-complete";
    private static final String GEM = "gem";
    private static final String GEM_EXTENSION = ".gem";
    private static final String EVERYTHING = "**";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public GemUtils() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static FileCollection getGems(FileCollection fc) {
        public final class _getGems_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getGems_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(File f) {
                return f.getName().toLowerCase().endsWith(GEM_EXTENSION);
            }

            public Object call(File f) {
                return this.doCall(f);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getGems_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return fc.filter((Closure)new _getGems_closure1(GemUtils.class, GemUtils.class));
    }

    public static void extractGem(Project project, File jRubyClasspath, File gem, File destDir, GemOverwriteAction overwrite) {
        GemUtils.extractGems(project, jRubyClasspath, (FileCollection)project.files(new Object[]{gem}), destDir, overwrite);
    }

    /*
     * WARNING - void declaration
     */
    public static void extractGems(Project project, File jRubyClasspath, FileCollection gems, File destDir, GemOverwriteAction overwrite) {
        void var3_3;
        void var1_1;
        Reference project2 = new Reference((Object)project);
        Reference jRubyClasspath2 = new Reference((Object)var1_1);
        Reference destDir2 = new Reference((Object)var3_3);
        Reference overwrite2 = new Reference((Object)overwrite);
        Reference gemsToProcess = new Reference((Object)((Set)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class)));
        Reference deletes = new Reference((Object)((Set)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class)));
        public final class _extractGems_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference destDir;
            private /* synthetic */ Reference overwrite;
            private /* synthetic */ Reference deletes;
            private /* synthetic */ Reference gemsToProcess;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _extractGems_closure2(Object _outerInstance, Object _thisObject, Reference destDir, Reference overwrite, Reference deletes, Reference gemsToProcess) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                this.destDir = reference4 = destDir;
                this.overwrite = reference3 = overwrite;
                this.deletes = reference2 = deletes;
                this.gemsToProcess = reference = gemsToProcess;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Object doCall(File gem) {
                String gemName = GemUtils.gemFullNameFromFile(gem.getName());
                File extractDir = new File((File)ScriptBytecodeAdapter.castToType((Object)this.destDir.get(), File.class), ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{gemName}, new String[]{"gems/", ""})));
                File extractDirForJava = new File((File)ScriptBytecodeAdapter.castToType((Object)this.destDir.get(), File.class), ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{gemName}, new String[]{"gems/", "-java"})));
                Object object = this.overwrite.get();
                if (ScriptBytecodeAdapter.isCase((Object)object, (Object)((Object)GemOverwriteAction.SKIP))) {
                    if (extractDir.exists()) return null;
                    if (extractDirForJava.exists()) {
                        return null;
                    }
                    boolean bl = false;
                    if (bl) {
                        return null;
                    }
                } else if (ScriptBytecodeAdapter.isCase((Object)object, (Object)((Object)GemOverwriteAction.OVERWRITE))) {
                } else {
                    if (!ScriptBytecodeAdapter.isCase((Object)object, (Object)((Object)GemOverwriteAction.FAIL))) return ((Set)this.gemsToProcess.get()).add(gem);
                    if (!(extractDir.exists() || extractDirForJava.exists())) return ((Set)this.gemsToProcess.get()).add(gem);
                    throw (Throwable)new DuplicateFileCopyingException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{gem.getName()}, new String[]{"Gem ", " already exists"})));
                }
                ((Set)this.deletes.get()).add(extractDir);
                ((Set)this.deletes.get()).add(extractDirForJava);
                return ((Set)this.gemsToProcess.get()).add(gem);
            }

            public Object call(File gem) {
                return this.doCall(gem);
            }

            public File getDestDir() {
                return (File)ScriptBytecodeAdapter.castToType((Object)this.destDir.get(), File.class);
            }

            public GemOverwriteAction getOverwrite() {
                return (GemOverwriteAction)ShortTypeHandling.castToEnum((Object)this.overwrite.get(), GemOverwriteAction.class);
            }

            public Set getDeletes() {
                return (Set)ScriptBytecodeAdapter.castToType((Object)this.deletes.get(), Set.class);
            }

            public Set getGemsToProcess() {
                return (Set)ScriptBytecodeAdapter.castToType((Object)this.gemsToProcess.get(), Set.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _extractGems_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((Set)GemUtils.getGems(gems).getFiles(), (Closure)new _extractGems_closure2(GemUtils.class, GemUtils.class, destDir2, overwrite2, deletes, gemsToProcess));
        if (((Set)gemsToProcess.get()).size() != 0) {
            public final class _extractGems_closure3
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference project;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _extractGems_closure3(Object _outerInstance, Object _thisObject, Reference project) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.project = reference = project;
                }

                public Object doCall(Object it) {
                    return ((Project)this.project.get()).delete(new Object[]{it});
                }

                public Project getProject() {
                    return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _extractGems_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each((Set)((Set)deletes.get()), (Closure)new _extractGems_closure3(GemUtils.class, GemUtils.class, project2));
            ((File)destDir2.get()).mkdirs();
            ((Project)project2.get()).getLogger().info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{DefaultGroovyMethods.join((Iterable)((Iterable)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.getPropertySpreadSafe(GemUtils.class, (Object)((Set)gemsToProcess.get()), (String)"name"), Iterable.class)), (String)",")}, new String[]{"Installing ", ""})));
            public final class _extractGems_closure4
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference destDir;
                private /* synthetic */ Reference jRubyClasspath;
                private /* synthetic */ Reference gemsToProcess;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _extractGems_closure4(Object _outerInstance, Object _thisObject, Reference destDir, Reference jRubyClasspath, Reference gemsToProcess) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    this.destDir = reference3 = destDir;
                    this.jRubyClasspath = reference2 = jRubyClasspath;
                    this.gemsToProcess = reference = gemsToProcess;
                }

                public Object doCall(JavaExecSpec spec) {
                    public final class _closure10
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference destDir;
                        private /* synthetic */ Reference jRubyClasspath;
                        private /* synthetic */ Reference gemsToProcess;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure10(Object _outerInstance, Object _thisObject, Reference destDir, Reference jRubyClasspath, Reference gemsToProcess) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            Reference reference2;
                            Reference reference3;
                            this.destDir = reference3 = destDir;
                            this.jRubyClasspath = reference2 = jRubyClasspath;
                            this.gemsToProcess = reference = gemsToProcess;
                        }

                        public Object doCall(Object it) {
                            ((ProcessForkOptions)this.getDelegate()).environment(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"JBUNDLE_SKIP", true, "JARS_SKIP", true, "GEM_HOME", ((File)this.destDir.get()).getAbsolutePath(), "GEM_PATH", ((File)this.destDir.get()).getAbsolutePath()}));
                            Object object = this.getProperty("JRUBY_MAINCLASS");
                            ((JavaExecSpec)this.getDelegate()).setMain(ShortTypeHandling.castToString((Object)object));
                            ((JavaExecSpec)this.getDelegate()).classpath(new Object[]{this.jRubyClasspath.get()});
                            ((JavaExecSpec)this.getDelegate()).args(new Object[]{"-S", GEM, "install"});
                            public final class _closure11
                            extends Closure
                            implements GeneratedClosure {
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;

                                public _closure11(Object _outerInstance, Object _thisObject) {
                                    super(_outerInstance, _thisObject);
                                }

                                public Object doCall(File gem) {
                                    return ((JavaExecSpec)((Closure)this.getDelegate()).getDelegate()).args(new Object[]{gem});
                                }

                                public Object call(File gem) {
                                    return this.doCall(gem);
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _closure11.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }
                            }
                            DefaultGroovyMethods.each((List)DefaultGroovyMethods.reverse((List)DefaultGroovyMethods.toList((Iterable)((Iterable)ScriptBytecodeAdapter.castToType((Object)this.gemsToProcess.get(), Iterable.class)))), (Closure)new _closure11((Object)this, this.getThisObject()));
                            ((JavaExecSpec)this.getDelegate()).args(new Object[]{"--ignore-dependencies", new GStringImpl(new Object[]{((File)this.destDir.get()).getAbsolutePath()}, new String[]{"--install-dir=", ""}), "--no-user-install", "--wrappers", "--no-document", "--local"});
                            if (OperatingSystem.current().isWindows()) {
                                ((ProcessForkOptions)this.getDelegate()).environment(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"TMP", System.getenv("TMP"), "TEMP", System.getenv("TEMP")}));
                            }
                            return ((JavaForkOptions)this.getDelegate()).systemProperties(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"file.encoding", "utf-8"}));
                        }

                        public File getDestDir() {
                            return (File)ScriptBytecodeAdapter.castToType((Object)this.destDir.get(), File.class);
                        }

                        public File getjRubyClasspath() {
                            return (File)ScriptBytecodeAdapter.castToType((Object)this.jRubyClasspath.get(), File.class);
                        }

                        public Set getGemsToProcess() {
                            return (Set)ScriptBytecodeAdapter.castToType((Object)this.gemsToProcess.get(), Set.class);
                        }

                        public Object call(Object args) {
                            return this.doCall(args);
                        }

                        public Object call() {
                            return this.doCall(null);
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure10.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    return DefaultGroovyMethods.with((Object)spec, (Closure)new _closure10((Object)this, this.getThisObject(), this.destDir, this.jRubyClasspath, this.gemsToProcess));
                }

                public Object call(JavaExecSpec spec) {
                    return this.doCall(spec);
                }

                public File getDestDir() {
                    return (File)ScriptBytecodeAdapter.castToType((Object)this.destDir.get(), File.class);
                }

                public File getjRubyClasspath() {
                    return (File)ScriptBytecodeAdapter.castToType((Object)this.jRubyClasspath.get(), File.class);
                }

                public Set getGemsToProcess() {
                    return (Set)ScriptBytecodeAdapter.castToType((Object)this.gemsToProcess.get(), Set.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _extractGems_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            ((Project)project2.get()).javaexec((Closure)new _extractGems_closure4(GemUtils.class, GemUtils.class, destDir2, jRubyClasspath2, gemsToProcess));
        }
    }

    public static void extractGems(Project project, Configuration jRubyConfig, Configuration gemConfig, File destDir, GemOverwriteAction action) {
        Set cp = jRubyConfig.getFiles();
        public final class _extractGems_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _extractGems_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ((File)it).getName().startsWith(JRUBY_ARCHIVE_NAME);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _extractGems_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        File jRubyClasspath = (File)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.find((Collection)cp, (Closure)new _extractGems_closure5(GemUtils.class, GemUtils.class)), File.class);
        if (jRubyClasspath == null) {
            throw (Throwable)new GemInstallException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{JRUBY_ARCHIVE_NAME, DefaultGroovyMethods.join((Iterable)cp, (String)":")}, new String[]{"Cannot find ", ". Classpath contains ", ""})));
        }
        GemUtils.extractGems(project, jRubyClasspath, (FileCollection)project.files(new Object[]{gemConfig.getFiles()}), destDir, action);
    }

    public static void writeJarsLock(File jarsLock, List<String> coordinates) {
        String content = null;
        if (jarsLock.exists()) {
            String string;
            content = string = ResourceGroovyMethods.getText((File)jarsLock);
        } else {
            String string;
            jarsLock.getParentFile().mkdirs();
            content = string = "";
        }
        Reference newContent = new Reference((Object)new StringWriter());
        public final class _writeJarsLock_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference newContent;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _writeJarsLock_closure6(Object _outerInstance, Object _thisObject, Reference newContent) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.newContent = reference = newContent;
            }

            public Object doCall(Object it) {
                DefaultGroovyMethods.println((Object)this.newContent.get(), (Object)it);
                return null;
            }

            public StringWriter getNewContent() {
                return (StringWriter)ScriptBytecodeAdapter.castToType((Object)this.newContent.get(), StringWriter.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _writeJarsLock_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(coordinates, (Closure)new _writeJarsLock_closure6(GemUtils.class, GemUtils.class, newContent));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)content, (Object)((StringWriter)newContent.get()).toString())) {
            StringWriter stringWriter = (StringWriter)newContent.get();
            ScriptBytecodeAdapter.setProperty((Object)ShortTypeHandling.castToString((Object)stringWriter), null, (Object)jarsLock, (String)"text");
        }
        ((StringWriter)newContent.get()).close();
    }

    /*
     * WARNING - void declaration
     */
    public static void rewriteJarDependencies(File jarsDir, List<File> dependencies, Map<String, String> renameMap, GemOverwriteAction overwrite) {
        void var3_3;
        void var2_2;
        Reference jarsDir2 = new Reference((Object)jarsDir);
        Reference renameMap2 = new Reference((Object)var2_2);
        Reference overwrite2 = new Reference((Object)var3_3);
        public final class _rewriteJarDependencies_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference jarsDir;
            private /* synthetic */ Reference renameMap;
            private /* synthetic */ Reference overwrite;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _rewriteJarDependencies_closure7(Object _outerInstance, Object _thisObject, Reference jarsDir, Reference renameMap, Reference overwrite) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.jarsDir = reference3 = jarsDir;
                this.renameMap = reference2 = renameMap;
                this.overwrite = reference = overwrite;
            }

            public Object doCall(File dependency) {
                block5: {
                    block10: {
                        Reference destination;
                        block9: {
                            Object object;
                            block8: {
                                block7: {
                                    block6: {
                                        if (!(dependency.getName().toLowerCase().endsWith(".jar") && !dependency.getName().startsWith(JRUBY_ARCHIVE_NAME))) break block5;
                                        destination = new Reference((Object)new File((File)ScriptBytecodeAdapter.castToType((Object)this.jarsDir.get(), File.class), ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt((Map)((Map)ScriptBytecodeAdapter.castToType((Object)this.renameMap.get(), Map.class)), (Object)dependency.getName()))));
                                        object = this.overwrite.get();
                                        if (!ScriptBytecodeAdapter.isCase((Object)object, (Object)((Object)GemOverwriteAction.FAIL))) break block6;
                                        if (((File)destination.get()).exists()) {
                                            throw (Throwable)new DuplicateFileCopyingException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{((File)destination.get()).getName()}, new String[]{"Jar ", " already exists"})));
                                        }
                                        break block7;
                                    }
                                    if (!ScriptBytecodeAdapter.isCase((Object)object, (Object)((Object)GemOverwriteAction.SKIP))) break block8;
                                }
                                if (!((File)destination.get()).exists()) break block9;
                                break block10;
                            }
                            if (!ScriptBytecodeAdapter.isCase((Object)object, (Object)((Object)GemOverwriteAction.OVERWRITE))) break block10;
                        }
                        ((File)destination.get()).delete();
                        ((File)destination.get()).getParentFile().mkdirs();
                        public final class _closure12
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference destination;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure12(Object _outerInstance, Object _thisObject, Reference destination) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                this.destination = reference = destination;
                            }

                            public Object doCall(Object it) {
                                return ResourceGroovyMethods.leftShift((File)((File)ScriptBytecodeAdapter.castToType((Object)this.destination.get(), File.class)), (InputStream)((InputStream)ScriptBytecodeAdapter.castToType((Object)it, InputStream.class)));
                            }

                            public File getDestination() {
                                return (File)ScriptBytecodeAdapter.castToType((Object)this.destination.get(), File.class);
                            }

                            public Object call(Object args) {
                                return this.doCall(args);
                            }

                            public Object call() {
                                return this.doCall(null);
                            }

                            @Generated
                            public Object doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure12.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        ResourceGroovyMethods.withInputStream((File)dependency, (Closure)new _closure12((Object)this, this.getThisObject(), destination));
                    }
                    return null;
                }
                return null;
            }

            public Object call(File dependency) {
                return this.doCall(dependency);
            }

            public File getJarsDir() {
                return (File)ScriptBytecodeAdapter.castToType((Object)this.jarsDir.get(), File.class);
            }

            public Map getRenameMap() {
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.renameMap.get(), Map.class);
            }

            public GemOverwriteAction getOverwrite() {
                return (GemOverwriteAction)ShortTypeHandling.castToEnum((Object)this.overwrite.get(), GemOverwriteAction.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _rewriteJarDependencies_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(dependencies, (Closure)new _rewriteJarDependencies_closure7(GemUtils.class, GemUtils.class, jarsDir2, renameMap2, overwrite2));
    }

    public static void setupJars(Configuration config, File destDir, GemOverwriteAction overwrite) {
        Set artifacts = config.getResolvedConfiguration().getResolvedArtifacts();
        Reference fileRenameMap = new Reference((Object)((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class)));
        Reference coordinates = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        Reference files = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        public final class _setupJars_closure8
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference coordinates;
            private /* synthetic */ Reference fileRenameMap;
            private /* synthetic */ Reference files;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _setupJars_closure8(Object _outerInstance, Object _thisObject, Reference coordinates, Reference fileRenameMap, Reference files) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.coordinates = reference3 = coordinates;
                this.fileRenameMap = reference2 = fileRenameMap;
                this.files = reference = files;
            }

            public Object doCall(ResolvedArtifact dependency) {
                String group = dependency.getModuleVersion().getId().getGroup();
                String groupAsPath = group.replace(DefaultTypeTransformation.charUnbox((Object)ScriptBytecodeAdapter.asType((Object)".", Character.TYPE)), File.separatorChar);
                String version = dependency.getModuleVersion().getId().getVersion();
                String newFileName = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{groupAsPath, dependency.getName(), version, dependency.getName(), version, dependency.getType()}, new String[]{"", "/", "/", "/", "-", ".", ""}));
                if (ScriptBytecodeAdapter.compareNotEqual((Object)dependency.getType(), (Object)GEM) && ScriptBytecodeAdapter.compareNotEqual((Object)dependency.getName(), (Object)JRUBY_ARCHIVE_NAME)) {
                    ((List)this.coordinates.get()).add(new GStringImpl(new Object[]{group, dependency.getName(), version}, new String[]{"", ":", ":", ":runtime:"}).toString());
                }
                String string = newFileName;
                DefaultGroovyMethods.putAt((Map)((Map)ScriptBytecodeAdapter.castToType((Object)this.fileRenameMap.get(), Map.class)), (Object)dependency.getFile().getName(), (Object)string);
                return DefaultGroovyMethods.leftShift((List)((List)ScriptBytecodeAdapter.castToType((Object)this.files.get(), List.class)), (Object)dependency.getFile());
            }

            public Object call(ResolvedArtifact dependency) {
                return this.doCall(dependency);
            }

            public List getCoordinates() {
                return (List)ScriptBytecodeAdapter.castToType((Object)this.coordinates.get(), List.class);
            }

            public Map getFileRenameMap() {
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.fileRenameMap.get(), Map.class);
            }

            public List getFiles() {
                return (List)ScriptBytecodeAdapter.castToType((Object)this.files.get(), List.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _setupJars_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((Set)artifacts, (Closure)new _setupJars_closure8(GemUtils.class, GemUtils.class, coordinates, fileRenameMap, files));
        GemUtils.writeJarsLock(new File(destDir, "Jars.lock"), (List)coordinates.get());
        GemUtils.rewriteJarDependencies(new File(destDir, "jars"), (List)files.get(), (LinkedHashMap)fileRenameMap.get(), overwrite);
    }

    public static String gemFullNameFromFile(String filename) {
        return StringGroovyMethods.replaceAll((CharSequence)filename, (Pattern)((Pattern)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.bitwiseNegate((Object)GEM_EXTENSION), Pattern.class)), (CharSequence)"");
    }

    public static CopySpec gemCopySpec(Map properties, Project project, Object dir) {
        Reference dir2 = new Reference(dir);
        CallSite[] callSiteArray = GemUtils.$getCallSiteArray();
        Reference fullGem = new Reference((Object)((Boolean)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call((Object)properties, (Object)"fullGem"), Boolean.class)));
        Reference subFolder = new Reference((Object)ShortTypeHandling.castToString((Object)callSiteArray[1].call((Object)properties, (Object)"subfolder")));
        return (CopySpec)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].call((Object)project, (Object)new Action<CopySpec>(GemUtils.class, dir2, fullGem, subFolder){
            public /* synthetic */ Reference subFolder;
            public /* synthetic */ Reference fullGem;
            public /* synthetic */ Reference dir;
            public /* synthetic */ Class this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                MetaClass metaClass;
                Reference reference;
                Reference reference2;
                Reference reference3;
                Class clazz;
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                this.this$0 = clazz = p0;
                this.subFolder = reference3 = p3;
                this.fullGem = reference2 = p2;
                this.dir = reference = p1;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public void execute(CopySpec spec) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                public final class _execute_closure1
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference dir;
                    private /* synthetic */ Reference fullGem;
                    private /* synthetic */ Reference subFolder;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _execute_closure1(Object _outerInstance, Object _thisObject, Reference dir, Reference fullGem, Reference subFolder) {
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        CallSite[] callSiteArray = _execute_closure1.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.dir = reference3 = dir;
                        this.fullGem = reference2 = fullGem;
                        this.subFolder = reference = subFolder;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _execute_closure1.$getCallSiteArray();
                        public final class _closure2
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference fullGem;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;

                            public _closure2(Object _outerInstance, Object _thisObject, Reference fullGem) {
                                Reference reference;
                                CallSite[] callSiteArray = _closure2.$getCallSiteArray();
                                super(_outerInstance, _thisObject);
                                this.fullGem = reference = fullGem;
                            }

                            public Object doCall(Object it) {
                                CallSite[] callSiteArray = _closure2.$getCallSiteArray();
                                callSiteArray[0].callCurrent((GroovyObject)this, callSiteArray[1].callGroovyObjectGetProperty((Object)this));
                                if (!DefaultTypeTransformation.booleanUnbox((Object)this.fullGem.get())) {
                                    callSiteArray[2].callCurrent((GroovyObject)this, (Object)"cache/**");
                                    callSiteArray[3].callCurrent((GroovyObject)this, (Object)"gems/*/test/**");
                                    callSiteArray[4].callCurrent((GroovyObject)this, (Object)"gems/*/tests/**");
                                    callSiteArray[5].callCurrent((GroovyObject)this, (Object)"gems/*/spec/**");
                                    callSiteArray[6].callCurrent((GroovyObject)this, (Object)"gems/*/specs/**");
                                    return callSiteArray[7].callCurrent((GroovyObject)this, (Object)"build_info");
                                }
                                return null;
                            }

                            public Boolean getFullGem() {
                                CallSite[] callSiteArray = _closure2.$getCallSiteArray();
                                return (Boolean)ScriptBytecodeAdapter.castToType((Object)this.fullGem.get(), Boolean.class);
                            }

                            @Generated
                            public Object doCall() {
                                CallSite[] callSiteArray = _closure2.$getCallSiteArray();
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure2.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                stringArray[0] = "include";
                                stringArray[1] = "EVERYTHING";
                                stringArray[2] = "exclude";
                                stringArray[3] = "exclude";
                                stringArray[4] = "exclude";
                                stringArray[5] = "exclude";
                                stringArray[6] = "exclude";
                                stringArray[7] = "exclude";
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[8];
                                _closure2.$createCallSiteArray_1(stringArray);
                                return new CallSiteArray(_closure2.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _closure2.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }
                        }
                        callSiteArray[0].callCurrent((GroovyObject)this, this.dir.get(), (Object)new _closure2((Object)this, this.getThisObject(), this.fullGem));
                        if (DefaultTypeTransformation.booleanUnbox((Object)this.subFolder.get())) {
                            return callSiteArray[1].callCurrent((GroovyObject)this, this.subFolder.get());
                        }
                        return null;
                    }

                    public Object getDir() {
                        CallSite[] callSiteArray = _execute_closure1.$getCallSiteArray();
                        return this.dir.get();
                    }

                    public Boolean getFullGem() {
                        CallSite[] callSiteArray = _execute_closure1.$getCallSiteArray();
                        return (Boolean)ScriptBytecodeAdapter.castToType((Object)this.fullGem.get(), Boolean.class);
                    }

                    public String getSubFolder() {
                        CallSite[] callSiteArray = _execute_closure1.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.subFolder.get());
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _execute_closure1.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _execute_closure1.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "from";
                        stringArray[1] = "into";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[2];
                        _execute_closure1.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_execute_closure1.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _execute_closure1.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[0].call((Object)spec, (Object)new _execute_closure1(this, this, this.dir, this.fullGem, this.subFolder));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN(1.class, GemUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN(1.class, GemUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, GemUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, GemUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.getProperty(1.class, GemUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.getProperty(1.class, GemUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            @Generated
            @Internal
            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            @Generated
            @Internal
            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "with";
                return new CallSiteArray(1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }), CopySpec.class);
    }

    public static CopySpec jarCopySpec(Project project, Object dir) {
        Reference dir2 = new Reference(dir);
        public final class _jarCopySpec_closure9
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference dir;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _jarCopySpec_closure9(Object _outerInstance, Object _thisObject, Reference dir) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.dir = reference = dir;
            }

            public Object doCall(CopySpec spec) {
                public final class _closure13
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference dir;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure13(Object _outerInstance, Object _thisObject, Reference dir) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.dir = reference = dir;
                    }

                    public Object doCall(Object it) {
                        public final class _closure14
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure14(Object _outerInstance, Object _thisObject) {
                                super(_outerInstance, _thisObject);
                            }

                            public Object doCall(Object it) {
                                return ((CopySpec)((Closure)this.getDelegate()).getDelegate()).include(new String[]{EVERYTHING});
                            }

                            public Object call(Object args) {
                                return this.doCall(args);
                            }

                            public Object call() {
                                return this.doCall(null);
                            }

                            @Generated
                            public Object doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure14.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        return ((CopySpec)this.getDelegate()).from(this.dir.get(), (Closure)new _closure14((Object)this, this.getThisObject()));
                    }

                    public Object getDir() {
                        return this.dir.get();
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure13.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                return DefaultGroovyMethods.with((Object)spec, (Closure)new _closure13((Object)this, this.getThisObject(), this.dir));
            }

            public Object call(CopySpec spec) {
                return this.doCall(spec);
            }

            public Object getDir() {
                return this.dir.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _jarCopySpec_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return project.copySpec((Closure)new _jarCopySpec_closure9(GemUtils.class, GemUtils.class, dir2));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GemUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(GemUtils.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, GemUtils.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(GemUtils.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    public static CopySpec gemCopySpec(Project project, Object dir) {
        Reference dir2 = new Reference(dir);
        return GemUtils.gemCopySpec(ScriptBytecodeAdapter.createMap((Object[])new Object[0]), project, dir2.get());
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "getAt";
        stringArray[1] = "getAt";
        stringArray[2] = "copySpec";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[3];
        GemUtils.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(GemUtils.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = GemUtils.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

