/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.apache.tools.ant.types.selectors;

import java.io.File;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import shadow.org.apache.tools.ant.BuildException;
import shadow.org.apache.tools.ant.Project;
import shadow.org.apache.tools.ant.types.DataType;
import shadow.org.apache.tools.ant.types.selectors.AndSelector;
import shadow.org.apache.tools.ant.types.selectors.BaseSelector;
import shadow.org.apache.tools.ant.types.selectors.ContainsRegexpSelector;
import shadow.org.apache.tools.ant.types.selectors.ContainsSelector;
import shadow.org.apache.tools.ant.types.selectors.DateSelector;
import shadow.org.apache.tools.ant.types.selectors.DependSelector;
import shadow.org.apache.tools.ant.types.selectors.DepthSelector;
import shadow.org.apache.tools.ant.types.selectors.DifferentSelector;
import shadow.org.apache.tools.ant.types.selectors.ExtendSelector;
import shadow.org.apache.tools.ant.types.selectors.FileSelector;
import shadow.org.apache.tools.ant.types.selectors.FilenameSelector;
import shadow.org.apache.tools.ant.types.selectors.MajoritySelector;
import shadow.org.apache.tools.ant.types.selectors.NoneSelector;
import shadow.org.apache.tools.ant.types.selectors.NotSelector;
import shadow.org.apache.tools.ant.types.selectors.OrSelector;
import shadow.org.apache.tools.ant.types.selectors.PresentSelector;
import shadow.org.apache.tools.ant.types.selectors.ReadableSelector;
import shadow.org.apache.tools.ant.types.selectors.SelectSelector;
import shadow.org.apache.tools.ant.types.selectors.SelectorContainer;
import shadow.org.apache.tools.ant.types.selectors.SizeSelector;
import shadow.org.apache.tools.ant.types.selectors.TypeSelector;
import shadow.org.apache.tools.ant.types.selectors.WritableSelector;
import shadow.org.apache.tools.ant.types.selectors.modifiedselector.ModifiedSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseSelectorContainer
extends BaseSelector
implements SelectorContainer {
    private Vector<FileSelector> selectorsList = new Vector();

    @Override
    public boolean hasSelectors() {
        this.dieOnCircularReference();
        return !this.selectorsList.isEmpty();
    }

    @Override
    public int selectorCount() {
        this.dieOnCircularReference();
        return this.selectorsList.size();
    }

    @Override
    public FileSelector[] getSelectors(Project p) {
        this.dieOnCircularReference();
        Object[] result = new FileSelector[this.selectorsList.size()];
        this.selectorsList.copyInto(result);
        return result;
    }

    @Override
    public Enumeration<FileSelector> selectorElements() {
        this.dieOnCircularReference();
        return this.selectorsList.elements();
    }

    @Override
    public String toString() {
        this.dieOnCircularReference();
        StringBuilder buf = new StringBuilder();
        Enumeration<FileSelector> e = this.selectorElements();
        while (e.hasMoreElements()) {
            buf.append(e.nextElement().toString());
            if (!e.hasMoreElements()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    @Override
    public void appendSelector(FileSelector selector) {
        this.selectorsList.addElement(selector);
        this.setChecked(false);
    }

    @Override
    public void validate() {
        this.verifySettings();
        this.dieOnCircularReference();
        String errmsg = this.getError();
        if (errmsg != null) {
            throw new BuildException(errmsg);
        }
        Enumeration<FileSelector> e = this.selectorElements();
        while (e.hasMoreElements()) {
            FileSelector o = e.nextElement();
            if (!(o instanceof BaseSelector)) continue;
            ((BaseSelector)o).validate();
        }
    }

    @Override
    public abstract boolean isSelected(File var1, String var2, File var3);

    @Override
    public void addSelector(SelectSelector selector) {
        this.appendSelector(selector);
    }

    @Override
    public void addAnd(AndSelector selector) {
        this.appendSelector(selector);
    }

    @Override
    public void addOr(OrSelector selector) {
        this.appendSelector(selector);
    }

    @Override
    public void addNot(NotSelector selector) {
        this.appendSelector(selector);
    }

    @Override
    public void addNone(NoneSelector selector) {
        this.appendSelector(selector);
    }

    @Override
    public void addMajority(MajoritySelector selector) {
        this.appendSelector(selector);
    }

    @Override
    public void addDate(DateSelector selector) {
        this.appendSelector(selector);
    }

    @Override
    public void addSize(SizeSelector selector) {
        this.appendSelector(selector);
    }

    @Override
    public void addFilename(FilenameSelector selector) {
        this.appendSelector(selector);
    }

    @Override
    public void addCustom(ExtendSelector selector) {
        this.appendSelector(selector);
    }

    @Override
    public void addContains(ContainsSelector selector) {
        this.appendSelector(selector);
    }

    @Override
    public void addPresent(PresentSelector selector) {
        this.appendSelector(selector);
    }

    @Override
    public void addDepth(DepthSelector selector) {
        this.appendSelector(selector);
    }

    @Override
    public void addDepend(DependSelector selector) {
        this.appendSelector(selector);
    }

    @Override
    public void addDifferent(DifferentSelector selector) {
        this.appendSelector(selector);
    }

    @Override
    public void addType(TypeSelector selector) {
        this.appendSelector(selector);
    }

    @Override
    public void addContainsRegexp(ContainsRegexpSelector selector) {
        this.appendSelector(selector);
    }

    @Override
    public void addModified(ModifiedSelector selector) {
        this.appendSelector(selector);
    }

    public void addReadable(ReadableSelector r) {
        this.appendSelector(r);
    }

    public void addWritable(WritableSelector w) {
        this.appendSelector(w);
    }

    @Override
    public void add(FileSelector selector) {
        this.appendSelector(selector);
    }

    @Override
    protected synchronized void dieOnCircularReference(Stack<Object> stk, Project p) throws BuildException {
        if (this.isChecked()) {
            return;
        }
        if (this.isReference()) {
            super.dieOnCircularReference(stk, p);
        } else {
            for (FileSelector fileSelector : this.selectorsList) {
                if (!(fileSelector instanceof DataType)) continue;
                BaseSelectorContainer.pushAndInvokeCircularReferenceCheck((DataType)((Object)fileSelector), stk, p);
            }
            this.setChecked(true);
        }
    }
}

