/*
 * Decompiled with CFR 0.152.
 */
package space.fei.code.onvif.util;

import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import space.fei.code.onvif.diagnostics.logging.Logger;
import space.fei.code.onvif.diagnostics.logging.Loggers;
import space.fei.code.onvif.util.OkHttpClientSingleton;

public class OkHttpUtils {
    private static final Logger LOGGER = Loggers.getLogger(OkHttpUtils.class);

    public String okHttp3XmlPost(String url, String body) throws Exception {
        Request request = new Request.Builder().url(url).post(RequestBody.create(null, (String)body)).addHeader("Content-Type", "application/soap+xml").build();
        Response response = null;
        try {
            response = OkHttpClientSingleton.getInstance().newCall(request).execute();
        }
        catch (Exception e) {
            LOGGER.debug("\u8fde\u63a5[" + url + "]\u5f02\u5e38");
            throw e;
        }
        LOGGER.debug("\u8fde\u63a5 url=[" + url + "], \u53d1\u9001[" + body + "],  \u8fd4\u56de[" + response.toString() + "]");
        LOGGER.debug("response code = " + response.code());
        if (response.isSuccessful()) {
            String s = response.body().string();
            return s;
        }
        if (response.code() >= 400 && response.code() < 500) {
            throw new Exception("\u8bbe\u5907\u8ba4\u8bc1\u5931\u8d25(\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef)");
        }
        LOGGER.debug("\u8fd4\u56de\u4e0d\u6210\u529f:  " + response.body().string());
        throw new Exception("\u8fd4\u56de\u4e0d\u6210\u529f");
    }

    public byte[] getFile(String url, String authorization) throws Exception {
        if (authorization == null) {
            authorization = "NOAuthorization";
        }
        Request request = new Request.Builder().url(url).addHeader("Authorization", authorization).build();
        Response response = null;
        try {
            response = OkHttpClientSingleton.getInstance().newCall(request).execute();
        }
        catch (Exception e) {
            LOGGER.debug("\u8fde\u63a5[" + url + "]\u5f02\u5e38");
            throw new RuntimeException(e);
        }
        if (response.isSuccessful()) {
            if (response.body() != null) {
                return response.body().bytes();
            }
            return new byte[0];
        }
        return new byte[0];
    }
}

