/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.jcache.copy;

import com.github.benmanes.caffeine.jcache.copy.Copier;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.jspecify.annotations.NullMarked;

@NullMarked
public abstract class AbstractCopier<A>
implements Copier {
    private static final Map<Class<?>, Function<Object, Object>> JAVA_DEEP_COPY = Map.of(Date.class, o -> ((Date)o).clone(), GregorianCalendar.class, o -> ((GregorianCalendar)o).clone());
    private static final Set<Class<?>> JAVA_IMMUTABLE = Set.of(Boolean.class, Byte.class, Character.class, Double.class, Float.class, Short.class, Integer.class, Long.class, BigInteger.class, BigDecimal.class, String.class, Class.class, UUID.class, URL.class, URI.class, Pattern.class, Inet4Address.class, Inet6Address.class, InetSocketAddress.class, LocalDate.class, LocalTime.class, LocalDateTime.class, Instant.class, Duration.class);
    private final Set<Class<?>> immutableClasses;
    private final Map<Class<?>, Function<Object, Object>> deepCopyStrategies;

    protected AbstractCopier() {
        this(AbstractCopier.javaImmutableClasses(), AbstractCopier.javaDeepCopyStrategies());
    }

    protected AbstractCopier(Set<Class<?>> immutableClasses, Map<Class<?>, Function<Object, Object>> deepCopyStrategies) {
        this.immutableClasses = Objects.requireNonNull(immutableClasses);
        this.deepCopyStrategies = Objects.requireNonNull(deepCopyStrategies);
    }

    public static Set<Class<?>> javaImmutableClasses() {
        return JAVA_IMMUTABLE;
    }

    public static Map<Class<?>, Function<Object, Object>> javaDeepCopyStrategies() {
        return JAVA_DEEP_COPY;
    }

    @Override
    public <T> T copy(T object, ClassLoader classLoader) {
        Objects.requireNonNull(object);
        Objects.requireNonNull(classLoader);
        if (this.isImmutable(object.getClass())) {
            return object;
        }
        if (this.isArrayOfImmutableTypes(object.getClass())) {
            return AbstractCopier.arrayCopy(object);
        }
        Function<Object, Object> deeplyCopyStrategy = this.deepCopyStrategies.get(object.getClass());
        if (deeplyCopyStrategy != null) {
            Object copy = deeplyCopyStrategy.apply(object);
            return (T)copy;
        }
        return this.roundtrip(object, classLoader);
    }

    protected boolean isImmutable(Class<?> clazz) {
        return this.immutableClasses.contains(clazz) || clazz.isEnum();
    }

    protected boolean canDeeplyCopy(Class<?> clazz) {
        return this.deepCopyStrategies.containsKey(clazz);
    }

    private boolean isArrayOfImmutableTypes(Class<?> clazz) {
        if (!clazz.isArray()) {
            return false;
        }
        Class<?> component = clazz.getComponentType();
        return component.isPrimitive() || this.isImmutable(component);
    }

    private static <T> T arrayCopy(T object) {
        int length = Array.getLength(object);
        Object copy = Array.newInstance(object.getClass().getComponentType(), length);
        System.arraycopy(object, 0, copy, 0, length);
        return (T)copy;
    }

    protected <T> T roundtrip(T object, ClassLoader classLoader) {
        A data = this.serialize(object);
        Object copy = this.deserialize(data, classLoader);
        return (T)copy;
    }

    protected abstract A serialize(Object var1);

    protected abstract Object deserialize(A var1, ClassLoader var2);
}

