/*
 * Decompiled with CFR 0.152.
 */
package com.epages.restdocs;

import com.epages.restdocs.ResponseFieldTemplateDescriptor;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.List;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplate;

class ResponseTemplateProcessor {
    private final List<ResponseFieldTemplateDescriptor> templateDescriptors;
    private UriTemplate uriTemplate;
    private String responseBody;

    ResponseTemplateProcessor(List<ResponseFieldTemplateDescriptor> templateDescriptors, UriTemplate uriTemplate, String responseBody) {
        this.templateDescriptors = templateDescriptors;
        this.uriTemplate = uriTemplate;
        this.responseBody = responseBody;
    }

    String replaceTemplateFields() {
        if (this.templateDescriptors.isEmpty()) {
            return this.responseBody;
        }
        DocumentContext documentContext = JsonPath.parse((String)this.responseBody);
        for (ResponseFieldTemplateDescriptor descriptor : this.templateDescriptors) {
            String expression = null;
            if (this.uriTemplate != null && !this.uriTemplate.getVariableNames().isEmpty()) {
                expression = this.preProcessUriTemplateVariableNameExpression(descriptor);
            } else if (descriptor.getUriTemplateVariableName() != null) {
                throw new IllegalArgumentException("Descriptor for field '" + descriptor.getPath() + "' specifies a 'replacedWithUriTemplateVariableValue' but no URI Template could be found in. Make sure to construct your request with the methods in org.springframework.restdocs.mockmvc.RestDocumentationRequestBuilders that use URI templates");
            }
            if (expression == null) {
                if (descriptor.getWireMockTemplateExpression() == null) {
                    throw new IllegalArgumentException("Descriptor for field '" + descriptor.getPath() + "' contains no replacedWithWireMockTemplateExpression");
                }
                expression = "{{" + descriptor.getWireMockTemplateExpression() + "}}";
            }
            documentContext.set(descriptor.getPath(), (Object)expression, new Predicate[0]);
        }
        return documentContext.jsonString();
    }

    private String preProcessUriTemplateVariableNameExpression(ResponseFieldTemplateDescriptor descriptor) {
        if (descriptor.getUriTemplateVariableName() != null) {
            return "{{request.requestLine.pathSegments.[" + this.getIndexOfUriVariableInPath(descriptor.getUriTemplateVariableName()) + "]}}";
        }
        return null;
    }

    private int getIndexOfUriVariableInPath(String variableName) {
        List pathSegments = UriComponentsBuilder.fromUriString((String)this.uriTemplate.toString()).build().getPathSegments();
        for (int i = 0; i < pathSegments.size(); ++i) {
            if (!((String)pathSegments.get(i)).contains(variableName)) continue;
            return i;
        }
        throw new IllegalArgumentException("Could not find variableName '" + variableName + "' in URL Template - present variables are '" + this.uriTemplate.getVariableNames() + "'");
    }
}

