/*
 * Decompiled with CFR 0.152.
 */
package com.edb.core;

import com.edb.core.Field;
import com.edb.core.Query;
import com.edb.core.QueryExecutor;
import com.edb.core.ResultCursor;
import com.edb.core.ResultHandlerBase;
import com.edb.core.Tuple;
import com.edb.util.GT;
import com.edb.util.PSQLException;
import com.edb.util.PSQLState;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SetupQueryRunner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @Nullable Tuple run(QueryExecutor executor, String queryString, boolean wantResults) throws SQLException {
        Query query = executor.createSimpleQuery(queryString);
        SimpleResultHandler handler = new SimpleResultHandler();
        int flags = 1041;
        if (!wantResults) {
            flags |= 6;
        }
        try {
            executor.execute(query, null, handler, 0, 0, flags, false, false);
        }
        finally {
            query.close();
        }
        if (!wantResults) {
            return null;
        }
        List<Tuple> tuples = handler.getResults();
        if (tuples == null || tuples.size() != 1) {
            throw new PSQLException(GT.tr("An unexpected result was returned by a query.", new Object[0]), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
        }
        return tuples.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Tuple> runwithResults(QueryExecutor executor, String queryString) throws SQLException {
        Query query = executor.createSimpleQuery(queryString);
        SimpleResultHandler handler = new SimpleResultHandler();
        int flags = 1041;
        try {
            executor.execute(query, null, handler, 0, 0, flags, false, false);
        }
        finally {
            query.close();
        }
        List<Tuple> tuples = handler.getResults();
        if (tuples == null || tuples.size() < 1) {
            return null;
        }
        return tuples;
    }

    private static class SimpleResultHandler
    extends ResultHandlerBase {
        private @Nullable List<Tuple> tuples;

        private SimpleResultHandler() {
        }

        @Nullable List<Tuple> getResults() {
            return this.tuples;
        }

        @Override
        public void handleResultRows(Query fromQuery, Field[] fields, List<Tuple> tuples, @Nullable ResultCursor cursor) {
            this.tuples = tuples;
        }

        @Override
        public void handleWarning(SQLWarning warning) {
        }
    }
}

