/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.PluginGradlePreconditions;
import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.FormatterProperties;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.markdown.FreshMarkStep;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import javax.inject.Inject;
import org.gradle.api.Action;

public class FreshMarkExtension
extends FormatExtension {
    static final String NAME = "freshmark";
    public final List<Action<Map<String, Object>>> propertyActions = new ArrayList<Action<Map<String, Object>>>();

    @Inject
    public FreshMarkExtension(SpotlessExtension spotless) {
        super(spotless);
        this.addStep(FreshMarkStep.create(Map.of(), (Provisioner)this.provisioner()));
    }

    public void properties(Action<Map<String, Object>> action) {
        this.propertyActions.add(Objects.requireNonNull(action));
    }

    public void propertiesFile(Object ... files) {
        PluginGradlePreconditions.requireElementsNonNull(files);
        this.propertyActions.add((Action<Map<String, Object>>)((Action)map -> {
            FormatterProperties preferences = FormatterProperties.from((Iterable)this.getProject().files(files));
            preferences.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> map.put(key.toString(), value)));
        }));
    }

    @Override
    protected void setupTask(SpotlessTask task) {
        if (this.target == null) {
            throw this.noDefaultTargetException();
        }
        TreeMap props = new TreeMap();
        this.propertyActions.forEach(action -> action.execute((Object)props));
        this.replaceStep(FreshMarkStep.create(props, (Provisioner)this.provisioner()));
        super.setupTask(task);
    }
}

