/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.java;

import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.java.CleanthatJavaStep;
import com.diffplug.spotless.java.GoogleJavaFormatStep;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public final class RemoveUnusedImportsStep
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final String NAME = "removeUnusedImports";
    static final String GJF = "google-java-format";
    static final String CLEANTHAT = "cleanthat-javaparser-unnecessaryimport";
    private static final String CLEANTHAT_MUTATOR = "UnnecessaryImport";

    private RemoveUnusedImportsStep() {
    }

    public static String defaultFormatter() {
        return GJF;
    }

    public static FormatterStep create(Provisioner provisioner) {
        return RemoveUnusedImportsStep.create(GJF, provisioner);
    }

    public static FormatterStep create(String unusedImportRemover, Provisioner provisioner) {
        Objects.requireNonNull(provisioner, "provisioner");
        switch (unusedImportRemover) {
            case "google-java-format": {
                return GoogleJavaFormatStep.createRemoveUnusedImportsOnly(provisioner);
            }
            case "cleanthat-javaparser-unnecessaryimport": {
                return CleanthatJavaStep.createWithStepName(NAME, CleanthatJavaStep.defaultGroupArtifact(), CleanthatJavaStep.defaultVersion(), "99.9", List.of(CLEANTHAT_MUTATOR), List.of(), false, provisioner);
            }
        }
        throw new IllegalArgumentException("Invalid unusedImportRemover: " + unusedImportRemover);
    }
}

