/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.groovy;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import java.io.BufferedReader;
import java.io.Serializable;
import java.io.StringReader;

public final class RemoveSemicolonsStep
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String NAME = "Remove unnecessary semicolons";

    private RemoveSemicolonsStep() {
    }

    public static FormatterStep create() {
        return FormatterStep.create(NAME, new State(), State::toFormatter);
    }

    private static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private State() {
        }

        FormatterFunc toFormatter() {
            return raw -> {
                try (BufferedReader reader = new BufferedReader(new StringReader(raw));){
                    String line;
                    StringBuilder result = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        result.append(this.removeSemicolon(line));
                        result.append(System.lineSeparator());
                    }
                    String string = result.toString();
                    return string;
                }
            };
        }

        private String removeSemicolon(String line) {
            int lastSemicolon = line.lastIndexOf(";");
            if (lastSemicolon != -1 && lastSemicolon == line.length() - 1) {
                return line.substring(0, lastSemicolon);
            }
            return line;
        }
    }
}

