/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.glue.markdown;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.markdown.FlexmarkConfig;
import com.vladsch.flexmark.formatter.Formatter;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.ParserEmulationProfile;
import com.vladsch.flexmark.parser.PegdownExtensions;
import com.vladsch.flexmark.profile.pegdown.PegdownOptionsAdapter;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import com.vladsch.flexmark.util.misc.Extension;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FlexmarkFormatterFunc
implements FormatterFunc {
    private static final Map<String, String> KNOWN_EXTENSIONS = new HashMap<String, String>();
    private final Parser parser;
    private final Formatter formatter;

    public FlexmarkFormatterFunc(FlexmarkConfig config) {
        ParserEmulationProfile emulationProfile = ParserEmulationProfile.valueOf((String)config.getEmulationProfile());
        MutableDataHolder parserOptions = FlexmarkFormatterFunc.createParserOptions(emulationProfile, config);
        MutableDataHolder formatterOptions = FlexmarkFormatterFunc.createFormatterOptions(parserOptions, emulationProfile);
        this.parser = Parser.builder((DataHolder)parserOptions).build();
        this.formatter = Formatter.builder((DataHolder)formatterOptions).build();
    }

    private static MutableDataHolder createParserOptions(ParserEmulationProfile emulationProfile, FlexmarkConfig config) {
        int pegdownExtensions = FlexmarkFormatterFunc.buildPegdownExtensions(config.getPegdownExtensions());
        Extension[] extensions = FlexmarkFormatterFunc.buildExtensions(config.getExtensions());
        MutableDataHolder parserOptions = PegdownOptionsAdapter.flexmarkOptions((int)pegdownExtensions, (Extension[])extensions).toMutable();
        parserOptions.set(Parser.PARSER_EMULATION_PROFILE, (Object)emulationProfile);
        return parserOptions;
    }

    private static int buildPegdownExtensions(List<String> config) {
        int extensions = 0;
        for (String str : config) {
            if (str.matches("\\d+")) {
                extensions |= Integer.parseInt(str);
                continue;
            }
            if (str.matches("(0x|0X)?[a-fA-F0-9]+")) {
                extensions |= Integer.decode(str).intValue();
                continue;
            }
            try {
                Field field = PegdownExtensions.class.getField(str);
                extensions |= field.getInt(null);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalArgumentException("Unknown PegdownExtension '" + str + "'");
            }
        }
        return extensions;
    }

    private static Extension[] buildExtensions(List<String> config) {
        Extension[] extensions = new Extension[config.size()];
        for (int i = 0; i < extensions.length; ++i) {
            String className = KNOWN_EXTENSIONS.getOrDefault(config.get(i), config.get(i));
            try {
                Class<?> c = Extension.class.getClassLoader().loadClass(className);
                Method create = c.getMethod("create", new Class[0]);
                extensions[i] = (Extension)Extension.class.cast(create.invoke(null, new Object[0]));
                continue;
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalArgumentException("Unknown flexmark extension '" + config.get(i) + "'");
            }
        }
        return extensions;
    }

    private static MutableDataHolder createFormatterOptions(MutableDataHolder parserOptions, ParserEmulationProfile emulationProfile) {
        MutableDataSet formatterOptions = new MutableDataSet();
        formatterOptions.set(Parser.EXTENSIONS, (Object)((Collection)Parser.EXTENSIONS.get((DataHolder)parserOptions)));
        formatterOptions.set(Formatter.FORMATTER_EMULATION_PROFILE, (Object)emulationProfile);
        return formatterOptions;
    }

    @Override
    public String apply(String input) throws Exception {
        Document parsedMarkdown = this.parser.parse(input);
        return this.formatter.render((Node)parsedMarkdown);
    }

    static {
        KNOWN_EXTENSIONS.put("Abbreviation", "com.vladsch.flexmark.ext.abbreviation.AbbreviationExtension");
        KNOWN_EXTENSIONS.put("Admonition", "com.vladsch.flexmark.ext.admonition.AdmonitionExtension");
        KNOWN_EXTENSIONS.put("Aside", "com.vladsch.flexmark.ext.aside.AsideExtension");
        KNOWN_EXTENSIONS.put("Attributes", "com.vladsch.flexmark.ext.attributes.AttributesExtension");
        KNOWN_EXTENSIONS.put("Definition", "com.vladsch.flexmark.ext.definition.DefinitionExtension");
        KNOWN_EXTENSIONS.put("Emoji", "com.vladsch.flexmark.ext.emoji.EmojiExtension");
        KNOWN_EXTENSIONS.put("EnumeratedReference", "com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceExtension");
        KNOWN_EXTENSIONS.put("Footnote", "com.vladsch.flexmark.ext.footnotes.FootnoteExtension");
        KNOWN_EXTENSIONS.put("GitLab", "com.vladsch.flexmark.ext.gitlab.GitLabExtension");
        KNOWN_EXTENSIONS.put("JekyllFrontMatter", "com.vladsch.flexmark.ext.jekyll.front.matter.JekyllFrontMatterExtension");
        KNOWN_EXTENSIONS.put("JekyllTag", "com.vladsch.flexmark.ext.jekyll.tag.JekyllTagExtension");
        KNOWN_EXTENSIONS.put("Macros", "com.vladsch.flexmark.ext.macros.MacrosExtension");
        KNOWN_EXTENSIONS.put("SimToc", "com.vladsch.flexmark.ext.toc.SimTocExtension");
        KNOWN_EXTENSIONS.put("Tables", "com.vladsch.flexmark.ext.tables.TablesExtension");
        KNOWN_EXTENSIONS.put("TaskList", "com.vladsch.flexmark.ext.gfm.tasklist.TaskListExtension");
        KNOWN_EXTENSIONS.put("WikiLink", "com.vladsch.flexmark.ext.wikilink.WikiLinkExtension");
        KNOWN_EXTENSIONS.put("YamlFrontMatter", "com.vladsch.flexmark.ext.yaml.front.matter.YamlFrontMatterExtension");
    }
}

