/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.RingBufferByteArrayOutputStream;
import com.diffplug.spotless.ThrowingEx;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ProcessRunner
implements AutoCloseable {
    private final ExecutorService threadStdOut = Executors.newSingleThreadExecutor();
    private final ExecutorService threadStdErr = Executors.newSingleThreadExecutor();
    private final ByteArrayOutputStream bufStdOut;
    private final ByteArrayOutputStream bufStdErr;

    public ProcessRunner() {
        this(-1);
    }

    public static ProcessRunner usingRingBuffersOfCapacity(int limit) {
        return new ProcessRunner(limit);
    }

    private ProcessRunner(int limitedBuffers) {
        this.bufStdOut = limitedBuffers >= 0 ? new RingBufferByteArrayOutputStream(limitedBuffers) : new ByteArrayOutputStream();
        this.bufStdErr = limitedBuffers >= 0 ? new RingBufferByteArrayOutputStream(limitedBuffers) : new ByteArrayOutputStream();
    }

    public Result shell(String cmd) throws IOException, InterruptedException {
        return this.shellWinUnix(cmd, cmd);
    }

    public Result shellWinUnix(String cmdWin, String cmdUnix) throws IOException, InterruptedException {
        return this.shellWinUnix(null, null, cmdWin, cmdUnix);
    }

    public Result shellWinUnix(@Nullable File cwd, @Nullable Map<String, String> environment, String cmdWin, String cmdUnix) throws IOException, InterruptedException {
        List<String> args = FileSignature.machineIsWin() ? Arrays.asList("cmd", "/c", cmdWin) : Arrays.asList("sh", "-c", cmdUnix);
        return this.exec(cwd, environment, null, args);
    }

    public Result exec(String ... args) throws IOException, InterruptedException {
        return this.exec(Arrays.asList(args));
    }

    public Result exec(@Nullable byte[] stdin, String ... args) throws IOException, InterruptedException {
        return this.exec(stdin, Arrays.asList(args));
    }

    public Result exec(List<String> args) throws IOException, InterruptedException {
        return this.exec(null, args);
    }

    public Result exec(@Nullable byte[] stdin, List<String> args) throws IOException, InterruptedException {
        return this.exec(null, null, stdin, args);
    }

    public Result exec(@Nullable File cwd, @Nullable Map<String, String> environment, @Nullable byte[] stdin, List<String> args) throws IOException, InterruptedException {
        LongRunningProcess process = this.start(cwd, environment, stdin, args);
        try {
            process.waitFor();
            return process.result();
        }
        catch (ExecutionException e) {
            throw ThrowingEx.asRuntime(e);
        }
    }

    public LongRunningProcess start(@Nullable File cwd, @Nullable Map<String, String> environment, @Nullable byte[] stdin, List<String> args) throws IOException {
        return this.start(cwd, environment, stdin, false, args);
    }

    public LongRunningProcess start(@Nullable File cwd, @Nullable Map<String, String> environment, @Nullable byte[] stdin, boolean redirectErrorStream, List<String> args) throws IOException {
        this.checkState();
        ProcessBuilder builder = new ProcessBuilder(args);
        if (cwd != null) {
            builder.directory(cwd);
        }
        if (environment != null) {
            builder.environment().putAll(environment);
        }
        if (stdin == null) {
            stdin = new byte[]{};
        }
        if (redirectErrorStream) {
            builder.redirectErrorStream(true);
        }
        Process process = builder.start();
        Future<byte[]> outputFut = this.threadStdOut.submit(() -> ProcessRunner.drainToBytes(process.getInputStream(), this.bufStdOut));
        Future<byte[]> errorFut = null;
        if (!redirectErrorStream) {
            errorFut = this.threadStdErr.submit(() -> ProcessRunner.drainToBytes(process.getErrorStream(), this.bufStdErr));
        }
        process.getOutputStream().write(stdin);
        process.getOutputStream().flush();
        process.getOutputStream().close();
        return new LongRunningProcess(process, args, outputFut, errorFut);
    }

    private static void drain(InputStream input, OutputStream output) throws IOException {
        int numRead;
        byte[] buf = new byte[1024];
        while ((numRead = input.read(buf)) != -1) {
            output.write(buf, 0, numRead);
        }
    }

    private static byte[] drainToBytes(InputStream input, ByteArrayOutputStream buffer) throws IOException {
        buffer.reset();
        ProcessRunner.drain(input, buffer);
        return buffer.toByteArray();
    }

    @Override
    public void close() {
        this.threadStdOut.shutdown();
        this.threadStdErr.shutdown();
    }

    private void checkState() {
        if (this.threadStdOut.isShutdown() || this.threadStdErr.isShutdown()) {
            throw new IllegalStateException("ProcessRunner has been closed and must not be used anymore.");
        }
    }

    public static class Result {
        private final List<String> args;
        private final int exitCode;
        private final byte[] stdOut;
        private final byte[] stdErr;

        public Result(@Nonnull List<String> args, int exitCode, @Nonnull byte[] stdOut, @Nullable byte[] stdErr) {
            this.args = args;
            this.exitCode = exitCode;
            this.stdOut = stdOut;
            this.stdErr = stdErr == null ? new byte[]{} : stdErr;
        }

        public List<String> args() {
            return this.args;
        }

        public int exitCode() {
            return this.exitCode;
        }

        public byte[] stdOut() {
            return this.stdOut;
        }

        public byte[] stdErr() {
            return this.stdErr;
        }

        public String stdOutUtf8() {
            return new String(this.stdOut, StandardCharsets.UTF_8);
        }

        public String stdErrUtf8() {
            return new String(this.stdErr, StandardCharsets.UTF_8);
        }

        public boolean exitNotZero() {
            return this.exitCode != 0;
        }

        public String assertExitZero(Charset charset) {
            if (this.exitCode == 0) {
                return new String(this.stdOut, charset);
            }
            throw new RuntimeException(this.toString());
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("> arguments: ").append(this.args).append("\n");
            builder.append("> exit code: ").append(this.exitCode).append("\n");
            BiConsumer<String, byte[]> perStream = (name, content) -> {
                String string = new String((byte[])content, Charset.defaultCharset()).trim();
                if (string.isEmpty()) {
                    builder.append("> ").append((String)name).append(": (empty)\n");
                } else {
                    String[] lines = string.replace("\r", "").split("\n");
                    if (lines.length == 1) {
                        builder.append("> " + name + ": " + lines[0] + "\n");
                    } else {
                        builder.append("> ").append((String)name).append(": (below)\n");
                        for (String line : lines) {
                            builder.append("> ");
                            builder.append(line);
                            builder.append('\n');
                        }
                    }
                }
            };
            perStream.accept("   stdout", this.stdOut);
            if (this.stdErr.length > 0) {
                perStream.accept("   stderr", this.stdErr);
            }
            return builder.toString();
        }
    }

    public class LongRunningProcess
    extends Process
    implements AutoCloseable {
        private final Process delegate;
        private final List<String> args;
        private final Future<byte[]> outputFut;
        private final Future<byte[]> errorFut;

        public LongRunningProcess(@Nonnull Process delegate, @Nonnull List<String> args, @Nullable Future<byte[]> outputFut, Future<byte[]> errorFut) {
            this.delegate = Objects.requireNonNull(delegate);
            this.args = args;
            this.outputFut = outputFut;
            this.errorFut = errorFut;
        }

        @Override
        public OutputStream getOutputStream() {
            return this.delegate.getOutputStream();
        }

        @Override
        public InputStream getInputStream() {
            return this.delegate.getInputStream();
        }

        @Override
        public InputStream getErrorStream() {
            return this.delegate.getErrorStream();
        }

        @Override
        public int waitFor() throws InterruptedException {
            return this.delegate.waitFor();
        }

        @Override
        public boolean waitFor(long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate.waitFor(timeout, unit);
        }

        @Override
        public int exitValue() {
            return this.delegate.exitValue();
        }

        @Override
        public void destroy() {
            this.delegate.destroy();
        }

        @Override
        public Process destroyForcibly() {
            return this.delegate.destroyForcibly();
        }

        @Override
        public boolean isAlive() {
            return this.delegate.isAlive();
        }

        public Result result() throws ExecutionException, InterruptedException {
            int exitCode = this.waitFor();
            return new Result(this.args, exitCode, this.outputFut.get(), this.errorFut != null ? this.errorFut.get() : null);
        }

        @Override
        public void close() {
            if (this.isAlive()) {
                this.destroy();
            }
            ProcessRunner.this.close();
        }
    }
}

