/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.reflect;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ReflectionUtils {
    public static Map<String, Method> buildAccessorMap(Class<?> c) {
        return Arrays.stream(c.getDeclaredMethods()).filter(m -> m.getParameterCount() == 0).collect(Collectors.toMap(Method::getName, Function.identity(), ReflectionUtils::zeroParameterMethodPreference, LinkedHashMap::new));
    }

    public static Map<String, Method> buildInjectorMap(Class<?> c) {
        return Arrays.stream(c.getDeclaredMethods()).filter(m -> m.getParameterCount() == 1).collect(Collectors.toMap(Method::getName, Function.identity(), ReflectionUtils::oneParameterMethodPreference, LinkedHashMap::new));
    }

    public static Method zeroParameterMethodPreference(Method method1, Method method2) {
        return method1.getParameterCount() == 0 ? method1 : method2;
    }

    public static Method oneParameterMethodPreference(Method method1, Method method2) {
        return method1.getParameterCount() == 1 ? method1 : method2;
    }
}

