/*
 * Decompiled with CFR 0.152.
 */
package com.caverock.androidsvg;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Paint;
import android.graphics.Picture;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.PictureDrawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import com.caverock.androidsvg.R;
import com.caverock.androidsvg.RenderOptions;
import com.caverock.androidsvg.SVG;
import com.caverock.androidsvg.SVGParseException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;

public class SVGImageView
extends ImageView {
    private SVG svg = null;
    private RenderOptions renderOptions = new RenderOptions();
    private static Method setLayerTypeMethod = null;

    public SVGImageView(Context context) {
        super(context);
    }

    public SVGImageView(Context context, AttributeSet attrs) {
        super(context, attrs, 0);
        this.init(attrs, 0);
    }

    public SVGImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs, defStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(AttributeSet attrs, int defStyle) {
        if (this.isInEditMode()) {
            return;
        }
        TypedArray a = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.SVGImageView, defStyle, 0);
        try {
            int resourceId;
            String css = a.getString(R.styleable.SVGImageView_css);
            if (css != null) {
                this.renderOptions.css(css);
            }
            if ((resourceId = a.getResourceId(R.styleable.SVGImageView_svg, -1)) != -1) {
                this.setImageResource(resourceId);
                return;
            }
            String url = a.getString(R.styleable.SVGImageView_svg);
            if (url != null) {
                Uri uri = Uri.parse((String)url);
                if (this.internalSetImageURI(uri)) {
                    return;
                }
                if (this.internalSetImageAsset(url)) {
                    return;
                }
                this.setFromString(url);
            }
        }
        finally {
            a.recycle();
        }
    }

    public void setSVG(SVG svg) {
        if (svg == null) {
            throw new IllegalArgumentException("Null value passed to setSVG()");
        }
        this.svg = svg;
        this.doRender();
    }

    public void setSVG(SVG svg, String css) {
        if (svg == null) {
            throw new IllegalArgumentException("Null value passed to setSVG()");
        }
        this.svg = svg;
        this.renderOptions.css(css);
        this.doRender();
    }

    public void setCSS(String css) {
        this.renderOptions.css(css);
        this.doRender();
    }

    public void setImageResource(int resourceId) {
        new LoadResourceTask(this.getContext(), resourceId).execute(new Integer[0]);
    }

    public void setImageURI(Uri uri) {
        if (!this.internalSetImageURI(uri)) {
            Log.e((String)"SVGImageView", (String)("File not found: " + uri));
        }
    }

    public void setImageAsset(String filename) {
        if (!this.internalSetImageAsset(filename)) {
            Log.e((String)"SVGImageView", (String)("File not found: " + filename));
        }
    }

    private boolean internalSetImageURI(Uri uri) {
        try {
            InputStream is = this.getContext().getContentResolver().openInputStream(uri);
            new LoadURITask().execute(new InputStream[]{is});
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    private boolean internalSetImageAsset(String filename) {
        try {
            InputStream is = this.getContext().getAssets().open(filename);
            new LoadURITask().execute(new InputStream[]{is});
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private void setFromString(String url) {
        try {
            this.svg = SVG.getFromString(url);
            this.doRender();
        }
        catch (SVGParseException e) {
            Log.e((String)"SVGImageView", (String)("Could not find SVG at: " + url));
        }
    }

    private void setSoftwareLayerType() {
        if (setLayerTypeMethod == null) {
            return;
        }
        try {
            int LAYER_TYPE_SOFTWARE = View.class.getField("LAYER_TYPE_SOFTWARE").getInt(new View(this.getContext()));
            setLayerTypeMethod.invoke((Object)this, LAYER_TYPE_SOFTWARE, null);
        }
        catch (Exception e) {
            Log.w((String)"SVGImageView", (String)"Unexpected failure calling setLayerType", (Throwable)e);
        }
    }

    private void doRender() {
        if (this.svg == null) {
            return;
        }
        Picture picture = this.svg.renderToPicture(this.renderOptions);
        this.setSoftwareLayerType();
        this.setImageDrawable((Drawable)new PictureDrawable(picture));
    }

    static {
        try {
            setLayerTypeMethod = View.class.getMethod("setLayerType", Integer.TYPE, Paint.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    private class LoadURITask
    extends AsyncTask<InputStream, Integer, SVG> {
        private LoadURITask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected SVG doInBackground(InputStream ... is) {
            try {
                SVG sVG = SVG.getFromInputStream(is[0]);
                return sVG;
            }
            catch (SVGParseException e) {
                Log.e((String)"SVGImageView", (String)("Parse error loading URI: " + e.getMessage()));
            }
            finally {
                try {
                    is[0].close();
                }
                catch (IOException iOException) {}
            }
            return null;
        }

        protected void onPostExecute(SVG svg) {
            SVGImageView.this.svg = svg;
            SVGImageView.this.doRender();
        }
    }

    private class LoadResourceTask
    extends AsyncTask<Integer, Integer, SVG> {
        private Context context;
        private int resourceId;

        LoadResourceTask(Context context, int resourceId) {
            this.context = context;
            this.resourceId = resourceId;
        }

        protected SVG doInBackground(Integer ... params) {
            try {
                return SVG.getFromResource(this.context, this.resourceId);
            }
            catch (SVGParseException e) {
                Log.e((String)"SVGImageView", (String)String.format("Error loading resource 0x%x: %s", this.resourceId, e.getMessage()));
                return null;
            }
        }

        protected void onPostExecute(SVG svg) {
            SVGImageView.this.svg = svg;
            SVGImageView.this.doRender();
        }
    }
}

