/*
 * Decompiled with CFR 0.152.
 */
package com.burgstaller.okhttp.basic;

import com.burgstaller.okhttp.digest.CachingAuthenticator;
import com.burgstaller.okhttp.digest.Credentials;
import java.io.IOException;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import okhttp3.internal.platform.Platform;

public class BasicAuthenticator
implements CachingAuthenticator {
    private final Credentials credentials;

    public BasicAuthenticator(Credentials credentials) {
        this.credentials = credentials;
    }

    public Request authenticate(Route route, Response response) throws IOException {
        Request request = response.request();
        return this.authFromRequest(request);
    }

    private Request authFromRequest(Request request) {
        String authorizationHeader = request.header("Authorization");
        if (authorizationHeader != null && authorizationHeader.startsWith("Basic")) {
            Platform.get().log(5, "previous basic authentication failed, returning null", null);
            return null;
        }
        String authValue = okhttp3.Credentials.basic((String)this.credentials.getUserName(), (String)this.credentials.getPassword());
        return request.newBuilder().header("Authorization", authValue).build();
    }

    @Override
    public Request authenticateWithState(Request request) throws IOException {
        return this.authFromRequest(request);
    }
}

