/*
 * Decompiled with CFR 0.152.
 */
package com.burgstaller.okhttp;

import com.burgstaller.okhttp.CachingUtils;
import com.burgstaller.okhttp.digest.CachingAuthenticator;
import java.io.IOException;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.platform.Platform;

public class AuthenticationCacheInterceptor
implements Interceptor {
    private final Map<String, CachingAuthenticator> authCache;

    public AuthenticationCacheInterceptor(Map<String, CachingAuthenticator> authCache) {
        this.authCache = authCache;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        HttpUrl url = request.url();
        String key = CachingUtils.getCachingKey(url);
        CachingAuthenticator authenticator = this.authCache.get(key);
        Request authRequest = null;
        if (authenticator != null) {
            authRequest = authenticator.authenticateWithState(request);
        }
        if (authRequest == null) {
            authRequest = request;
        }
        Response response = chain.proceed(authRequest);
        if (authenticator != null && response != null && response.code() == 401 && this.authCache.remove(key) != null) {
            response.body().close();
            Platform.get().log(4, "Cached authentication expired. Sending a new request.", null);
            response = chain.proceed(request);
        }
        return response;
    }
}

