/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.httpclient5;

import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.SystemDefaultDnsResolver;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.config.ConnectionConfig;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.config.RequestConfig;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.impl.classic.HttpClients;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.impl.io.DefaultHttpClientConnectionOperator;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.impl.io.ManagedHttpClientConnectionFactory;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.io.HttpClientConnectionOperator;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.io.ManagedHttpClientConnection;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.ClassicHttpResponse;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.ConnectionClosedException;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.Header;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.HttpHost;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.NameValuePair;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.impl.DefaultContentLengthStrategy;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.io.HttpConnectionFactory;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.io.SocketConfig;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.io.entity.EmptyInputStream;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.io.entity.InputStreamEntity;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.protocol.HttpCoreContext;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.net.URIAuthority;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.util.TimeValue;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.util.Timeout;
import com.github.dockerjava.httpclient5.HijackingHttpRequestExecutor;
import com.github.dockerjava.transport.DockerHttpClient;
import com.github.dockerjava.transport.NamedPipeSocket;
import com.github.dockerjava.transport.SSLConfig;
import com.github.dockerjava.transport.UnixSocket;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ApacheDockerHttpClientImpl
implements DockerHttpClient {
    private final CloseableHttpClient httpClient;
    private final HttpHost host;
    private final String pathPrefix;

    protected ApacheDockerHttpClientImpl(URI dockerHost, SSLConfig sslConfig, int maxConnections, Duration connectionTimeout, Duration responseTimeout) {
        SSLContext sslContext;
        try {
            sslContext = sslConfig != null ? sslConfig.getSSLContext() : null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        HttpClientConnectionOperator connectionOperator = this.createConnectionOperator(dockerHost, sslContext);
        switch (dockerHost.getScheme()) {
            case "unix": 
            case "npipe": {
                this.pathPrefix = "";
                this.host = new HttpHost(dockerHost.getScheme(), "localhost", 2375);
                break;
            }
            case "tcp": {
                String rawPath = dockerHost.getRawPath();
                this.pathPrefix = rawPath.endsWith("/") ? rawPath.substring(0, rawPath.length() - 1) : rawPath;
                this.host = new HttpHost(sslContext != null ? "https" : "http", dockerHost.getHost(), dockerHost.getPort());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported protocol scheme: " + dockerHost);
            }
        }
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(connectionOperator, null, null, null, (HttpConnectionFactory<ManagedHttpClientConnection>)new ManagedHttpClientConnectionFactory(null, null, null, null, message -> {
            Header transferEncodingHeader = message.getFirstHeader("Transfer-Encoding");
            if (transferEncodingHeader != null && "identity".equalsIgnoreCase(transferEncodingHeader.getValue())) {
                return -9223372036854775807L;
            }
            return DefaultContentLengthStrategy.INSTANCE.determineLength(message);
        }, null));
        connectionManager.setDefaultSocketConfig(SocketConfig.copy(SocketConfig.DEFAULT).setSoTimeout(Timeout.ZERO_MILLISECONDS).build());
        connectionManager.setMaxTotal(maxConnections);
        connectionManager.setDefaultMaxPerRoute(maxConnections);
        connectionManager.setDefaultConnectionConfig(ConnectionConfig.custom().setValidateAfterInactivity(TimeValue.NEG_ONE_SECOND).setConnectTimeout(connectionTimeout != null ? Timeout.of(connectionTimeout.toNanos(), TimeUnit.NANOSECONDS) : null).build());
        this.httpClient = HttpClients.custom().setRequestExecutor(new HijackingHttpRequestExecutor(null)).setConnectionManager(connectionManager).setDefaultRequestConfig(RequestConfig.custom().setResponseTimeout(responseTimeout != null ? Timeout.of(responseTimeout.toNanos(), TimeUnit.NANOSECONDS) : null).build()).disableConnectionState().build();
    }

    private HttpClientConnectionOperator createConnectionOperator(URI dockerHost, SSLContext sslContext) {
        String dockerHostScheme = dockerHost.getScheme();
        String dockerHostPath = dockerHost.getPath();
        DefaultClientTlsStrategy tlsSocketStrategy = sslContext != null ? new DefaultClientTlsStrategy(sslContext) : DefaultClientTlsStrategy.createSystemDefault();
        return new DefaultHttpClientConnectionOperator(socksProxy -> {
            if ("unix".equalsIgnoreCase(dockerHostScheme)) {
                return UnixSocket.get(dockerHostPath);
            }
            if ("npipe".equalsIgnoreCase(dockerHostScheme)) {
                return new NamedPipeSocket(dockerHostPath);
            }
            return socksProxy == null ? new Socket() : new Socket(socksProxy);
        }, DefaultSchemePortResolver.INSTANCE, SystemDefaultDnsResolver.INSTANCE, name -> "https".equalsIgnoreCase(name) ? tlsSocketStrategy : null);
    }

    @Override
    public DockerHttpClient.Response execute(DockerHttpClient.Request request) {
        HttpCoreContext context = new HttpCoreContext();
        HttpUriRequestBase httpUriRequest = new HttpUriRequestBase(request.method(), URI.create(this.pathPrefix + request.path()));
        httpUriRequest.setScheme(this.host.getSchemeName());
        httpUriRequest.setAuthority(new URIAuthority(this.host.getHostName(), this.host.getPort()));
        request.headers().forEach(httpUriRequest::addHeader);
        byte[] bodyBytes = request.bodyBytes();
        if (bodyBytes != null) {
            httpUriRequest.setEntity(new ByteArrayEntity(bodyBytes, null));
        } else {
            InputStream body = request.body();
            if (body != null) {
                httpUriRequest.setEntity(new InputStreamEntity(body, null));
            }
        }
        if (request.hijackedInput() != null) {
            context.setAttribute("com.github.docker-java.hijackedInput", request.hijackedInput());
            httpUriRequest.setHeader("Upgrade", "tcp");
            httpUriRequest.setHeader("Connection", "Upgrade");
        }
        try {
            ClassicHttpResponse response = this.httpClient.executeOpen(this.host, httpUriRequest, context);
            return new ApacheResponse(httpUriRequest, response);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    static class ApacheResponse
    implements DockerHttpClient.Response {
        private static final Logger LOGGER = LoggerFactory.getLogger(ApacheResponse.class);
        private final HttpUriRequestBase request;
        private final ClassicHttpResponse response;

        ApacheResponse(HttpUriRequestBase httpUriRequest, ClassicHttpResponse response) {
            this.request = httpUriRequest;
            this.response = response;
        }

        @Override
        public int getStatusCode() {
            return this.response.getCode();
        }

        @Override
        public Map<String, List<String>> getHeaders() {
            return Stream.of(this.response.getHeaders()).collect(Collectors.groupingBy(NameValuePair::getName, Collectors.mapping(NameValuePair::getValue, Collectors.toList())));
        }

        @Override
        public String getHeader(String name) {
            Header firstHeader = this.response.getFirstHeader(name);
            return firstHeader != null ? firstHeader.getValue() : null;
        }

        @Override
        public InputStream getBody() {
            try {
                return this.response.getEntity() != null ? this.response.getEntity().getContent() : EmptyInputStream.INSTANCE;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() {
            try {
                this.request.abort();
            }
            catch (Exception e) {
                LOGGER.debug("Failed to abort the request", (Throwable)e);
            }
            try {
                this.response.close();
            }
            catch (ConnectionClosedException e) {
                LOGGER.trace("Failed to close the response", (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.debug("Failed to close the response", (Throwable)e);
            }
        }
    }
}

