/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.shaded.org.bouncycastle.cms;

import com.bmuschko.gradle.docker.shaded.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.cms.CMSException;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.cms.CMSReadable;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.cms.CMSTypedData;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.util.Arrays;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CMSProcessableByteArray
implements CMSTypedData,
CMSReadable {
    private final ASN1ObjectIdentifier type;
    private final byte[] bytes;

    public CMSProcessableByteArray(byte[] byArray) {
        this(CMSObjectIdentifiers.data, byArray);
    }

    public CMSProcessableByteArray(ASN1ObjectIdentifier aSN1ObjectIdentifier, byte[] byArray) {
        this.type = aSN1ObjectIdentifier;
        this.bytes = byArray;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    @Override
    public void write(OutputStream outputStream) throws IOException, CMSException {
        outputStream.write(this.bytes);
    }

    @Override
    public Object getContent() {
        return Arrays.clone(this.bytes);
    }

    @Override
    public ASN1ObjectIdentifier getContentType() {
        return this.type;
    }
}

