/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.internal;

import com.bmuschko.gradle.docker.shaded.org.objectweb.asm.AnnotationVisitor;
import com.bmuschko.gradle.docker.shaded.org.objectweb.asm.ClassReader;
import com.bmuschko.gradle.docker.shaded.org.objectweb.asm.ClassVisitor;
import com.bmuschko.gradle.docker.shaded.org.objectweb.asm.MethodVisitor;
import com.bmuschko.gradle.docker.shaded.org.objectweb.asm.Type;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.Set;

public class MainClassFinder {
    private static final String DOT_CLASS = ".class";
    private static final String MAIN_METHOD_NAME = "main";
    private static final Type STRING_ARRAY_TYPE = Type.getType(String[].class);
    private static final Type MAIN_METHOD_TYPE = Type.getMethodType(Type.VOID_TYPE, STRING_ARRAY_TYPE);

    public static String findSingleMainClass(File rootFolder) throws IOException {
        return MainClassFinder.findSingleMainClass(rootFolder, null);
    }

    public static String findSingleMainClass(File rootFolder, String annotationName) throws IOException {
        SingleMainClassCallback callback = new SingleMainClassCallback(annotationName);
        MainClassFinder.doWithMainClasses(rootFolder, callback);
        return callback.getMainClassName();
    }

    public static <T> T doWithMainClasses(File rootFolder, MainClassCallback<T> callback) throws IOException {
        if (!rootFolder.exists()) {
            return null;
        }
        if (!rootFolder.isDirectory()) {
            throw new IllegalArgumentException("Invalid root folder '" + String.valueOf(rootFolder) + "'");
        }
        String prefix = rootFolder.getAbsolutePath() + "/";
        ArrayDeque<File> stack = new ArrayDeque<File>();
        stack.push(rootFolder);
        while (!stack.isEmpty()) {
            String className;
            T result;
            FileInputStream inputStream;
            ClassDescriptor classDescriptor;
            File file = (File)stack.pop();
            if (file.isFile() && (classDescriptor = MainClassFinder.createClassDescriptor(inputStream = new FileInputStream(file))) != null && classDescriptor.isMainMethodFound() && (result = callback.doWith(new MainClass(className = MainClassFinder.convertToClassName(file.getAbsolutePath(), prefix), classDescriptor.getAnnotationNames()))) != null) {
                return result;
            }
            if (!file.isDirectory()) continue;
            MainClassFinder.pushAllSorted(stack, file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() && !pathname.getName().startsWith(".");
                }
            }));
            MainClassFinder.pushAllSorted(stack, file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.getName().endsWith(MainClassFinder.DOT_CLASS);
                }
            }));
        }
        return null;
    }

    private static ClassDescriptor createClassDescriptor(InputStream inputStream) {
        ClassDescriptor classDescriptor;
        block8: {
            InputStream inputStream2 = inputStream;
            try {
                ClassReader classReader = new ClassReader(inputStream);
                ClassDescriptor classDescriptor2 = new ClassDescriptor();
                classReader.accept(classDescriptor2, 1);
                classDescriptor = classDescriptor2;
                if (inputStream2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream2 != null) {
                        try {
                            inputStream2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    return null;
                }
            }
            inputStream2.close();
        }
        return classDescriptor;
    }

    private static String convertToClassName(String name, String prefix) {
        name = name.replace("/", ".");
        name = name.replace("\\", ".");
        name = name.substring(0, name.length() - DOT_CLASS.length());
        if (prefix != null) {
            name = name.substring(prefix.length());
        }
        return name;
    }

    private static void pushAllSorted(Deque<File> stack, File[] files) {
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o2.compareTo(o1);
            }
        });
        for (File file : files) {
            stack.push(file);
        }
    }

    private static final class SingleMainClassCallback
    implements MainClassCallback<Object> {
        private final Set<MainClass> mainClasses = new LinkedHashSet<MainClass>();
        private final String annotationName;

        private SingleMainClassCallback(String annotationName) {
            this.annotationName = annotationName;
        }

        @Override
        public Object doWith(MainClass mainClass) {
            this.mainClasses.add(mainClass);
            return null;
        }

        private String getMainClassName() {
            LinkedHashSet<MainClass> matchingMainClasses = new LinkedHashSet<MainClass>();
            if (this.annotationName != null) {
                for (MainClass mainClass : this.mainClasses) {
                    if (!mainClass.getAnnotationNames().contains(this.annotationName)) continue;
                    matchingMainClasses.add(mainClass);
                }
            }
            if (matchingMainClasses.isEmpty()) {
                matchingMainClasses.addAll(this.mainClasses);
            }
            if (matchingMainClasses.size() > 1) {
                throw new IllegalStateException("Unable to find a single main class from the following candidates " + String.valueOf(matchingMainClasses));
            }
            return matchingMainClasses.isEmpty() ? null : ((MainClass)matchingMainClasses.iterator().next()).getName();
        }
    }

    public static interface MainClassCallback<T> {
        public T doWith(MainClass var1);
    }

    private static class ClassDescriptor
    extends ClassVisitor {
        private final Set<String> annotationNames = new LinkedHashSet<String>();
        private boolean mainMethodFound;

        public ClassDescriptor() {
            super(589824);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            this.annotationNames.add(Type.getType(desc).getClassName());
            return null;
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (this.isAccess(access, 1, 8) && MainClassFinder.MAIN_METHOD_NAME.equals(name) && MAIN_METHOD_TYPE.getDescriptor().equals(desc)) {
                this.mainMethodFound = true;
            }
            return null;
        }

        private boolean isAccess(int access, Integer ... requiredOpsCodes) {
            Integer[] integerArray = requiredOpsCodes;
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int requiredOpsCode = integerArray[i];
                if ((access & requiredOpsCode) != 0) continue;
                return false;
            }
            return true;
        }

        public boolean isMainMethodFound() {
            return this.mainMethodFound;
        }

        public Set<String> getAnnotationNames() {
            return this.annotationNames;
        }
    }

    public static final class MainClass {
        private final String name;
        private final Set<String> annotationNames;

        public MainClass(String name, Set<String> annotationNames) {
            this.name = name;
            this.annotationNames = Collections.unmodifiableSet(annotationNames);
        }

        public String getName() {
            return this.name;
        }

        public Set<String> getAnnotationNames() {
            return this.annotationNames;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!this.getClass().equals(obj.getClass())) {
                return false;
            }
            MainClass other = (MainClass)obj;
            return this.name.equals(other.getName());
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }
}

